function h = arrow(x,y, color, head_length)
%
% h = arrow(x,y, color, <head_length>)
%
%  x and y should be Nx2 arrays where each row is gives the start and end
%  coordinates for an arrow.
%
%  All arrows will have the same color.  Default is blue, if none is
%  specified.
%
%  Fraction of the arrow's length to use for the head.  Default is 0.2
%

if(nargin<3)
    color = 'b';
end

HEAD_ANGLE = pi/6;
HEAD_LENGTH_FRACTION = .3;
if(nargin>=4)
    HEAD_LENGTH_FRACTION = head_length;
end

xdiff = x(:,2) - x(:,1);
ydiff = y(:,2) - y(:,1);

angle = atan2(ydiff, xdiff);

n = length(angle);

head_length = sqrt(xdiff.^2 + ydiff.^2) * HEAD_LENGTH_FRACTION;
h(:,1) = plot(x',y', color);
tip_angles = angle*ones(1,2) + pi + ones(n,1)*[-HEAD_ANGLE HEAD_ANGLE]/2;
xtip_offsets = [head_length head_length].*cos(tip_angles);
ytip_offsets = [head_length head_length].*sin(tip_angles);
h(:,2) = plot(ones(3,1)*x(:,2)' + [xtip_offsets(:,1) zeros(n,1) xtip_offsets(:,2)]', ones(3,1)*y(:,2)' + [ytip_offsets(:,1) zeros(n,1) ytip_offsets(:,2)]', color);

% index = find(xdiff==0 & ydiff==0);
% if(~isempty(index))
%     h(:,3) = plot(x(index,1),y(index,1), [color '.'], 'MarkerSize', 12);
% end
