function interest_points = CreateDescriptors(x,y,s,scale, mag_pyramid, theta_pyramid, img_cracks, descriptor_samples, angles)
% interest_points = CreateDescriptors(x,y,s,scale, mag_pyramid,
%      theta_pyramid, img_cracks, descriptor_samples, angles)
%
%
% ------------
% Andrew Stein
%

if(nargin < 9)
    angles = [];
end

if(~mod(descriptor_samples,2))
    error('descriptor_samples must be odd!');
end

use_shape = false;

patch_size_multiplier = (descriptor_samples-1)/2;
%patch_size_multiplier = 5;

% For the dominant orientation histogram:
num_bins = 36;
bin_size = 10;

% [nrows, ncols] = size(img_edges);
[nrows, ncols] = size(img_cracks);

% % Compute the distance transform of the edge map.  This will be used as a
% % weighting factor for creating the descriptors below.
% edge_dist = bwdist(img_edges);

kept_ctr = 0;
extra_orientation_additions = 0;

% % Create a lookup table for easily finding neighbors
% % int_pts_lookup = cell(nrows, ncols);

for(i=1:length(x))
    
%     if(isempty(angles))
%         % Check to see if there's already an interest point in this vicinity.
%         %  (Note that the "vicinity" is proportional to the scale: Small-scale
%         %  features are permitted to exist closer together than large scale
%         %  ones.)
%         % If so, skip this point.
%         % If not, continue making a descriptor for it. We'll
%         % add it to the lookup table later, so we know it's final index and
%         % if multiple orientation versions also get created.
%         radius = round(scale(i));
%         xwin=[max(1,round(x(i)-radius)):min(ncols, round(x(i)+radius))];
%         ywin=[max(1,round(y(i)-radius)):min(nrows, round(y(i)+radius))];
%         neighbor_indices = [int_pts_lookup{ywin, xwin}];
%         if(~isempty(neighbor_indices))
%             % look at the difference between this new potential interest
%             % point's scale and the ones that are nearby spatially.  if it's
%             % too close, don't continue making a descriptor below.
%             if(any(abs(s(i) - [interest_points(neighbor_indices).scale_index]) <= min_scale_diff))
%                 continue;
%             end
%         end
%     end
    
    
    % Extract a patch of derivatives around the interest point for
    % determining orientation
%         weight_mask_sigma = 1.5*scale(i);
%         patch_halfwidth = ceil(3*weight_mask_sigma);
%         patch_width = 2*patch_halfwidth+1;
    % This larger window for seems to work better in terms of histogram
    % peak height:
%     patch_halfwidth = round(scale(i)*descriptor_halfwidth);
%     patch_width = 2*patch_halfwidth+1;
%     weight_mask_sigma = patch_halfwidth+0.5;
    patch_halfwidth = round(patch_size_multiplier*scale(i));
    patch_width = 2*patch_halfwidth + 1;
    weight_mask_sigma = patch_halfwidth+0.5;

    win = [-patch_halfwidth:patch_halfwidth];
    xloc = max(1, min(ncols, round(x(i)+win) ));
    yloc = max(1, min(nrows, round(y(i)+win) ));
    mag = mag_pyramid(yloc,xloc, s(i)); 
    theta = theta_pyramid(yloc,xloc, s(i)); 
        
    % Get any local edges for the same patch
    %     mask_edges = img_edges(yloc,xloc);
    %     local_edges_exist = any(mask_edges(:));
    patch_cracks =  img_cracks(yloc,xloc);
    local_edges_exist = any(patch_cracks(:));
    
    % Create a weighting mask for the orientation assignment
    if(local_edges_exist)
        
        %edge_dist_weight = bwdist(mask_edges);
        %edge_dist_weight = edge_dist(yloc,xloc);
        %edge_dist_weight = edge_dist_weight/max(edge_dist_weight(:));
        
        %             weight_mask = edge_dist_weight .* mexFastMarchMask(mask_edges, weight_mask_sigma);
        %         weight_mask = mexFastMarchMask(mask_edges, weight_mask_sigma);
        weight_mask = mexFastMarchMask_cracks(patch_cracks, weight_mask_sigma);
        weight_mask = weight_mask/max(weight_mask(:)); % Normalize
        
        % Otherwise, just use simple Gaussian masks:
    else
        %weight_mask = g_win{s(i)};
        weight_mask = CreateGaussianMask(patch_width, weight_mask_sigma);
        %desc_mask = g_win_desc{s(i)};
    end
    
    if(isempty(angles))    
        % Compute a histogram of orientations, weighted by their magnitudes and
        % distance from the interest point location.  Peaks of this histogram
        % will be used to assign the descriptor's orientation.
        theta(theta==360) = 0;
        hist_theta = mexWeighted_hist(theta, mag.*weight_mask, bin_size, num_bins);
    end
    
    %
    % Now extract the sample patch used for making the descriptor: 
    %
    %     patch_halfwidth = ceil(patch_size_multiplier*scale(i));
    patch_width = descriptor_samples;
    patch_halfwidth = (patch_width-1)/2;
    win =  ceil(patch_size_multiplier*scale(i)) * linspace(-1,1,descriptor_samples);
    
    % create the mask for weighting the decriptor's histogram bins:
    %  (this mask has a different sigma than the one used for
    %   determining orientation)
    % To avoid issues with downsampling the edge image, we're gonna create
    % a full resolution weight mask and downsample (and rotate) _that_
    % instead.
    if(local_edges_exist)
        full_res_win = [round(1.5*win(1)):round(1.5*win(end))];
        full_res_patch_width = length(full_res_win);
        full_res_xloc = max(1, min(ncols, round(x(i)) + full_res_win));
        full_res_yloc = max(1, min(nrows, round(y(i)) + full_res_win));
        %         mask_edges = img_edges(full_res_yloc,full_res_xloc);
        
        %             desc_mask = edge_dist_weight .* mexFastMarchMask(mask_edges, desc_mask_sigma);            
        %         desc_mask = mexFastMarchMask(mask_edges, win(end));            
        patch_cracks = img_cracks(full_res_yloc, full_res_xloc);
        desc_mask = mexFastMarchMask_cracks(patch_cracks, win(end));
        
        if(use_shape)
            %% Also, include the normals (pointing away from the feature
            %% point) in the orientation data which will be put into the
            %% descriptor.
            
            % first, compute the smooth normals
            [dx,dy] = smoothgradient(desc_mask, 3);
            
            % THen insert those normals with weight 1 into the orientation
            % patch
            index = find(patch_cracks);
            theta_shape = zeros(size(desc_mask));
            mag_shape = theta_shape;
            theta_shape(index) = 180/pi * atan2(dy(index),dx(index)) + 180;
%             mag_shape(index) = sum(mag(:))/length(index);
            mag_shape(index) = max(mag(:));

        end
        
    else
        desc_mask = CreateGaussianMask(patch_width, patch_halfwidth+0.5);
    end
    
    if(isempty(angles))
        
        % Find _local_ orientation histogram peaks within 80% of the
        % highest peak:
        peak_bins = find(hist_theta>0.8*max(hist_theta) & hist_theta>hist_theta([end 1:end-1]) & ...
            hist_theta>hist_theta([2:end 1]));
        
        % Just for informational purposes, keep track of how many 
        % interest points we add for extra orientations
        extra_orientation_additions = extra_orientation_additions + (length(peak_bins)-1);
        
        % create an interest point for each peak orientation:
        for(k = 1:length(peak_bins))
            
            % first, interpolate this peak's position by fitting a parabola:   
            index = [peak_bins(k) + [-1:1]]';
            if(peak_bins(k)==1)
                Y = hist_theta([num_bins 1:2])';
            elseif(peak_bins(k)==length(hist_theta))
                Y = hist_theta([num_bins-1 num_bins 1])';
            else
                Y = hist_theta(index)';
            end
            
            X = [ones(3,1) index index.^2];
            a = X \ Y; % solve for the parameters of the parabola
            parabola_peak = -a(2)/(2*a(3));
            
            % set this angle to be at the max of the fitted parabola
            % (Note we subtract 0.5 because the bin numbers represent the
            %  _centers_ of the bins)
            angle_deg = rem( (parabola_peak-0.5)*bin_size, 360);
            angle_rad = pi/180 * angle_deg;
            
            % Now extract a set of samples of gradient magnitude and
            % orientation centered at this interest point and aligned to the
            % dominant orientation
            [xwin,ywin] = meshgrid(win);
            xwin_rot = cos(angle_rad)*xwin + sin(angle_rad)*ywin; 
            ywin_rot = -sin(angle_rad)*xwin + cos(angle_rad)*ywin;
            xwin = xwin_rot + x(i);
            ywin = ywin_rot + y(i);
            
%             xwin = max(1,min(ncols,round(xwin)));
%             ywin = max(1,min(nrows,round(ywin)));
%             index = ywin + (xwin-1)*nrows + (s(i)-1)*nrows*ncols;
%             mag = mag_pyramid(index);
%             theta = theta_pyramid(index);

            mag = mexInterp2(mag_pyramid, xwin, ywin, s(i));
            theta = mexInterp2(theta_pyramid, xwin, ywin, s(i)) - angle_deg;
            
            if(local_edges_exist)
                % Also have to sample from and align the descriptor weighing mask to the 
                % dominant orientation
                xwin = xwin_rot + (length(full_res_xloc)+1)/2;
                ywin = ywin_rot + (length(full_res_yloc)+1)/2;
                
%                 xwin = max(1,min(ncols,round(xwin)));
%                 ywin = max(1,min(nrows,round(ywin)));
%                 index = ywin + (xwin-1)*size(desc_mask,1);
%                 desc_mask_rot = desc_mask(index);
                
                desc_mask_rot = mexInterp2(desc_mask, xwin, ywin);
                desc_mask_rot = desc_mask_rot / sum(desc_mask_rot(:)); % Normalize
                
                if(use_shape)
                    % And sample from the shape information too:
%                     theta_shape_sample = theta_shape(index);
%                     mag_shape_sample = mag_shape(index);
                    theta_shape_sample = mexInterp2(theta_shape, xwin, ywin);
                    mag_shape_sample = mexInterp2(mag_shape, xwin, ywin);
                    
                    % Combine the sampled shape info with the texture information
                    index = find(mag_shape_sample>0);
                    mag(index) = mag_shape_sample(index);
                    theta(index) = theta_shape_sample(index);
                end
            else
                % If there weren't any edges nearby, the weight mask is a
                % (rotationally symmetric) Gaussian, so we don't have to rotate
                % it -- and it's already the right size too.
                desc_mask_rot = desc_mask;
            end
            
            %descriptor = ComputeDescriptor(desc_mask.*mag, theta, angle_deg, offsets(1), offsets(2));
            descriptor = mexComputeDescriptor_simple(desc_mask_rot.*mag, theta);
            
            % Keep track of how many interest points we've kept so far, and
            % assemble all this one's information into a struct
            kept_ctr = kept_ctr+1;
            interest_points(kept_ctr) = struct('x', x(i), 'y', y(i), 'scale', scale(i), ...
                'scale_index', s(i), 'angle', angle_rad, 'descriptor', descriptor);           
            
%             % Record this new point in the lookup table so we can make sure
%             % not to add any new points too close to it
%             int_pts_lookup{round(y(i)), round(x(i))}(end+1) = kept_ctr;
            
        end
        
    else
        
        angle_rad = angles(i);
        angle_deg = 180/pi * angle_rad + 180;
        
        win = ceil(patch_size_multiplier*scale(i)) * linspace(-1,1,patch_width);
        [xwin,ywin] = meshgrid(win);
        xwin_rot = cos(angle_rad)*xwin + sin(angle_rad)*ywin; 
        ywin_rot = -sin(angle_rad)*xwin + cos(angle_rad)*ywin;
        xwin = xwin_rot + x(i);
        ywin = ywin_rot + y(i);
%         mag = interp2(mag_pyramid(:,:,s(i)), xwin, ywin, '*nearest');
%         theta = interp2(theta_pyramid(:,:,s(i)), xwin, ywin, '*nearest') - angle_deg;
        mag = mexInterp2(mag_pyramid(:,:,s(i)), xwin, ywin);
        theta = mexInterp2(theta_pyramid(:,:,s(i)), xwin, ywin) - angle_deg;
        
        if(local_edges_exist)
            % Also have to sample from and align the descriptor weighing mask to the 
            % dominant orientation
            xwin = xwin_rot + (length(full_res_xloc)+1)/2;
            ywin = ywin_rot + (length(full_res_yloc)+1)/2;
%             desc_mask_rot = interp2(desc_mask, xwin, ywin, '*nearest');
            desc_mask_rot = mexInterp2(desc_mask, xwin, ywin);
            desc_mask_rot = desc_mask_rot / sum(desc_mask_rot(:)); % Normalize
            
            if(use_shape)
                % And sample from the shape information too:
                theta_shape_sample = mexInterp2(theta_shape, xwin, ywin);
                mag_shape_sample = mexInterp2(mag_shape, xwin, ywin);
                
                % Combine the sampled shape info with the texture information
                index = find(mag_shape_sample>0);
                mag(index) = mag_shape_sample(index);
                theta(index) = theta_shape_sample(index);
            end
        else
            % If there weren't any edges nearby, the weight mask is a
            % (rotationally symmetric) Gaussian, so we don't have to rotate
            % it -- and it's already the right size too.
            desc_mask_rot = desc_mask;
        end
        
        %descriptor = ComputeDescriptor(desc_mask.*mag, theta, angle_deg, offsets(1), offsets(2));
        descriptor = mexComputeDescriptor_simple(desc_mask_rot.*mag, theta);
        
        % Keep track of how many interest points we've kept so far, and
        % assemble all this one's information into a struct
        kept_ctr = kept_ctr+1;
        interest_points(kept_ctr) = struct('x', x(i), 'y', y(i), 'scale', scale(i), ...
            'scale_index', s(i), 'angle', angle_rad, 'descriptor', descriptor);           
        
%         % Record this new point in the lookup table so we can make sure
%         % not to add any new points too close to it
%         int_pts_lookup{max(1, min(nrows, round(y(i)))), max(1, min(ncols, round(x(i))))}(end+1) = kept_ctr;
    end
    
end
