;;; markup - hypertext in scheme, producing latex and html
;;; Copyright (C) 1995  Scott Draves <spot@cs.cmu.edu>
;;;
;;; This program is free software; you can redistribute it and/or modify
;;; it under the terms of the GNU General Public License as published by
;;; the Free Software Foundation; either version 2 of the License, or
;;; (at your option) any later version.
;;;
;;; This program is distributed in the hope that it will be useful,
;;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;; GNU General Public License for more details.
;;;
;;; You should have received a copy of the GNU General Public License
;;; along with this program; if not, write to the Free Software
;;; Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


(define-structure quick-stdio
  (export stdin stdout filter->file-op
	  ((with-stdio
	    with-stdin with-stdout 
	    with-in-file with-out-file with-append-file) :syntax))
  (open scsh scheme)
  (begin

    (define stdin current-input-port)
    (define stdout current-output-port)

    (define-syntax with-stdin
      (syntax-rules
       () ((with-stdin in-form clause ...)
	   (with-current-input-port in-form clause ...))))

    (define-syntax with-stdout
      (syntax-rules
       () ((with-stdout out-form clause ...)
	   (with-current-output-port out-form clause ...))))

    ;; should handle stderr as 3rd option
    (define-syntax with-stdio
      (syntax-rules
       ()
       ((with-stdio (in-form) clause ...)
	(with-stdin in-form clause ...))
       ((with-stdio (in-form out-form) clause ...)
	(with-stdin in-form (with-stdout out-form clause ...)))))

    (define-syntax with-in-file
      (syntax-rules
       ()
       ((with-in-file file-name clause ...)
	(close-after (open-input-file file-name)
		     (lambda (port)
		       (with-stdin port clause ...))))))

    (define-syntax with-out-file
      (syntax-rules
       ()
       ((with-out-file file-name clause ...)
	(close-after (open-output-file file-name)
		     (lambda (port)
		       (with-stdout port clause ...))))))

    (define-syntax with-append-file
      (syntax-rules ()
	  ((with-append-file file-name clause ...)
	   (close-after (open-file file-name (bitwise-ior open/write
							  open/append))
			(lambda (port)
			  (with-stdout port clause ...))))))

    (define (filter->file-op filter-fn ext)
      (lambda (in-name)
	(let ((out-name
	       (replace-extension in-name
				  (string-append "." ext))))
	  (with-in-file in-name
			(with-out-file out-name
				       (filter-fn)))
	  out-name)))


    ))


(define-structure spot-util
  (export void printf identity
	  (rec :syntax))
  (open big-scheme util scheme)
  (begin

    (define void unspecific)

    (define (identity x) x)

    (define printf
      (lambda args
	(apply format (cons #t args))
	(void)))



    (define-syntax rec
      (lambda (exp r c)
	(let ((label (cadr exp))
	      (lam (caddr exp)))
	  `(letrec ((,label ,lam)) ,label))))))
