/*
 markup - hypertext in scheme, producing latex and html
 Copyright (C) 1995  Scott Draves <spot@cs.cmu.edu>

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include <stdio.h>
#include <stdlib.h>

/*
   multiplies each pixel in a pgm file by a scalar to adjust the brightness.
   handles P2 ascii input and P5 binary.

   usage:   pgmhack < in.pgm > out.pgm

   */



main(int argc, char **argv)
{
   double s;
   int max;
   int w, h, i, j;
   char P;
   if (argc != 2)
      s = 195/255.0; /* netscape bkg */
   else
      s = atof(argv[1]);
   if (4 != scanf("P%c %d %d %d\n", &P, &w, &h, &max)) {
      fprintf(stderr, "bad PGM header\n");
      exit(1);
   }
   switch (P) {
    case '2':
      printf("P2\n%d %d\n%d\n", w, h, max);
      for (i = 0; i < h; i++)
	 for (j =  0; j < w; j++) {
	    int p;
	    scanf("%d", &p);
	    p *= s;
	    if (p > max) p = max;
	    printf("%d\n", p);
	 }
      break;
    case '5':
      printf("P5\n%d %d\n%d\n", w, h, max);
      for (i = 0; i < h; i++)
	 for (j =  0; j < w; j++) {
	    int p = s * fgetc(stdin);
	    if (p > max) p = max;
	    fputc(p, stdout);
	 }
      break;
    default:
      fprintf(stderr, "P%c images not handled\n", P);
      exit(1);
   }
}
