;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; scheme48 specific stuff

(define-structure match-tools
  (export match:error
	  match:andmap
	  match:expanders
	  match:syntax-err
	  match:pattern-var?
	  gentemp
	  )
  (open scheme pp signals)
  (begin

    (define gentemp-counter 0)
    (define gentemp
      (lambda ()
	(set! gentemp-counter (+ 1 gentemp-counter))
	(string->symbol (string-append "g" (number->string
					    gentemp-counter)))))

    ; these should never be called
    (define box 'bogus)
    (define unbox 'bogus)

;<<<<<<<------
; begin incorrectly indented code

;; Called when a match fails.
(define match:error
  (lambda (val . args)
    (for-each p args)
    (error "no matching clause for" val)))

;; This is used by code _generated_ by the pattern matcher.
(define match:andmap
  (lambda (f l)
    (if (null? l)
        (and)
        (and (f (car l)) (match:andmap f (cdr l))))))

;; Generate a unique symbol with a specific print representation, if possible.
(define match:uninterned-symbol (lambda (x) (gentemp)))

;; For reporting syntax errors.
(define match:syntax-err
  (lambda (obj msg)
    (error msg obj)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Pattern Matching Syntactic Extensions for Scheme
;;
(define match:version "Version 1.07, Feb28, 1994")
;;
;; Report bugs to wright@cs.rice.edu.  The most recent version of this
;; software can be obtained by anonymous FTP from titan.cs.rice.edu
;; in file public/wright/match.tar.Z.  Be sure to set "type binary" when
;; transferring this file.
;;
;; Written by Andrew K. Wright, 1993 (wright@cs.rice.edu).
;; Adapted from code originally written by Bruce F. Duba, 1991.
;; This package also includes a modified version of Kent Dybvig's
;; define-structure (see Dybvig, R.K., The Scheme Programming Language,
;; Prentice-Hall, NJ, 1987).
;;
;; This software is in the public domain.  Feel free to copy,
;; distribute, and modify this software as desired.  No warranties
;; nor guarantees of any kind apply.  Please return any improvements
;; or bug fixes to wright@cs.rice.edu so that they may be included
;; in future releases.
;;
;; This macro package extends Scheme with several new expression forms.
;; Following is a brief summary of the new forms.  See the associated
;; LaTeX documentation for a full description of their functionality.
;;
;; Note: ... is a meta-symbol, while ooo represents a syntactic ...
;;
;;
;;         match expressions:
;;
;; exp ::= ...
;;       | (match exp clause ...)
;;       | (match-lambda clause ...)
;;       | (match-lambda* clause ...)
;;       | (match-let ((pat exp) ...) body)
;;       | (match-let* ((pat exp) ...) body)
;;       | (match-letrec ((pat exp) ...) body)
;;       | (match-define pat exp)
;;
;; clause ::= (pat body) | (pat => exp)
;;
;;         patterns:                       matches:
;;
;; pat ::= identifier                      anything, and binds identifier
;;       | _                               anything
;;       | ()                              the empty list
;;       | #t                              #t
;;       | #f                              #f
;;       | string                          a string
;;       | number                          a number
;;       | character                       a character
;;       | 'sexp                           an s-expression
;;       | 'symbol                         a symbol (special case of s-expr)
;;       | (pat_1 ... pat_n)               list of n elements
;;       | (pat_1 ... pat_n . pat_{n+1})   list of n or more
;;       | (pat_1 ... pat_n pat_n+1 ooo)   list of n or more, each element
;;                                           of remainder must match pat_n+1
;;       | #(pat_1 ... pat_n)              vector of n elements
;;       | #&pat                           box
;;       | ($ struct-name pat_1 ... pat_n) a structure
;;       | (and pat_1 ... pat_n)           if all of pat_1 thru pat_n match
;;       | (or pat_1 ... pat_n)            if any of pat_1 thru pat_n match
;;       | (not pat_1 ... pat_n)           if all pat_1 thru pat_n don't match
;;       | (? predicate pat_1 ... pat_n)   if predicate true and all of
;;                                           pat_1 thru pat_n match
;;       | (set! identifier)               anything, and binds setter
;;       | (get! identifier)               anything, and binds getter
;;       | `qp                             a quasi-pattern
;;
;;         quasi-patterns:                 matches:
;;
;; qp  ::= ()                              the empty list
;;       | #t                              #t
;;       | #f                              #f
;;       | string                          a string
;;       | number                          a number
;;       | character                       a character
;;       | identifier                      a symbol
;;       | (qp_1 ... qp_n)                 list of n elements
;;       | (qp_1 ... qp_n . qp_{n+1})      list of n or more
;;       | (qp_1 ... qp_n qp_n+1 ooo)      list of n or more, each element
;;                                           of remainder must match qp_n+1
;;       | #(qp_1 ... qp_n)                vector of n elements
;;       | #&qp                            box
;;       | ,pat                            a pattern
;;       | ,@pat                           a pattern
;;
;; The names (quote, quasiquote, unquote, unquote-splicing, ?, _, $,
;; and, or, not, set!, get!, ...) cannot be used as pattern variables.
;;
;;
;;         structure expressions:
;;
;; exp ::= ...
;;       | (define-structure (id_0 id_1 ... id_n))
;;       | (define-structure (id_0 id_1 ... id_n)
;;                           ((id_{n+1} exp_1) ... (id_{n+m} exp_m)))
;;       | (define-const-structure (id_0 arg_1 ... arg_n))
;;       | (define-const-structure (id_0 arg_1 ... arg_n)
;;                                 ((arg_{n+1} exp_1) ... (arg_{n+m} exp_m)))
;;
;; arg ::= id | (! id)
;;
;;
;; match:error-control controls what code is generated for failed matches.
;; Possible values:
;;  'unspecified - do nothing, ie., evaluate (cond (#f #f))
;;  'fail - call match:error, or die at car or cdr
;;  'error - call match:error with the unmatched value
;;  'match - call match:error with the unmatched value _and_
;;             the quoted match expression
;;
;; match:error is called for a failed match.
;;
;; match:structure-control controls the uniqueness of structures.
;; Possible values:
;;  'vector - structures are vectors with a symbol in position 0
;;  'disjoint - structures are fully disjoint from all other values
;;
;; End of user visible/modifiable stuff.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define match:error-control 'error)

(define match:structure-control 'vector)

(define match:disjoint-predicates
  '(null? pair? symbol? boolean? number? string? char?
    procedure? vector?
))

(define match:vector-structures '())

(define match:disjoint-structure-tags '())

;; If disjoint structures are used, we replace vector?, and we need
;; a way for macro-generated code to access the primitive version.
(define match:primitive-vector? vector?)

(define match:pattern-var?
  (lambda (x)
    (and (symbol? x)
         (not (match:dot-dot-k? x))
         (not (memq x '(quasiquote quote unquote unquote-splicing
                         ? _ $ and or not set! get! ...))))))

(define match:dot-dot-k?
  (lambda (s)
    (and (symbol? s)
         (if (eq? s '...)
             0
             (let* ((s (symbol->string s))
                    (n (string-length s)))
               (and (<= 3 n)
                    (eq? #\. (string-ref s 0))
                    (eq? #\. (string-ref s 1))
                    (match:andmap
                      char-numeric?
                      (string->list (substring s 2 n)))
                    (string->number (substring s 2 n))))))))

(define match:expanders
  (letrec
    (

     ;; for Schemes that don't have boxes                         ;SLIB
     (box? (lambda (x) #f))                                       ;SLIB

;;;; Main Drivers.

     (genmatch
      ; Generate an ordinary match expression.
      (lambda (x clauses match-expr)
        (let* ((length>= (gentemp))
               (eb-errf (error-maker match-expr))
               (blist (car eb-errf))
               (plist (map (lambda (c)
                             (let* ((x (bound (validate-pattern (car c))))
                                    (p (car x))
                                    (bv (cadr x))
                                    (bindings (caddr x))
                                    (code (gentemp))
                                    (fail (and (pair? (cdr c))
                                               (pair? (cadr c))
                                               (eq? (caadr c) '=>)
                                               (symbol? (cadadr c))
                                               (pair? (cdadr c))
                                               (null? (cddadr c))
                                               (pair? (cddr c))
                                               (cadadr c)))
                                    (bv2 (if fail (cons fail bv) bv))
                                    (body (if fail
                                              (cddr c)
                                              (cdr c))))
                               (set! blist
                                 (cons `(,code (lambda ,bv2 ,@body))
                                       (append bindings blist)))
                               (list p code bv (and fail (gentemp)) #f)))
                           clauses))
               (code (gen x '() plist (cdr eb-errf) length>= (gentemp))))
          (unreachable plist)
          (inline-let
            `(let ((,length>= (lambda (n) (lambda (l) (>= (length l) n))))
                   ,@blist)
               ,code)))))
   
     (genletrec
      ; Generate a match-letrec expression.
      (lambda (pat exp body match-expr)
        (let* ((length>= (gentemp))
               (eb-errf (error-maker match-expr))
               (x (bound (validate-pattern pat)))
               (p (car x))
               (bv (cadr x))
               (bindings (caddr x))
               (code (gentemp))
               (plist (list (list p code bv #f #f)))
               (x (gentemp))
               (m (gen x '() plist (cdr eb-errf) length>= (gentemp)))
               (gs (map (lambda (_) (gentemp)) bv)))
          (unreachable plist)
          `(letrec ((,length>= (lambda (n) (lambda (l) (>= (length l) n))))
                    ,@(map (lambda (v) `(,v #f)) bv)
                    (,x ,exp)
                    (,code (lambda ,gs
                             ,@(map (lambda (v g) `(set! ,v ,g))
                                    bv
                                    gs)
                             ,@body))
                    ,@bindings
                    ,@(car eb-errf))
             ,m))))

     (gendefine
      ; Generate a match-define expression.
      ; This works for internal defines only if:
      ;   (begin def ... exp) rest-of-body
      ; expands to:
      ;   (letrec (def ...) exp rest-of-body)
      ; (Rumor has it that this was unintentionally left out of R4RS,
      ;  and will be fixed in R5RS.  Many scheme systems, like Chez,
      ;  may already implement this.)
      (lambda (pat exp match-expr)
        (let* ((length>= (gentemp))
               (eb-errf (error-maker match-expr))
               (x (bound (validate-pattern pat)))
               (p (car x))
               (bv (cadr x))
               (bindings (caddr x))
               (code (gentemp))
               (plist (list (list p code bv #f #f)))
               (x (gentemp))
               (m (gen x '() plist (cdr eb-errf) length>= (gentemp)))
               (gs (map (lambda (_) (gentemp)) bv)))
          (unreachable plist)
          `(begin
             ,@(map (lambda (v) `(define ,v #f)) bv)
             ,(inline-let
                `(let ((,length>= (lambda (n) (lambda (l) (>= (length l) n))))
                       (,x ,exp)
                       (,code (lambda ,gs
                                ,@(map (lambda (v g) `(set! ,v ,g))
                                       bv
                                       gs)
                                (cond (#f #f))))
                       ,@bindings
                       ,@(car eb-errf))
                   ,m))))))

     (error-maker
      ; Return a pair of a list of bindings and an error generating function.
      (lambda (match-expr)
        (cond
          ((eq? match:error-control 'unspecified)
           (cons '() (lambda (x) `(cond (#f #f)))))
          ((memq match:error-control '(error fail))
           (cons '() (lambda (x) `(match:error ,x))))
          ((eq? match:error-control 'match)
           (let ((errf (gentemp))
                 (arg (gentemp)))
             (cons
               `((,errf (lambda (,arg) (match:error ,arg (quote ,match-expr)))))
               (lambda (x) `(,errf ,x)))))
          (else
           (match:syntax-err '(unspecified error fail match)
             "invalid value for match:error-control, legal values are")))))

     (unreachable
      ; Warn about unreachable patterns
      (lambda (plist)
        (for-each
          (lambda (x)
            (if (not (car (cddddr x)))
                (begin
                  (display "Warning: unreachable pattern ")
                  (display (car x))
                  (newline))))
          plist)))


;;;; Helpers for main drivers.

;; This procedure checks the validity of a pattern.
     (validate-pattern
      (lambda (pattern)
        (letrec
          ((simple?
            (lambda (x)
              (or (string? x) (boolean? x) (char? x) (number? x) (null? x))))
           (ordinary
            (lambda (p)
              
              ;; This code was generated automatically by expanding the
              ;; above pattern. (pattern deleted -spot)
              (let ((g1 (lambda (x y) (cons (ordinary x) (ordinary y)))))
                (if (simple? p)
                    ((lambda (p) p) p)
                    (if (equal? p '_)
                        ((lambda () '_))
                        (if (match:pattern-var? p)
                            ((lambda (p) p) p)
                            (if (pair? p)
                                (if (equal? (car p) 'quasiquote)
                                    (if (and (pair? (cdr p)) (null? (cddr p)))
                                        ((lambda (p) (quasi p)) (cadr p))
                                        (g1 (car p) (cdr p)))
                                    (if (equal? (car p) 'quote)
                                        (if (and (pair? (cdr p)) (null? (cddr p)))
                                            ((lambda (p) p) p)
                                            (g1 (car p) (cdr p)))
                                        (if (equal? (car p) '?)
                                            (if (and (pair? (cdr p)) (list? (cddr p)))
                                                ((lambda (pred ps)
                                                   `(? ,pred ,@(map ordinary ps)))
                                                 (cadr p)
                                                 (cddr p))
                                                (g1 (car p) (cdr p)))
                                            (if (equal? (car p) 'and)
                                                (if (and (list? (cdr p))
                                                         (pair? (cdr p)))
                                                    ((lambda (ps)
                                                       `(and ,@(map ordinary ps)))
                                                     (cdr p))
                                                    (g1 (car p) (cdr p)))
                                                (if (equal? (car p) 'or)
                                                    (if (and (list? (cdr p))
                                                             (pair? (cdr p)))
                                                        ((lambda (ps)
                                                           `(or ,@(map ordinary ps)))
                                                         (cdr p))
                                                        (g1 (car p) (cdr p)))
                                                    (if (equal? (car p) 'not)
                                                        (if (and (list? (cdr p))
                                                                 (pair? (cdr p)))
                                                            ((lambda (ps)
                                                               `(not ,@(map ordinary
                                                                            ps)))
                                                             (cdr p))
                                                            (g1 (car p) (cdr p)))
                                                        (if (equal? (car p) '$)
                                                            (if (and (pair? (cdr p))
                                                                     (symbol? (cadr p))
                                                                     (list? (cddr p)))
                                                                ((lambda (r ps)
                                                                   `($ ,r
                                                                       ,@(map ordinary
                                                                              ps)))
                                                                 (cadr p)
                                                                 (cddr p))
                                                                (g1 (car p) (cdr p)))
                                                            (if (equal? (car p) 'set!)
                                                                (if (and (pair? (cdr p))
                                                                         (match:pattern-var?
                                                                           (cadr p))
                                                                         (null?
                                                                           (cddr p)))
                                                                    ((lambda (p) p) p)
                                                                    (g1 (car p)
                                                                        (cdr p)))
                                                                (if (equal?
                                                                      (car p)
                                                                      'get!)
                                                                    (if (and (pair?
                                                                               (cdr p))
                                                                             (match:pattern-var?
                                                                               (cadr p))
                                                                             (null?
                                                                               (cddr p)))
                                                                        ((lambda (p) p)
                                                                         p)
                                                                        (g1 (car p)
                                                                            (cdr p)))
                                                                    (if (equal?
                                                                          (car p)
                                                                          'unquote)
                                                                        (g1 (car p)
                                                                            (cdr p))
                                                                        (if (equal?
                                                                              (car p)
                                                                              'unquote-splicing)
                                                                            (g1 (car p)
                                                                                (cdr p))
                                                                            (if (and (pair?
                                                                                       (cdr p))
                                                                                     (match:dot-dot-k?
                                                                                       (cadr p))
                                                                                     (null?
                                                                                       (cddr p)))
                                                                                ((lambda (p
                                                                                           ddk)
                                                                                   `(,(ordinary
                                                                                        p)
                                                                                     ,ddk))
                                                                                 (car p)
                                                                                 (cadr p))
                                                                                (g1 (car p)
                                                                                    (cdr p))))))))))))))
                                (if (vector? p)
                                    ((lambda (p)
                                       (apply vector (map ordinary (vector->list p))))
                                     p)
                                    (if (box? p)
                                        ((lambda (p) (box (ordinary (unbox p)))) p)
                                        ((lambda ()
                                           (match:syntax-err
                                             pattern
                                             "syntax error in pattern"))))))))))
              ))
           (quasi
            (lambda (p)
              '(match p
                 ((? simple? p) p)
                 ((? symbol? p) `(quote ,p))
                 (('unquote p) (ordinary p))
                 ((('unquote-splicing p) . ()) (ordinary p))
                 ((('unquote-splicing p) . y) (append (ordlist p) (quasi y)))
                 ((p (? match:dot-dot-k? ddk)) `(,(quasi p) ,ddk))
                 ((x . y) (cons (quasi x) (quasi y)))
                 ((? vector? p) (apply vector (map quasi (vector->list p))))
                 ((? box? p) (box (quasi (unbox p))))
                 (_ (match:syntax-err pattern "syntax error in pattern")))
              ;; This code was generated automatically by expanding the
              ;; above pattern.
              (let ((g4 (lambda (x y) (cons (quasi x) (quasi y)))))
                (if (simple? p)
                    ((lambda (p) p) p)
                    (if (symbol? p)
                        ((lambda (p) `',p) p)
                        (if (pair? p)
                            (if (equal? (car p) 'unquote)
                                (if (and (pair? (cdr p)) (null? (cddr p)))
                                    ((lambda (p) (ordinary p)) (cadr p))
                                    (g4 (car p) (cdr p)))
                                (if (and (pair? (car p))
                                         (equal? (caar p) 'unquote-splicing)
                                         (pair? (cdar p))
                                         (null? (cddar p)))
                                    (if (null? (cdr p))
                                        ((lambda (p) (ordinary p)) (cadar p))
                                        ((lambda (p y) (append (ordlist p) (quasi y)))
                                         (cadar p)
                                         (cdr p)))
                                    (if (and (pair? (cdr p))
                                             (match:dot-dot-k? (cadr p))
                                             (null? (cddr p)))
                                        ((lambda (p ddk) `(,(quasi p) ,ddk))
                                         (car p)
                                         (cadr p))
                                        (g4 (car p) (cdr p)))))
                            (if (vector? p)
                                ((lambda (p)
                                   (apply vector (map quasi (vector->list p))))
                                 p)
                                (if (box? p)
                                    ((lambda (p) (box (quasi (unbox p)))) p)
                                    ((lambda ()
                                       (match:syntax-err
                                         pattern
                                         "syntax error in pattern")))))))))
             ))
           (ordlist
            (lambda (p)
              (cond
                ((null? p) '())
                ((pair? p) (cons (ordinary (car p)) (ordlist (cdr p))))
                (else (match:syntax-err pattern
                        "invalid use of unquote-splicing in pattern"))))))
          (ordinary pattern))))

     (bound
      ; Find bound variables of a pattern, in left-to-right order of
      ; appearance.  This code is written in continuation-passing style.
      ; Continuations take two arguments: 
      ;  the modified pattern, and
      ;  an accumulated list of bound variables.
      ; Also replace predicate expressions with a unique name,
      ; and place a list of the subpattern bound variables following ...,
      ; and some fresh variables.
      (lambda (pattern)
        (letrec
          ((pred-bodies '())
           (bound
            (lambda (p a k)
              (cond ((eq? '_ p) (k p a))
                    ((symbol? p)
                     (if (memq p a)
                         (match:syntax-err pattern
                           "duplicate variable in pattern"))
                     (k p (cons p a)))
                    ((and (pair? p) (eq? 'quote (car p))) (k p a))
                    ((and (pair? p) (eq? '? (car p)))
                     (cond
                       ((not (null? (cddr p)))
                        (bound `(and (? ,(cadr p)) ,@(cddr p)) a k))
                       ((or (not (symbol? (cadr p))) (memq (cadr p) a))
                        (let ((g (gentemp)))
                          (set! pred-bodies
                            (cons `(,g ,(cadr p)) pred-bodies))
                          (k `(? ,g) a)))
                       (else
                        (k p a))))
                    ((and (pair? p) (eq? 'and (car p)))
                     (bound* (cdr p) a
                       (lambda (p a)
                         (k `(and ,@p) a))))
                    ((and (pair? p) (eq? 'or (car p)))
                     (bound (cadr p) a
                       (lambda (first-p first-a)
                         (let or* ((plist (cddr p))
                                   (k (lambda (plist)
                                        (k `(or ,first-p ,@plist) first-a))))
                           (if (null? plist)
                               (k plist)
                               (bound (car plist) a
                                 (lambda (car-p car-a)
                                   (if (not (permutation car-a first-a))
                                       (match:syntax-err pattern
                                         "variables of or-pattern differ in"))
                                   (or* (cdr plist)
                                        (lambda (cdr-p)
                                          (k (cons car-p cdr-p)))))))))))
                    ((and (pair? p) (eq? 'not (car p)))
                     (cond
                       ((not (null? (cddr p)))
                        (bound `(not (or ,@(cdr p))) a k))
                       (else
                        (bound (cadr p) a
                          (lambda (p2 a2)
                            (if (not (permutation a a2))
                                (match:syntax-err p
                                  "no variables allowed in"))
                            (k `(not ,p2) a))))))
                    ((and (pair? p) (pair? (cdr p)) (match:dot-dot-k? (cadr p)))
                     (bound (car p) a
                       (lambda (q b)
                         (let ((bvars (find-prefix b a)))
                           (k `(,q ,(cadr p) ,bvars
                                   ,(gentemp)
                                   ,(gentemp)
                                   ,(map (lambda (_) (gentemp)) bvars))
                              b)))))
                    ((and (pair? p) (eq? '$ (car p)))
                     (bound* (cddr p) a
                       (lambda (p1 a)
                         (k `($ ,(cadr p) ,@p1) a))))
                    ((and (pair? p) (eq? 'set! (car p)))
                     (if (memq (cadr p) a) (k p a) (k p (cons (cadr p) a))))
                    ((and (pair? p) (eq? 'get! (car p)))
                     (if (memq (cadr p) a) (k p a) (k p (cons (cadr p) a))))
                    ((pair? p)
                     (bound (car p) a
                       (lambda (car-p a)
                         (bound (cdr p) a
                           (lambda (cdr-p a)
                             (k (cons car-p cdr-p) a))))))
                    ((vector? p)
                     (bound* (vector->list p) a
                       (lambda (pl a)
                         (k (list->vector pl) a))))
                    ((box? p)
                     (bound (unbox p) a
                       (lambda (p a)
                         (k (box p) a))))
                    (else (k p a)))))
           (bound*
            (lambda (plist a k)
              (if (null? plist)
                  (k plist a)
                  (bound (car plist) a
                    (lambda (car-p a)
                      (bound* (cdr plist) a
                        (lambda (cdr-p a)
                          (k (cons car-p cdr-p) a))))))))
           (find-prefix
            ; tail of b is a, find the prefix
            (lambda (b a)
              (if (eq? b a)
                  '()
                  (cons (car b) (find-prefix (cdr b) a)))))
           (permutation
            (lambda (p1 p2)
              (and (= (length p1) (length p2))
                   (match:andmap (lambda (x1) (memq x1 p2)) p1)))))
          (bound pattern '()
            (lambda (p a)
              (list p (reverse a) pred-bodies))))))

     (inline-let
      ; Inliner for let expressions.  Inlines bindings where bound expression
      ; is a value (variable or lambda) and is used 0 or 1 times, or is small.
      ; This is a fairly big performance win when Chez Scheme is at
      ; optimize-level 0.
      (lambda (let-exp)
        (letrec
          ((occ (lambda (x e)
                  (let loop ((e e))
                    (cond ((pair? e) (+ (loop (car e)) (loop (cdr e))))
                          ((eq? x e) 1)
                          (else 0)))))
           (subst (lambda (e old new)
                    (let loop ((e e))
                      (cond ((pair? e) (cons (loop (car e)) (loop (cdr e))))
                            ((eq? old e) new)
                            (else e)))))
           (const? (lambda (sexp)
                     (or (symbol? sexp)  ; includes variables
                         (boolean? sexp)
                         (string? sexp)
                         (char? sexp)
                         (number? sexp)
                         (null? sexp)
                         (and (pair? sexp)
                              (eq? (car sexp) 'quote)
                              (pair? (cdr sexp))
                              (symbol? (cadr sexp))
                              (null? (cddr sexp))))))
           (isval? (lambda (sexp)
                     (or (const? sexp)
                         (and (pair? sexp)
                              (memq (car sexp)
                                    '(lambda quote
                                       match-lambda match-lambda*))))))
           (small? (lambda (sexp)
                     (or (const? sexp)
                         (and (pair? sexp)
                              (eq? (car sexp) 'lambda)
                              (pair? (cdr sexp))
                              (pair? (cddr sexp))
                              (const? (caddr sexp))
                              (null? (cdddr sexp)))))))
          (let loop ((b (cadr let-exp))(new-b '())(e (caddr let-exp)))
            (cond
              ((null? b)
               (if (null? new-b)
                   e
                   `(let ,(reverse new-b) ,e)))
              ((isval? (cadr (car b)))
               (let* ((x (caar b))
                      (n (occ x e)))
                 (cond
                   ((= 0 n)
                    (loop (cdr b) new-b e))
                   ((or (= 1 n) (small? (cadr (car b))))
                    (loop (cdr b) new-b (subst e x (cadr (car b)))))
                   (else
                    (loop (cdr b) (cons (car b) new-b) e)))))
              (else  (loop (cdr b) (cons (car b) new-b) e)))))))

;;;; Pattern matching engine.  This is where the real work is.

     (gen
      ; Generate match code given an expression (x), a list of tests
      ; known So Far (sf), a pattern list (plist), and an error action.
      ; "plist" is a list of:
      ;   (pattern code bv fail-sym reached)
      ; where "code" is a symbol and "bv" is a list of bound variables whose
      ; value must be supplied to call "code".  "reached" is set by this
      ; routine to #t if the corresponding pattern is reachable.
      ; This code is written in a mock-continuation-passing style.
      ; Both "next" and "emit" take success (ks) and fail (kf)
      ; ``continuations'' that describe what to do when a test succeeds or
      ; fails.  But unlike real continuation-passing style, these
      ; ``continuations'' return the generated code, which is put together
      ; by "emit".  Avoid calls to gentemp inside this function as this
      ; screws up code folding by "assm".
      (lambda (x sf plist erract length>= eta)
        (if (null? plist)
            (erract x)
            (let*
              ((v '()) ; A-list of bound pattern variables and value.
                      ; This should probably be passed around as an argument
                      ; of the continuations, rather than being set!-ed.
               (val (lambda (x) (cdr (assq x v))))
               (fail
                ; Go to the next pattern for a failed test.
                (lambda (sf)
                  (gen x sf (cdr plist) erract length>= eta)))
               (success
                ; Successful match of an entire pattern.
                (lambda (sf)
                  (set-car! (cddddr (car plist)) #t) ; reached this pattern
                  (let* ((code (cadr (car plist)))
                         (bv (caddr (car plist)))
                         (fail-sym (cadddr (car plist))))
                    (if fail-sym
                        (let ((ap `(,code ,fail-sym ,@(map val bv))))
                          `(call-with-current-continuation
                             (lambda (,fail-sym)
                               (let ((,fail-sym
                                       (lambda () (,fail-sym ,(fail sf)))))
                                 ,ap))))
                        `(,code ,@(map val bv)))))))
              (let next
                ((p (caar plist))
                 (e x)
                 (sf sf)
                 (kf fail)
                 (ks success))
                (cond
                  ((eq? '_ p)
                   (ks sf))
                  ((symbol? p)
                   (set! v (cons (cons p e) v))
                   (ks sf))
                  ((null? p)
                   (emit `(null? ,e) sf kf ks))
                  ((string? p)
                   (emit `(equal? ,e ,p) sf kf ks))
                  ((boolean? p)
                   (emit `(equal? ,e ,p) sf kf ks))
                  ((char? p)
                   (emit `(equal? ,e ,p) sf kf ks))
                  ((number? p)
                   (emit `(equal? ,e ,p) sf kf ks))
                  ((and (pair? p) (eq? 'quote (car p)))
                   (emit `(equal? ,e ,p) sf kf ks))
                  ((and (pair? p) (eq? '? (car p)))
                   (let ((tst `(,(cadr p) ,e)))
                     (emit tst sf kf ks)))
                  ((and (pair? p) (eq? 'and (car p)))
                   (let loop ((p (cdr p))(sf sf))
                     (if (null? p)
                         (ks sf)
                         (next (car p)
                               e
                               sf
                               kf
                               (lambda (sf) (loop (cdr p) sf))))))
                  ((and (pair? p) (eq? 'or (car p)))
                   (let ((or-v v))
                     (let loop ((p (cdr p))(sf sf))
                       (if (null? p)
                           (kf sf)
                           (begin
                             (set! v or-v)
                             (next (car p)
                                   e
                                   sf
                                   (lambda (sf) (loop (cdr p) sf))
                                   ks))))))
                  ((and (pair? p) (eq? 'not (car p)))
                   (next (cadr p) e sf ks kf))
                  ((and (pair? p) (eq? '$ (car p)))
                   (let* ((tag (cadr p))
                          (fields (cdr p))
                          (rlen (length fields))
                          (tst `(,(symbol-append tag '?) ,e)))
                     (emit tst sf kf
                           (let rloop ((n 1))
                             (lambda (sf)
                               (if (= n rlen)
                                   (ks sf)
                                   (next (list-ref fields n)
                                         `(,(symbol-append tag '- n) ,e)
                                         sf
                                         kf
                                         (rloop (+ 1 n)))))))))
                  ((and (pair? p) (eq? 'set! (car p)))
                   (set! v (cons (cons (cadr p) (setter e p)) v))
                   (ks sf))
                  ((and (pair? p) (eq? 'get! (car p)))
                   (set! v (cons (cons (cadr p) (getter e p)) v))
                   (ks sf))
                  ((and (pair? p) (pair? (cdr p)) (match:dot-dot-k? (cadr p)))
                   (emit `(list? ,e) sf kf
                         (lambda (sf)
                           (let* ((k (match:dot-dot-k? (cadr p)))
                                  (ks (lambda (sf)
                                        (let ((bound (list-ref p 2)))
                                          (cond
                                            ((eq? (car p) '_)
                                             (next (car p) e sf kf ks))
                                            ((null? bound)
                                             (let* ((ptst (next (car p)
                                                                eta
                                                                sf
                                                                (lambda (sf) #f)
                                                                (lambda (sf) #t)))
                                                    (tst (if (and (pair? ptst)
                                                                  (symbol? (car ptst))
                                                                  (pair? (cdr ptst))
                                                                  (eq? eta (cadr ptst))
                                                                  (null? (cddr ptst)))
                                                             (car ptst)
                                                             `(lambda (,eta) ,ptst))))
                                               (assm `(match:andmap ,tst ,e)
                                                     (ks sf)
                                                     (kf sf))))
                                            ((and (symbol? (car p))
                                                  (equal? (list (car p)) bound))
                                             ; This code perserves precise semantics.
                                             ; (next (car p) `(list-copy ,e) sf kf ks)
                                             (next (car p) e sf kf ks))
                                            (else
                                             (let* ((gloop (list-ref p 3))
                                                    (ge (list-ref p 4))
                                                    (fresh (list-ref p 5))
                                                    (p1 (next (car p)
                                                              `(car ,ge)
                                                              sf
                                                              kf
                                                              (lambda (sf)
                                                                `(,gloop
                                                                   (cdr ,ge)
                                                                   ,@(map (lambda (b f)
                                                                            `(cons ,(val b) ,f))
                                                                          bound
                                                                          fresh))))))
                                               (set! v (append (map cons bound (map (lambda (x) `(reverse ,x)) fresh)) v))
                                               `(let ,gloop ((,ge ,e)
                                                             ,@(map (lambda (x) `(,x '())) fresh))
                                                  (if (null? ,ge)
                                                      ,(ks sf)
                                                      ,p1)))))))))
                             (case k
                               ((0) (ks sf))
                               ((1) (emit `(pair? ,e) sf kf ks))
                               (else (emit `((,length>= ,k) ,e) sf kf ks)))))))
                  ((pair? p)
                   (emit `(pair? ,e) sf kf
                         (lambda (sf)
                           (next (car p) (add-a e) sf kf
                                 (lambda (sf)
                                   (next (cdr p) (add-d e) sf kf ks))))))
                  ((vector? p)
                   (let ((vlen (vector-length p)))
                     (emit `(vector? ,e) sf kf
                           (lambda (sf)
                             (emit `(equal? (vector-length ,e) ,vlen) sf kf
                                   (let vloop ((n 0))
                                     (lambda (sf)
                                       (if (= n vlen)
                                           (ks sf)
                                           (next (vector-ref p n)
                                                 `(vector-ref ,e ,n)
                                                 sf
                                                 kf
                                                 (vloop (+ 1 n)))))))))))
                  ((box? p)
                   (emit `(box? ,e) sf kf
                         (lambda (sf)
                           (next (unbox p) `(unbox ,e) sf kf ks))))
                  (else
                   (display "FATAL ERROR IN PATTERN MATCHER")
                   (newline)
                   (error #f "THIS NEVER HAPPENS"))))))))

     (emit
      ; Generate code for a test, but suppress redundant tests.
      ; All tests passed to emit are of the form:
      ;   (predicate? e)  or  (equal? e thing)
      ; Note that "e" is always the cadr of a test.
      ; Continuations take the extended test list "sf" as an argument.
      ; Use and-expressions when possible.
      (lambda (tst sf kf ks)
        (cond
          ((in tst sf)         (ks sf))
          ((in `(not ,tst) sf) (kf sf))
          (else
           (let* ((e (cadr tst))
                  (implied (cond ((eq? (car tst) 'equal?)
                                  (let ((p (caddr tst)))
                                    (cond ((string?  p) `((string? ,e)))
                                          ((boolean? p) `((boolean? ,e)))
                                          ((char?    p) `((char? ,e)))
                                          ((number?  p) `((number? ,e)))
                                          ((and (pair? p) (eq? 'quote (car p)))
                                           `((symbol? ,e)))
                                          (else '()))))
                                 ((eq? (car tst) 'null?)
                                  `((list? ,e)))
                                 ((vec-structure? tst)
                                  `((vector? ,e)))
                                 (else
                                  '())))
                  (not-imp (case (car tst)
                             ((list?) `((not (null? ,e))))
                             (else '())))
                  (s (ks (cons tst (append implied sf))))
                  (k (kf (cons `(not ,tst) (append not-imp sf)))))
             (assm tst s k))))))
     (assm
      ; Generate code for a test, using and-expressions where possible.
      (lambda (tst s f)
        (cond
          ((equal? s f)
           s)
          ((and (eq? s #t) (eq? f #f))
           tst)
          ((and (eq? (car tst) 'pair?)
                (memq match:error-control '(unspecified fail))
                (memq (car f) '(cond match:error))
                (guarantees s (cadr tst)))
           s)
          ((and (pair? s) (eq? (car s) 'if) (equal? (cadddr s) f))
           (if (eq? (car (cadr s)) 'and)
               `(if (and ,tst ,@(cdr (cadr s)))
                    ,(caddr s)
                    ,f)
               `(if (and ,tst ,(cadr s))
                    ,(caddr s)
                    ,f)))
          (; ('call-with-current-continuation ('lambda (k) ('let ((fail ('lambda () (_ f2)))) s2)))
          ; and (equal? f f2)
           (and (pair? s)
                (equal? (car s) 'call-with-current-continuation)
                (pair? (cdr s))
                (pair? (cadr s))
                (equal? (caadr s) 'lambda)
                (pair? (cdadr s))
                (pair? (cadadr s))
                (null? (cdr (cadadr s)))
                (pair? (cddadr s))
                (pair? (car (cddadr s)))
                (equal? (caar (cddadr s)) 'let)
                (pair? (cdar (cddadr s)))
                (pair? (cadar (cddadr s)))
                (pair? (caadar (cddadr s)))
                (pair? (cdr (caadar (cddadr s))))
                (pair? (cadr (caadar (cddadr s))))
                (equal? (caadr (caadar (cddadr s))) 'lambda)
                (pair? (cdadr (caadar (cddadr s))))
                (null? (cadadr (caadar (cddadr s))))
                (pair? (cddadr (caadar (cddadr s))))
                (pair? (car (cddadr (caadar (cddadr s)))))
                (pair? (cdar (cddadr (caadar (cddadr s)))))
                (null? (cddar (cddadr (caadar (cddadr s)))))
                (null? (cdr (cddadr (caadar (cddadr s)))))
                (null? (cddr (caadar (cddadr s))))
                (null? (cdadar (cddadr s)))
                (pair? (cddar (cddadr s)))
                (null? (cdddar (cddadr s)))
                (null? (cdr (cddadr s)))
                (null? (cddr s))
                (equal? f (cadar (cddadr (caadar (cddadr s))))))
           (let ((k (car (cadadr s)))
                 (fail (car (caadar (cddadr s))))
                 (s2 (caddar (cddadr s))))
             `(call-with-current-continuation
                (lambda (,k)
                  (let ((,fail (lambda () (,k ,f))))
                    ,(assm tst s2 `(,fail)))))))
          (; pattern ('let ((fail ('lambda () f))) s2)
           (and #f (pair? s)
                (equal? (car s) 'let)
                (pair? (cdr s))
                (pair? (cadr s))
                (pair? (caadr s))
                (pair? (cdaadr s))
                (pair? (car (cdaadr s)))
                (equal? (caar (cdaadr s)) 'lambda)
                (pair? (cdar (cdaadr s)))
                (null? (cadar (cdaadr s)))
                (pair? (cddar (cdaadr s)))
                (null? (cdddar (cdaadr s)))
                (null? (cdr (cdaadr s)))
                (null? (cdadr s))
                (pair? (cddr s))
                (null? (cdddr s))
                (equal? (caddar (cdaadr s)) f))
           (let ((fail (caaadr s))
                 (s2 (caddr s)))
             `(let ((,fail (lambda () ,f)))
                ,(assm tst s2 `(,fail)))))
          (else `(if ,tst ,s ,f)))))
     (guarantees
      ; See if code guarantees to take the car or cdr of x.
      (lambda (code x)
        (let ((a (add-a x))
              (d (add-d x)))
          (let loop ((code code))
            (cond ((not (pair? code)) #f)
                  ((memq (car code) '(cond match:error)) #t)
                  ((or (equal? code a) (equal? code d)) #t)
                  ((eq? (car code) 'if)
                   (or (loop (cadr code))
                       (and (loop (caddr code)) (loop (cadddr code)))))
                  ((eq? (car code) 'lambda) #f)
                  ((and (eq? (car code) 'let) (symbol? (cadr code))) #f)
                  (else (or (loop (car code)) (loop (cdr code)))))))))

     (in
      ; Determine whether the test "e" is true in the test list "l".
      ; "e" can be either a simple test or (not test).  "l" is a list
      ; of similar such tests. "disjoint?" determines whether a test
      ; determines a disjoint class:  if a test is disjoint, then
      ; (not test) is true whenever some other test is true of "e". 
      (lambda (e l)
        (or (member e l)
            (and (eq? (car e) 'list?)
                 (or (member `(null? ,(cadr e)) l) (member `(pair? ,(cadr e)) l)))
            (and (eq? (car e) 'not)
                 (let* ((srch (cadr e))
                        (const-class (equal-test? srch)))
                   (cond
                     (const-class
                      (let mem ((l l))
                        (if (null? l)
                            #f
                            (let ((x (car l)))
                              (or (and (equal? (cadr x) (cadr srch))
                                       (disjoint? x)
                                       (not (equal? const-class (car x))))
                                  (equal? x
                                    `(not (,const-class ,(cadr srch))))
                                  (and (equal? (cadr x) (cadr srch))
                                       (equal-test? x)
                                       (not (equal? (caddr srch) (caddr x))))
                                  (mem (cdr l)))))))
                     ((disjoint? srch)
                      (let mem ((l l))
                        (if (null? l)
                            #f
                            (let ((x (car l)))
                              (or (and (equal? (cadr x) (cadr srch))
                                       (disjoint? x)
                                       (not (equal? (car x) (car srch))))
                                  (mem (cdr l)))))))
                     ((eq? (car srch) 'list?)
                      (let mem ((l l))
                        (if (null? l)
                            #f
                            (let ((x (car l)))
                              (or (and (equal? (cadr x) (cadr srch))
                                       (disjoint? x)
                                       (not (memq (car x) '(list? pair? null?))))
                                  (mem (cdr l)))))))
                     ((vec-structure? srch)
                      (let mem ((l l))
                        (if (null? l)
                            #f
                            (let ((x (car l)))
                              (or (and (equal? (cadr x) (cadr srch))
                                       (or (disjoint? x) (vec-structure? x))
                                       (not (equal? (car x) 'vector?))
                                       (not (equal? (car x) (car srch))))
                                  (equal? x `(not (vector? ,(cadr srch))))
                                  (mem (cdr l)))))))
                     (else #f)))))))
     (equal-test?
      ; if it tests equality to a constant, return the class of constant
      (lambda (tst)
        (and (eq? (car tst) 'equal?)
             (let ((p (caddr tst)))
               (cond ((string? p)  'string?)
                     ((boolean? p) 'boolean?)
                     ((char? p)    'char?)
                     ((number? p)  'number?)
                     ((and (pair? p)
                           (pair? (cdr p))
                           (null? (cddr p))
                           (eq? 'quote (car p))
                           (symbol? (cadr p)))
                      'symbol?)
                     (else #f))))))

     (disjoint?
      (lambda (tst) (memq (car tst) match:disjoint-predicates)))
     (vec-structure?
      (lambda (tst) (memq (car tst) match:vector-structures)))

     (add-a
      ; Add car operation, ie. given (c...r x), return (ca...r x).
      (lambda (a)
        (let ((new (and (pair? a) (assq (car a) c---rs))))
          (if new (cons (cadr new) (cdr a)) `(car ,a)))))
     (add-d
      ; Add cdr operation, ie. given (c...r x), return (cd...r x).
      (lambda (a)
        (let ((new (and (pair? a) (assq (car a) c---rs))))
          (if new (cons (cddr new) (cdr a)) `(cdr ,a)))))

     (c---rs '((car caar . cdar) (cdr cadr . cddr)
               (caar caaar . cdaar) (cadr caadr . cdadr)
               (cdar cadar . cddar) (cddr caddr . cdddr)
               (caaar caaaar . cdaaar) (caadr caaadr . cdaadr)
               (cadar caadar . cdadar) (caddr caaddr . cdaddr)
               (cdaar cadaar . cddaar) (cdadr cadadr . cddadr)
               (cddar caddar . cdddar) (cdddr cadddr . cddddr)))

     (setter
      (lambda (e p)
        (let ((mk-setter (lambda (s) (symbol-append 'set- s '!))))
          (cond
            ((not (pair? e))
             (match:syntax-err p "unnested set! pattern"))
            ((eq? (car e) 'vector-ref)
             `(let ((x ,(cadr e))) (lambda (y) (vector-set! x ,(caddr e) y))))
            ((eq? (car e) 'unbox)
             `(let ((x ,(cadr e))) (lambda (y) (set-box! x y))))
            ((eq? (car e) 'car)
             `(let ((x ,(cadr e))) (lambda (y) (set-car! x y))))
            ((eq? (car e) 'cdr)
             `(let ((x ,(cadr e))) (lambda (y) (set-cdr! x y))))
            ((let ((a (assq (car e) get-c---rs)))
               (and a
                    `(let ((x (,(cadr a) ,(cadr e))))
                       (lambda (y) (,(mk-setter (cddr a)) x y))))))
            (else
             `(let ((x ,(cadr e)))
                (lambda (y) (,(mk-setter (car e)) x y))))))))

     (getter
      (lambda (e p)
        (cond
          ((not (pair? e))
           (match:syntax-err p "unnested get! pattern"))
          ((eq? (car e) 'vector-ref)
           `(let ((x ,(cadr e))) (lambda () (vector-ref x ,(caddr e)))))
          ((eq? (car e) 'unbox)
           `(let ((x ,(cadr e))) (lambda () (unbox x))))
          ((eq? (car e) 'car)
           `(let ((x ,(cadr e))) (lambda () (car x))))
          ((eq? (car e) 'cdr)
           `(let ((x ,(cadr e))) (lambda () (cdr x))))
          ((let ((a (assq (car e) get-c---rs)))
             (and a
                  `(let ((x (,(cadr a) ,(cadr e))))
                     (lambda () (,(cddr a) x))))))
          (else
           `(let ((x ,(cadr e)))
              (lambda () (,(car e) x)))))))

     (get-c---rs '((caar car . car) (cadr cdr . car)
                   (cdar car . cdr) (cddr cdr . cdr)
                   (caaar caar . car) (caadr cadr . car)
                   (cadar cdar . car) (caddr cddr . car)
                   (cdaar caar . cdr) (cdadr cadr . cdr)
                   (cddar cdar . cdr) (cdddr cddr . cdr)
                   (caaaar caaar . car) (caaadr caadr . car)
                   (caadar cadar . car) (caaddr caddr . car)
                   (cadaar cdaar . car) (cadadr cdadr . car)
                   (caddar cddar . car) (cadddr cdddr . car)
                   (cdaaar caaar . cdr) (cdaadr caadr . cdr)
                   (cdadar cadar . cdr) (cdaddr caddr . cdr)
                   (cddaar cdaar . cdr) (cddadr cdadr . cdr)
                   (cdddar cddar . cdr) (cddddr cdddr . cdr)))

     (symbol-append
      (lambda l
        (string->symbol
          (apply string-append
            (map (lambda (x)
                   (cond ((symbol? x) (symbol->string x))
                         ((number? x) (number->string x))
                         (else x)))
                 l)))))

     ) ; end of letrec bindings

    (list genmatch genletrec gendefine)))

;------->>>>>>
; end incorrectly indented code
))


(define-structure match
  (export (match :syntax)
	  match:andmap ; no attempt at name hiding
	  match:error
	  )
  (open scheme match-tools)
  (for-syntax (open scheme match-tools))
  (begin

(define-syntax defmacro
  (lambda (exp r c)
    (let ((name (cadr exp))
	  (formal (caddr exp))
	  (body (cadddr exp)))
      `(define-syntax ,name
	 (lambda (exp r c)
	   (let ((,formal (cdr exp)))
	     ,body)))
      )))

(defmacro match args
  (cond
   ((and (list? args)
	 (<= 1 (length args))
	 (match:andmap
	  (lambda (y) (and (list? y) (<= 2 (length y))))
	  (cdr args)))
    (let* ((exp (car args))
	   (clauses (cdr args))
	   (e (if (symbol? exp) exp (gentemp))))
      (if (symbol? exp)
	  ((car match:expanders) e clauses `(match ,@args))
	  `(let ((,e ,exp))
	     ,((car match:expanders) e clauses `(match ,@args))))))
   (else (match:syntax-err `(match ,@args) "syntax error in"))))


    ))
