;;; markup - hypertext in scheme, producing latex and html
;;; Copyright (C) 1995  Scott Draves <spot@cs.cmu.edu>
;;;
;;; This program is free software; you can redistribute it and/or modify
;;; it under the terms of the GNU General Public License as published by
;;; the Free Software Foundation; either version 2 of the License, or
;;; (at your option) any later version.
;;;
;;; This program is distributed in the hope that it will be useful,
;;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;; GNU General Public License for more details.
;;;
;;; You should have received a copy of the GNU General Public License
;;; along with this program; if not, write to the Free Software
;;; Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

;  utilities for creating DOT files to stdout

(define-structure dot
  (export new-node-name new-edge-name
	  link-solid link-dotted
	  node circle diamond bullet box plaintext cons-box
	  dot-quote-string)
  (open quick-stdio match spot-util scsh scheme)
  (begin

    (define make-namer
      (lambda (prefix)
	(let ((n 0))
	  (lambda ()
	    (set! n (+ 1 n))
	    (string-append prefix (number->string n))))))
    
    (define new-node-name (make-namer "n"))
    (define new-edge-name (make-namer "e"))

    (define (make-link style)
      (lambda (from to . field)
	(match field
	       ('() (printf "~A -> ~A [style = ~A];~%"
			    from to style))
	       ((fld) (printf "~A:~A -> ~A [style = ~A];~%"
			      from fld to style)))))

    (define link-solid (make-link "solid"))
    (define link-dotted (make-link "dotted"))

    (define (node name label)
      (printf "~A [label = \"~A\"];~%" name label))

    (define (box name label)
      (printf "~A [shape = box label = \"~A\"];~%" name label))

    (define (bullet name label)
      (printf "~A [shape = circle style = filled color = gray label =  \"~A\"];~%" name label))

    (define (circle name label)
      (printf "~A [shape = circle label =  \"~A\"];~%" name label))

    (define (diamond name label)
      (printf "~A [shape = diamond label =  \"~A\"];~%" name label))

    (define (plaintext name label)
      (printf "~A [shape = plaintext label = \"~A\"];~%" name label))

    (define (cons-box name a-lab d-lab)
      (printf "~A [shape = record height=0.1 label = \"<a>~A|<d>~A\"];~%"
	      name a-lab d-lab))

    (define (dot-quote-string s)
      (define special-chars '(#\\ #\space #\" #\{ #\} #\< #\> #\|))
      (list->string
       (let loop ((sl (string->list s)))
	 (if (null? sl)
	     '()
	     (let* ((hd (car sl))
		    (rest (cons hd (loop (cdr sl)))))
	       (if (memq hd special-chars)
		   (cons #\\ rest)
		   rest))))))

    ))
