;;; markup - hypertext in scheme, producing latex and html
;;; Copyright (C) 1995  Scott Draves <spot@cs.cmu.edu>
;;;
;;; This program is free software; you can redistribute it and/or modify
;;; it under the terms of the GNU General Public License as published by
;;; the Free Software Foundation; either version 2 of the License, or
;;; (at your option) any later version.
;;;
;;; This program is distributed in the hope that it will be useful,
;;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;; GNU General Public License for more details.
;;;
;;; You should have received a copy of the GNU General Public License
;;; along with this program; if not, write to the Free Software
;;; Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

(define-structure convert
  (export pstoppm
	  textops-queue
	  textops-flush
	  textops
	  tex-init-string
	  pstogif-file
	  pstoppm-file
	  pstogif)
  (open spot-util quick-stdio scsh scheme)
  (begin

;;; the end result is too small, isn't it?  shouldn't this take in and
;;; out as args as statics rather than dynamics?  

    (define (pstoppm)
      (define scale 4)
      (define screen-dpi 85) ; how to use this?
      (define (min-max->start-size min max)
	(let ((d (- max min))
	      (b 0.1))
	  (values (- min (* b d))
		  (* d (+ 1 b b)))))
      (define (start-size l)
	(min-max->start-size (car l) (caddr l)))
      (let loop ((stack '()))
	(let ((l (read-line (stdin) 'concat)))
	  (cond ((eof-object? l)
		 (error "no bounding box found"))
		((string-match "^%%BoundingBox:(.*)" l)
		 => (lambda (m)
		      (let* ((sbox (match:substring m 1))
			     (box (string->sexpr-list sbox))) ; ugh
			(receive (x-start x-size) (start-size box)
			  (receive (y-start y-size) (start-size (cdr box))
			    (run (| (begin (format #t "~S ~S translate "
						   (- x-start) (- y-start))
					   ;; (format #t "~S ~S scale " (/ 72 screen-dpi) (/ 72 screen-dpi))
					   (newline)
					   (for-each write-string (reverse stack))
					   ; (exec-epf (cat))
					   (let loop ()
					     (let ((l (read-line (stdin) 'concat)))
					       (cond ((eof-object? l) 'ok)
						     (else (write-string l)
							   (loop)))))
					   (format #t "showpage~%"))

				    (gs -sDEVICE=pbmraw
					,(format #f "-g~Sx~S"
						 (* (int x-size) scale)
						 (* (int y-size) scale))
					,(format #f "-r~S" (* 72 scale))
					-sOutputFile=- -q -)
				    (pnmscale ,(number->string (/ 1.0 scale)))
				    (pgmhack))
				 stdports))))))
		(else (loop (cons l stack)))))))

    (define *jobs* '())

    ; takes a string, converts to postscript, leave in fname.  but
    ; does nothing until textops-flush is called
    (define (textops-queue s fname)
      (set! *jobs* (cons (cons s fname) *jobs*)))

    (define (textops s f)
      (textops-queue s f)
      (textops-flush))

    (define tex-init-string "\\include{code}")

    ; it's terribly inefficient to break the dvi file into a separate
    ; postscript file for each page, and then run GS (via pstogif)
    ; once for each page.  GS has the capability to render multiple
    ; pages to multiple files.  unfortunately it's not clear how to
    ; get/set bounding box for each page; dvips certainly doesn't have
    ; this capability.

    (define (textops-flush)
      (let* ((tex-file "./textops.tex")
	     (dvi-file (replace-extension tex-file ".dvi"))
	     (o (open-output-file tex-file)))
	(write-string "\\documentstyle{article}" o)
	(write-string "\\pagestyle{empty}" o)
	(write-string tex-init-string o)
	(write-string "\\begin{document}" o)
	(for-each (lambda (sf)
		    (format o "~A\\newpage~%" (car sf)))
		  *jobs*)
	(write-string "\\end{document}" o)
	(newline o)
	(close o)
	(with-cwd (file-name-directory tex-file)
		  (run (latex ,tex-file)))
	(let loop ((n 1) (l *jobs*))
	  (cond ((null? l) 'ok)
		(else (run (dvips -p ,n -n 1 -x 2000 -f -E ,dvi-file)
			   (> ,(cdar l)))
		      (loop (+ n 1) (cdr l)))))
	(set! *jobs* '())))
    

    (define (string->sexpr-list s)
      (let ((sport (make-string-input-port s)))
	(port->sexp-list sport)))

    (define (int x) (inexact->exact (truncate x)))

    (define (pstogif)
      (run (| (begin (pstoppm))
	      (ppmtogif)) ;  -interlace?
	   stdports))

    (define pstogif-file
      (filter->file-op pstogif "gif"))

    (define pstoppm-file
      (filter->file-op pstoppm "ppm"))
    
    ))
