/* This file is some useful functions for randomness
   They assume that the random number generator has been seeded */
#ifndef _RANDOM_H_
#define _RANDOM_H_

int   int_random(int n);
float range_random(float lo, float hi);
int   very_random_int(int n);
inline float prob_random() { return range_random(0.0, 1.0); }

//exponential is often represented with theta=0
// any max < 0 is ignored
// if you give a bad value of max, you can end up in an infinite loop. Be careful
float sample_exponential(float theta, float lambda, float max = -1.0);
  
#endif
