/* This file is some useful functions for randomness
   They assume that the random number generator has been seeded */

#include <stdlib.h>
#include <math.h>
#include "random.hpp"
#include "Logger.hpp"

using namespace spades;

/* From Andrew's C package                                                  */

int int_random(int n)
{
  if ( n > 2 )
    return( random() % n );
  else if ( n == 2 )
    return( ( (random() % 112) >= 56 ) ? 0 : 1 );
  else if ( n == 1 )
    return(0);
  else
  {
    errorlog << "You called int_random(<=0)" << ende;    
    return(0);
  }
}

float range_random(float lo, float hi)
{
  int x1 = int_random(10000);
  int x2 = int_random(10000);
  float r = (((float) x1) + 10000.0 * ((float) x2))/(10000.0 * 10000.0);
  return( lo + (hi - lo) * r );
}

int very_random_int(int n)
{
  int result = (int) range_random(0.0,(float)n);  /* rounds down */
  if ( result == n ) result = n-1;
  return(result);
}

//exponential is often represented with theta=0
// if you give a bad value of max, you can end up in an infinite loop. Be careful
float
sample_exponential(float theta, float lambda, float max)
{
  /* the CDF of the exponential is 1-exp((theta-y)/lambda)
     the inverse of this is theta - lambda ln(1-p) */
  float sample = 0;
  do
    {
      float prob = prob_random();
      sample = theta - lambda * log(1-prob);
    }
  while (max > 0.0 && sample > max);

  return sample;
}

  
