/* this stores state/action advice utterances */

#ifndef _SA_ADVICE_REPOSITORY_H_
#define _SA_ADVICE_REPOSITORY_H_

#include <list>
#include <vector>
#include <iostream>
#include "SAAdvice.hpp"

class QTable; 

class SAAdviceRepository
{
public:
  SAAdviceRepository(unsigned num_states);
  virtual ~SAAdviceRepository();

  //most recent advice is first in the list
  typedef std::list<int> state_entry_t;
  //this is indexed by flat state value
  typedef std::vector<state_entry_t> vec_advice_t;

  const state_entry_t& getStateAdvice(unsigned idx) const;
  //move returned in pact
  //returns whether 
  bool getFirstEnabled(unsigned state_idx, const QTable* pQT, int* pact) const;

  void addAdvice(const SAAdvice& sa);
  void addAdvice(vec_sa_advice_t vsa);

  friend std::ostream& operator<<(std::ostream& os, const SAAdviceRepository& saar);

protected:
  // These could be used to place limits on advice
  // If false is returned, the advice is not added
  virtual bool checkAddAdvice(const SAAdvice& sa) { return true; }
  virtual void notifyAddAdvice(unsigned state_idx, state_entry_t::iterator iter) {}
  
  vec_advice_t vec_advice;
  
};

std::ostream& operator<<(std::ostream& os, const SAAdviceRepository::state_entry_t& se);



#endif
