/* this stores state/action advice utterances */

#include "SAAdviceRepository.hpp"
#include "QTable.hpp"
#include "Logger.hpp"

using namespace spades;
using namespace std;

/********************************************************************************************/

SAAdviceRepository::SAAdviceRepository(unsigned num_states)
  : vec_advice(num_states, state_entry_t())
{
}

SAAdviceRepository::~SAAdviceRepository()
{
}

/********************************************************************************************/

const SAAdviceRepository::state_entry_t&
SAAdviceRepository::getStateAdvice(unsigned idx) const
{
  if (idx >= vec_advice.size())
    errorlog << "getStateAdvice: out of range " << idx << " >= " << vec_advice.size() << ende;
  return vec_advice[idx];
}

bool
SAAdviceRepository::getFirstEnabled(unsigned state_idx, const QTable* pQT, int* pact) const
{
  for (state_entry_t::const_iterator iter = vec_advice[state_idx].begin();
       iter != vec_advice[state_idx].end();
       iter++)
    {
      if (pQT->isEnabled(state_idx, *iter))
	{
	  *pact = *iter;
	  return true;
	}
    }

  return false;
  
}

void
SAAdviceRepository::addAdvice(const SAAdvice& sa)
{
  unsigned sidx = sa.getStateVal();
  int m = sa.getMove();

  if (sidx >= vec_advice.size())
    {
      errorlog << "addAdvice: out of range " << sidx << " >= " << vec_advice.size() << ende;
      return;
    }

  if (!checkAddAdvice(sa))
    {
      actionlog(100) << "Advice " << sa << " was rejected by checkAddADvice" << ende;
      return;
    }

  vec_advice[sidx].push_front(m);
  notifyAddAdvice(sidx, vec_advice[sidx].begin());
}

void
SAAdviceRepository::addAdvice(vec_sa_advice_t vsa)
{
  for (vec_sa_advice_t::const_iterator iter = vsa.begin();
       iter != vsa.end();
       iter++)
    {
      addAdvice(*iter);
    }
}

/********************************************************************************************/

std::ostream&
operator<<(std::ostream& os, const SAAdviceRepository& saar)
{
  os << saar.vec_advice.size() << endl;
  SAAdviceRepository::vec_advice_t::const_iterator iter;
  unsigned sidx = 0;
  for (iter = saar.vec_advice.begin();
       iter != saar.vec_advice.end();
       iter++, sidx++)
    {
      os << sidx << ' ' << *iter << endl;
    }
  return os;
}

std::ostream&
operator<<(std::ostream& os, const SAAdviceRepository::state_entry_t& se)
{
  os << se.size() << ' ';
  for (SAAdviceRepository::state_entry_t::const_iterator iter = se.begin();
       iter != se.end();
       iter++)
    os << *iter << ' ';
  return os;
}

