/* this is a single state/action piece of advice */

#ifndef _SA_ADVICE_H_
#define _SA_ADVICE_H_

#include <vector>

//StateAcion Advice
class SAAdvice 
{
public:
  SAAdvice() : stateval(-1), move(-1) {}
  SAAdvice(int stateval, int m) : stateval(stateval), move(m) {}
  SAAdvice(const SAAdvice& sa)  : stateval(sa.stateval), move(sa.move) {}
  ~SAAdvice() {}

  int getStateVal() const { return stateval; }
  int getMove() const { return move; }

  friend std::ostream& operator<<(std::ostream& o, const SAAdvice& sa)
  { o << sa. stateval << ' ' << sa.move; return o; }
  friend std::istream& operator>>(std::istream& is, SAAdvice& sa)
  { is >> sa.stateval >> sa.move; return is; }
    
private:
  int stateval;
  int move;
};

typedef std::vector<SAAdvice> vec_sa_advice_t;

inline std::ostream& operator<<(std::ostream& os, const vec_sa_advice_t& v)
{
  for (vec_sa_advice_t::const_iterator iter = v.begin(); iter != v.end(); iter++)
    os << *iter << ' ';
  return os;
}

#endif
