/* a simple class to do table based Q-learning.
   The representation is flat in the sense that all states have the same number of actions
   Assumes unsigned ints for state and action space */

#ifndef _Q_TABLE_FLAT_H_
#define _Q_TABLE_FLAT_H_

#include <vector>
#include "QTable.hpp"

class QTableFlat
  : public QTable
{
public:
  QTableFlat(int num_states, int num_actions, float gamma);
  QTableFlat(const char* fn);
  ~QTableFlat();

  //returns -1 if state is invalid
  int getNumActions(int state) const { return checkValid(state, -1) ? num_actions : -1; }

  //zeros all ENABLED actions
  void zero();

  int getNumActions() const { return num_actions; }

  //Format: <num_states> <num_actions> <gamma>
  //Format: then 1 line per state of <qvalue> <#visits> <qvalue> <#visits> ...
  friend std::ostream& operator<<(std::ostream& o, const QTableFlat& qt);
  friend std::istream& operator>>(std::istream& i, QTableFlat& qt);


protected:
  StateActionEntry* getSA(int state, int action);
  const StateActionEntry* getSA(int state, int action) const;

  
  //a -1 for action just verifies the state
  bool checkValid(int state, int action) const;

private:
  void resizeTable();
  
  unsigned int getIdx(int state, int action) const;

  int num_actions;

  std::vector<StateActionEntry> vQTable;
  
  
};



#endif

