/* A class describing a policy in this gridworld */

#ifndef _POLICY_H_
#define _POLICY_H_

#include <vector>

class QTable; //defined in QTable.hpp

/* We will allow the action query function to take a rotation value.
   This allows us to specify the "same" policy for two agents by saying
   both considering themselves as "first" */
class Policy
{
public:
  Policy(int num_states);
  Policy(const char* fn);
  ~Policy();

  int getAction(unsigned stateidx) const;
  void setAction(unsigned stateidx, int action);

  void extractFromQTable(const QTable* pQ);

  friend std::ostream& operator<<(std::ostream& o, const Policy& p);
  friend std::istream& operator>>(std::istream& i, Policy& p);

private:

  //this is indexed by the flat state value
  std::vector<int> vAct;
  
};



#endif

