/* a child of SAAdviceRepository
   limits advice by keeping a fixed amount of advice in FIFO order */

#ifndef FIFO_LIM_SA_ADVICE_REPOSITORY_H_
#define FIFO_LIM_SA_ADVICE_REPOSITORY_H_

#include <list>
#include "SAAdviceRepository.hpp"

class FIFOLimSAAdviceRepository 
  : public SAAdviceRepository
{
public:
  FIFOLimSAAdviceRepository(unsigned num_states, unsigned amount_to_store);
  ~FIFOLimSAAdviceRepository();

protected:
  //main callback from SAAdviceRepository
  void notifyAddAdvice(unsigned state_idx, state_entry_t::iterator iter);
  
private:
  class AdviceQueueEntry
  {
  public:
    AdviceQueueEntry(unsigned state_idx, state_entry_t::iterator iter)
      : state_idx(state_idx), iter(iter) {}
    unsigned state_idx;
    state_entry_t::iterator iter;
  };
  
  typedef std::list<AdviceQueueEntry> advice_queue_t;
  advice_queue_t advice_queue;
  unsigned amount_to_store;
  
};



#endif
