/* a child of SAAdviceRepository
   limits advice by keeping a fixed amount of advice in FIFO order */

#include "FIFOLimSAAdviceRepository.hpp"

FIFOLimSAAdviceRepository::FIFOLimSAAdviceRepository(unsigned num_states, unsigned amount_to_store)
  : SAAdviceRepository(num_states), amount_to_store(amount_to_store)
{
}


FIFOLimSAAdviceRepository::~FIFOLimSAAdviceRepository()
{
}



void
FIFOLimSAAdviceRepository::notifyAddAdvice(unsigned state_idx, state_entry_t::iterator iter)
{
  advice_queue.push_back(AdviceQueueEntry(state_idx, iter));

  while (advice_queue.size() > amount_to_store)
    {
      AdviceQueueEntry& entry = *advice_queue.begin();
      vec_advice[entry.state_idx].erase(entry.iter);
      advice_queue.pop_front();
    }
}

