/* this class represents a set of actions for the states
   This is closesly tied to the QTable notion of disabled actions */

#ifndef _ACTION_SUBSET_MAP_H_
#define _ACTION_SUBSET_MAP_H_

#include <vector>
#include <set>
#include "StateFilter.hpp"

class QTable; //defined in QTable.hpp
class Policy; //defined in Policy.hpp

class ActionSubsetMap
{
public:
  ActionSubsetMap() : num_states(-1) {}
  ActionSubsetMap(int num_states);
  ActionSubsetMap(const char* fn);
  ~ActionSubsetMap() {}

  int getNumStates() const { return num_states; }

  void extractDisabledFromQTable(const QTable& qt)
  { extractFromQTable(qt, false); }
  void extractEnabledFromQTable(const QTable& qt)
  { extractFromQTable(qt, true); }
  //enabled true means get the enabled actions, false means get the disabled ones
  void extractFromQTable(const QTable& qt, bool enabled);

  //asumes a constant number of actions
  void invert(int num_actions);
  //reads the number of actions from the QTable
  void invert(const QTable& qt);

  /* this is an in place union */
  void unionWith(const ActionSubsetMap& m);

  /* removes each action with probability prob */
  int removeRandom(float prob);
  int removeOnePerState();

  bool isIn(int state, int action);

  int count(int state) const;

  int getElement(int state, int idx);

  void compareToPolicy(Policy& p, StateFilter* pfilter, int* cnt_in, int* cnt_out, int* cnt_skip);
  
  //Format: <num_states>
  //Format: then 1 line per state of <num disabled> <list of ints> 
  friend std::ostream& operator<<(std::ostream& o, const ActionSubsetMap& m);
  friend std::istream& operator>>(std::istream& i, ActionSubsetMap& m);

protected:
  //we allow QTable a little more direct access
  friend class QTable;

  typedef std::set<int> ActionSet;
  typedef std::vector<ActionSet> StateList;

  const StateList& getVActions() const { return v_actions; }
  
private:
  void resize();
  
  int num_states;

  StateList v_actions;
  
};



#endif
