Require Import Syntax.
Require Import Semantics.
Require Import ArithLem.
Require Import Debruijn2Facts.

Set Implicit Arguments.

(* Tactic to rewrite all hypotheses -- from Adam Chlipala *)
Ltac rewriteall H :=
     let n := fresh "val" in
     (match type of H with
        ?E1 = ?E2 =>
            set (n:= E1) in * ;
            clearbody n;
            subst n
      end).

(* Weakening lemma *)

Lemma weakening :
  (forall Gamma V P, val_tp Gamma V P ->
    forall Gamma1 Gamma2 Delta, Gamma = Gamma1++Gamma2 ->
      val_tp (Gamma1++(Delta::Gamma2)) (shift_val (length Gamma1) V) P) /\
  (forall Gamma F P Q, fnc_tp Gamma F P Q ->
    forall Gamma1 Gamma2 Delta, Gamma = Gamma1++Gamma2 ->
      fnc_tp (Gamma1++(Delta::Gamma2)) (shift_fnc (length Gamma1) F) P Q) /\
  (forall Gamma E P, exp_tp Gamma E P ->
    forall Gamma1 Gamma2 Delta, Gamma = Gamma1++Gamma2 ->
      exp_tp (Gamma1++(Delta::Gamma2)) (shift_exp (length Gamma1) E) P) /\
  (forall Gamma sigma Delta', sub_tp Gamma sigma Delta' ->
    forall Gamma1 Gamma2 Delta, Gamma = Gamma1++Gamma2 ->
      sub_tp (Gamma1++(Delta::Gamma2)) (shift_sub (length Gamma1) sigma) Delta').
apply typing_mutual_ind with
 (P := (fun g V' P (_ : val_tp g V' P) =>
   forall Gamma1 Gamma2 Delta, g = Gamma1 ++ Gamma2 ->
     val_tp (Gamma1++(Delta::Gamma2)) (shift_val (length Gamma1) V') P))
 (P0 := (fun g F' P Q (_ : fnc_tp g F' P Q) =>
   forall Gamma1 Gamma2 Delta, g = Gamma1 ++ Gamma2 ->
     fnc_tp (Gamma1++(Delta::Gamma2)) (shift_fnc (length Gamma1) F') P Q))
 (P1 := (fun g E' P (_ : exp_tp g E' P) =>
   forall Gamma1 Gamma2 Delta, g = Gamma1 ++ Gamma2 ->
     exp_tp (Gamma1++(Delta::Gamma2)) (shift_exp (length Gamma1) E') P))
 (P2 := (fun g sigma' d (_ : sub_tp g sigma' d) =>
   forall Gamma1 Gamma2 Delta, g = Gamma1 ++ Gamma2 ->
     sub_tp (Gamma1++(Delta::Gamma2)) (shift_sub (length Gamma1) sigma') d));
  intros; simpl; try (rewriteall H0 || rewriteall H1).

eauto with focus.

apply LamTp; intros p Delta' pH;
 apply (H p Delta' pH (Delta'::Gamma1) Gamma2 Delta); auto.

eauto with focus.

destruct f as (i',k).
 elim (le_gt_dec (length Gamma1) i'); intro cmp; eapply IdVarTp.
  rewrite (lookup_ith2 Gamma1 Gamma2 k cmp) in e;
  rewrite (lookup_ith2 Gamma1 (Delta :: Gamma2) k (i := S i')); auto;
  rewrite <- minus_Sn_m; auto.

  rewrite (lookup_ith1 Gamma1 Gamma2 k cmp) in e;
  rewrite (lookup_ith1 Gamma1 (Delta :: Gamma2) k cmp);
  assumption.

apply FixTp;
 apply (H ((ArrowH P Q :: nil) :: Gamma1) Gamma2 Delta); trivial.

eauto with focus.

destruct g as (i',k).
 elim (le_gt_dec (length Gamma1) i'); intro cmp; eapply ECompTp with (P := P) (Q := Q); auto.
  rewrite (lookup_ith2 Gamma1 Gamma2 k cmp) in e;
  rewrite (lookup_ith2 Gamma1 (Delta :: Gamma2) k (i := S i')); auto;
  rewrite <- minus_Sn_m; auto.

  rewrite (lookup_ith1 Gamma1 Gamma2 k cmp) in e;
  rewrite (lookup_ith1 Gamma1 (Delta :: Gamma2) k cmp);
  assumption.

eauto with focus.
eauto with focus.
eauto with focus.
unfold shift_sub in H0; eauto with focus.
Qed.

Definition val_weakening := proj1 weakening.
Definition fnc_weakening := proj1 (proj2 weakening).
Definition exp_weakening := proj1 (proj2 (proj2 weakening)).
Definition sub_weakening := proj2 (proj2 (proj2 weakening)).

Lemma sub_weak1 :
  forall Gamma sigma Delta, sub_tp Gamma sigma Delta ->
    forall Delta', sub_tp (Delta' :: Gamma) (shift_sub 0 sigma) Delta.
intros.
change (Delta' :: Gamma) with (nil ++ (Delta' :: Gamma));
change 0 with (length (nil:intctx)).
eapply sub_weakening; simpl; eauto.
Qed.

Lemma fnc_weak1 :
  forall Gamma F P Q, fnc_tp Gamma F P Q ->
    forall Delta', fnc_tp (Delta' :: Gamma) (shift_fnc 0 F) P Q.
intros.
change (Delta' :: Gamma) with (nil ++ (Delta' :: Gamma));
change 0 with (length (nil:intctx)).
eapply fnc_weakening; simpl; eauto.
Qed.

(* Substitution-typing inversion lemma *)

Lemma subtp_inv :
  forall Gamma sigma Delta,
  sub_tp Gamma sigma Delta ->
  forall k P Q,
    lookup_frame k Delta = Some (ArrowH P Q) ->
    fnc_tp Gamma (lookup_sub k sigma) P Q.
intros Gamma sigma Delta H.
induction H; intros.
elim (emp_frame k H).
destruct k.
 compute in H1; injection H1; intros H2 H3; elim H2; elim H3; auto.
 apply (IHsub_tp k P0 Q0 H1).
Qed.

(* Substitution lemma *)

Lemma substitution :
  (forall Gamma V P, val_tp Gamma V P -> 
    forall Gamma1 Gamma2 Delta sigma,
      Gamma = Gamma1 ++ (Delta :: Gamma2) -> 
      sub_tp (Gamma1 ++ Gamma2) sigma Delta ->
      val_tp (Gamma1 ++ Gamma2) (sub_val (length Gamma1) sigma V) P) /\
  (forall Gamma F P Q, fnc_tp Gamma F P Q ->
    forall Gamma1 Gamma2 Delta sigma,
      Gamma = Gamma1 ++ (Delta :: Gamma2) -> 
      sub_tp (Gamma1 ++ Gamma2) sigma Delta ->
      fnc_tp (Gamma1 ++ Gamma2) (sub_fnc (length Gamma1) sigma F) P Q) /\
  (forall Gamma E P, exp_tp Gamma E P ->
    forall Gamma1 Gamma2 Delta sigma,
      Gamma = Gamma1 ++ (Delta :: Gamma2) -> 
      sub_tp (Gamma1 ++ Gamma2) sigma Delta ->
      exp_tp (Gamma1 ++ Gamma2) (sub_exp (length Gamma1) sigma E) P) /\
  (forall Gamma sigma' Delta', sub_tp Gamma sigma' Delta' ->
    forall Gamma1 Gamma2 Delta sigma,
      Gamma = Gamma1 ++ (Delta :: Gamma2) -> 
      sub_tp (Gamma1 ++ Gamma2) sigma Delta ->
      sub_tp (Gamma1 ++ Gamma2) (sub_sub (length Gamma1) sigma sigma') Delta').
apply typing_mutual_ind with
 (P := (fun g V' P (_ : val_tp g V' P) =>
   forall Gamma1 Gamma2 Delta sigma,
   g = Gamma1 ++ (Delta :: Gamma2) ->
   sub_tp (Gamma1 ++ Gamma2) sigma Delta ->
   val_tp (Gamma1 ++ Gamma2) (sub_val (length Gamma1) sigma V') P))
 (P0 := (fun g F' P Q (_ : fnc_tp g F' P Q) =>
   forall Gamma1 Gamma2 Delta sigma,
   g = Gamma1 ++ (Delta :: Gamma2) ->
   sub_tp (Gamma1 ++ Gamma2) sigma Delta ->
   fnc_tp (Gamma1 ++ Gamma2) (sub_fnc (length Gamma1) sigma F') P Q))
 (P1 := (fun g E' P (_ : exp_tp g E' P) =>
   forall Gamma1 Gamma2 Delta sigma,
   g = Gamma1 ++ (Delta :: Gamma2) ->
   sub_tp (Gamma1 ++ Gamma2) sigma Delta ->
   exp_tp (Gamma1 ++ Gamma2) (sub_exp (length Gamma1) sigma E') P))
 (P2 := (fun g sigma' d (_ : sub_tp g sigma' d) =>
   forall Gamma1 Gamma2 Delta sigma,
   g = Gamma1 ++ (Delta :: Gamma2) ->
   sub_tp (Gamma1 ++ Gamma2) sigma Delta ->
   sub_tp (Gamma1 ++ Gamma2) (sub_sub (length Gamma1) sigma sigma') d));
 intros; simpl.
eauto with focus.

eapply LamTp.
 intros.
 apply (H p Delta0 H2 (Delta0 :: Gamma1) Gamma2 Delta (shift_sub 0 sigma)).
 rewrite H0; trivial.
 rewrite <- app_comm_cons; apply (sub_weak1 H1).

eauto with focus.

destruct f as (i',k).
 elim (eq_nat_decide (length Gamma1) i'); intro eqH.
 eapply subtp_inv.
  eauto.
  rewrite <- (lookup_ith3 Gamma1 Delta Gamma2 k
    (eq_nat_eq (length Gamma1) i' eqH)); rewrite <- H; assumption.

 eapply IdVarTp;
 rewrite <- e; rewrite H; apply ls_tri; auto.

eapply FixTp.
 pose (fDelta := (ArrowH P Q :: nil)).
 apply (H (fDelta::Gamma1) Gamma2 Delta (shift_sub 0 sigma)).
 rewrite H0; trivial.
 apply (sub_weak1 H1 fDelta).

eauto with focus.

destruct g as (i',k).
 elim (eq_nat_decide (length Gamma1) i'); intro eqH.
 eapply EAppETp.
 eapply EAppVTp.
 eauto with focus.
 apply (subtp_inv H2).
 rewrite <- (lookup_ith3 Gamma1 Delta Gamma2 k 
   (eq_nat_eq (length Gamma1) i' eqH));
 rewrite <- H1; apply e.
 eauto with focus.
 
 eapply ECompTp with (P := P) (Q := Q);
  [ rewrite <- e; rewrite H1; apply ls_tri; auto
  | eauto with focus | eauto with focus ].

eauto with focus.
eauto with focus.
eauto with focus.
unfold sub_sub in H0; eauto with focus.
Qed.

Definition val_substitution := proj1 substitution.
Definition fnc_substitution := proj1 (proj2 substitution).
Definition exp_substitution := proj1 (proj2 (proj2 substitution)).
Definition sub_substitution := proj2 (proj2 (proj2 substitution)).

Lemma exp_subst1 :
  forall Gamma Delta P E sigma,
    exp_tp (Delta :: Gamma) E P ->
    sub_tp Gamma sigma Delta ->
    exp_tp Gamma (sub_exp 0 sigma E) P.
intros.
change Gamma with (nil ++ Gamma); change 0 with (length (nil:intctx)).
eapply exp_substitution; simpl; eauto.
Qed.

Lemma fnc_subst1 :
  forall Gamma Delta P Q F sigma,
    fnc_tp (Delta :: Gamma) F P Q ->
    sub_tp Gamma sigma Delta ->
    fnc_tp Gamma (sub_fnc 0 sigma F) P Q.
intros.
change Gamma with (nil ++ Gamma); change 0 with (length (nil:intctx)).
eapply fnc_substitution; simpl; eauto.
Qed.

Lemma preservation :
  forall E E', step E E' -> 
    forall Gamma P, exp_tp Gamma E P -> exp_tp Gamma E' P.
intros E E' H0.
induction H0; intros Gamma P H; inversion H.

inversion H3; inversion H5; apply (exp_subst1 (H14 p Delta H9) H11).

inversion H5; rewrite H9 in H3; eauto with focus.

apply (EAppETp (IHstep Gamma P0 H4) H6).

inversion H3; eapply EAppVTp; eauto with focus.

inversion H5; eapply EAppVTp;
  [ eauto |  eapply fnc_subst1; eauto with focus].
Qed.

Lemma progress :
  forall E P, exp_tp nil E P ->
    (exists V, E = Return V) \/ (exists E', step E E').
induction E; intros.

eauto.

inversion_clear H; elim (emp_stack i H0).

right; exists (stepf (EAppV f v));
  inversion H; inversion H3; inversion H5; simpl;
  (auto with focus_sem ||  elim (emp_stack f0 H11)).

right; inversion_clear H; elim (IHE P0 H0); intro H;
 [ destruct H as (V); rewrite H;
   exists (stepf (EAppE f (Return V))); simpl; auto with focus_sem 
 | destruct H as (E'); exists (EAppE f E'); auto with focus_sem ].

inversion H.
Qed.
