Require Import List.
Require Import Syntax.
Require Import Semantics.

Definition not_fnc : fnc :=
  Lam (fun p =>
    match p with
    | Tr => Return (Val Fa (Sub nil))
    | Fa => Return (Val Tr (Sub nil))
    | _ => EFail
    end).

Definition and_fnc : fnc :=
  Lam (fun p =>
    match p with 
    | Pair Tr Tr => Return (Val Tr (Sub nil))
    | Pair Tr Fa => Return (Val Fa (Sub nil))
    | Pair Fa Tr => Return (Val Fa (Sub nil))
    | Pair Fa Fa => Return (Val Fa (Sub nil))
    | _ => EFail
    end).


Definition fmap (phi : exp) (p : pat) : exp :=
  match p with Fvar => phi | _ => EFail end.

Definition table1_fnc : fnc :=
  Lam (fmap (EComp
    (Lam (fun b1 => EComp
    (Lam (fun b2 => Return (Val (Pair b1 b2) (Sub nil))))
    (1,0) (Val Fa (Sub nil))))
    (0,0) (Val Tr (Sub nil)))).

Definition plus_fnc :=
  Fix (Lam (fun p =>
    match p with
    | Pair m Ze => Return (Val m (Sub nil))
    | Pair m (Su n) => EComp (Lam (fun n' => Return (Val (Su n') (Sub nil))))
                         (1,0) (Val (Pair m n) (Sub nil))
    | _ => EFail
    end)).

(* Typechecking *)
Load "tctacs".

Fact and_tp : fnc_tp nil and_fnc (Times Bool Bool) Bool.
checktm.
Qed.

Fact not_tp : fnc_tp nil not_fnc Bool Bool.
checktm.
Qed.

Fact table1_tp : fnc_tp nil table1_fnc (Arrow Bool Bool) (Times Bool Bool).
checktm.
Qed.

Fact plus_tp : fnc_tp nil plus_fnc (Times Nat Nat) Nat.
checktm.
Qed.

(* Evaluation *)

Eval compute in
  stepn (EAppE and_fnc (EAppV table1_fnc (Val Fvar (Sub (not_fnc :: nil))))) 9.
(* evaluates to Return (Val Fa (Sub nil)) *)

Eval compute in
  stepn (EAppV plus_fnc (Val (Pair (Su (Su Ze)) (Su Ze)) (Sub nil))) 6.
(* evaluates to Return (Val (Su (Su (Su Ze))) (Sub nil)) *)
