Require Import ArithLem.
Require Import Debruijn2.

Set Implicit Arguments.

Section Facts.
  Variable A : Set.

  Lemma emp_frame : forall k (a:A), ~(lookup_frame k nil = Some a).
    intros; unfold lookup_frame; unfold nth_error; destruct k; discriminate.
  Qed.
  Lemma emp_stack : forall i (a:A), ~(lookup_stack i nil = Some a).
    intros; unfold lookup_stack; unfold nth; destruct (fst i); apply emp_frame.
  Qed.

  Lemma u1 : forall k (Delta:frame A),
    lookup_frame k Delta = nth_error Delta k.
    trivial.
  Qed.
  Lemma u2 : forall i (Gamma:stack A),
    lookup_stack i Gamma = lookup_frame (snd i) (nth (fst i) Gamma nil).
    trivial.
  Qed.
  
  Hint Rewrite u1 u2 : debruijn.

  Lemma lookup_ith1 :
    forall (Gamma1:stack A) (Gamma2:stack A) i k,
      i < length Gamma1 ->
      lookup_stack (i,k) (Gamma1 ++ Gamma2) = lookup_stack (i,k) Gamma1.
    intros; autorewrite with debruijn; rewrite app_nth1; trivial.
  Qed.
  
  Lemma lookup_ith2 :
    forall (Gamma1:stack A) (Gamma2:stack A) i k,
      i >= length Gamma1 ->
      lookup_stack (i,k) (Gamma1 ++ Gamma2) =
      lookup_stack (i-length Gamma1,k) Gamma2.
    intros; autorewrite with debruijn; rewrite app_nth2; trivial.
  Qed.

  Lemma lookup_ith3 :
    forall (Gamma1:stack A) (Delta:frame A) (Gamma2:stack A) i k,
      length Gamma1 = i ->
      lookup_stack (i,k) (Gamma1 ++ (Delta :: Gamma2)) =
      lookup_frame k Delta.
   intros.
   rewrite lookup_ith2; rewrite H.
   rewrite <- minus_n_n; autorewrite with debruijn; trivial.
   auto with arith.
  Qed.

  Lemma ls_tri :
    forall (Gamma1:stack A) (Delta:frame A) (Gamma2:stack A) i i' k,
      length Gamma1 = i -> ~eq_nat i i' ->
      lookup_stack (if le_lt_dec i i' then i'-1 else i', k) (Gamma1++Gamma2) =
      lookup_stack (i',k) (Gamma1++(Delta::Gamma2)).
  intros Gamma1 Delta Gamma2 i i' k lenH eqH.
  elim (le_lt_dec i i'); intro cmpH;
    autorewrite with debruijn; simpl;
    apply f_equal with (f := fun (l:frame A) => nth_error l k).

  pose (ltH := le_ne_lt i i' cmpH (neq_nat_neq i i' eqH)).
  rewrite app_nth2.
  change (Delta :: Gamma2) with ((Delta :: nil) ++ Gamma2).
  rewrite app_nth2.
  rewrite minus_comm; symmetry.
  apply (app_nth2 (Delta :: nil) Gamma2 nil).
  simpl; rewrite lenH; auto with arith.
  rewrite lenH; auto.

  rewrite lenH; rewrite <- (pred_of_minus i');
  destruct i'; auto with arith.

  rewrite <- lenH in cmpH;
  rewrite app_nth1; [ rewrite app_nth1; auto | auto ].
  Qed.
End Facts.

