Require Export List.

Set Implicit Arguments.

(* Two-level debruijn indexes *)
Section Debruijn2.
  Variable A : Set.
  
  Definition frame (A : Set) := list A.
  Definition stack (A : Set) := list (frame A).
  
  Definition index : Set := prod nat nat.
  
  Definition lookup_frame (k : nat) (Delta : frame A) := nth_error Delta k.
  Definition lookup_stack (i : index) (Gamma : stack A)
    := lookup_frame (snd i) (nth (fst i) Gamma nil).
  
End Debruijn2.
