Require Export Arith.
Require Export EqNat.
Require Export Compare.

(* arithmetic lemmas *)

Lemma neq_nat_neq : forall n m, ~(eq_nat n m) -> n <> m.
auto with arith.
Qed.
Hint Immediate neq_nat_neq: arith v62.

Lemma minus_pred_S : forall n m, pred(n - m) = n - S m.
induction n.
auto with arith.
destruct m.
auto with arith.
change (S n - S (S m)) with (n - S m).
rewrite <- (IHn m).
trivial.
Qed.
Hint Immediate minus_pred_S: arith v62.
Hint Rewrite minus_pred_S: arith.

Lemma pred_minus : forall n m, pred (n - m) = pred n - m.
intros; rewrite (minus_pred_S n m); 
induction n; auto with arith.
Qed.
Hint Immediate pred_minus : arith v62.
Hint Rewrite pred_minus : arith.

Lemma le_ne_lt : forall n m, n <= m -> n <> m -> n < m.
induction n.
auto with arith.
induction m; intros.
elim (le_Sn_O n H).
apply (lt_n_S n m).
auto with arith.
Qed.
Hint Immediate le_ne_lt : arith v62.

Lemma minus_comm : forall n m p, n - m - p = n - p - m.
intros.
induction m.
rewrite <- minus_n_O; auto with arith.
rewrite <- (minus_pred_S n m).
rewrite <- (minus_pred_S (n - p) m).
rewrite <- IHm.
symmetry.
apply pred_minus.
Qed.
Hint Immediate minus_comm : arith v62.

Lemma lt_minus : forall n m, m < n -> 0 < n - m.
intros.
destruct n.
elim (lt_n_O m H).
rewrite <- (minus_Sn_m n m (lt_n_Sm_le m n H)).
auto with arith.
Qed.
Hint Immediate lt_minus : arith v62.
