package rpi.popup.actions;

import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.compiler.IScanner;
import org.eclipse.jdt.core.compiler.ITerminalSymbols;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class RPAction implements IObjectActionDelegate {

	/**
	 * Constructor for Action1.
	 */
	public RPAction() {
		super();
	}

	/**
	 * @see IObjectActionDelegate#setActivePart(IAction, IWorkbenchPart)
	 */
	public void setActivePart(IAction action, IWorkbenchPart targetPart) {
	}

	/**
	 * @see IActionDelegate#run(IAction)
	 */
	public void run(IAction action) {
		if( curClass != null ) {
			ICompilationUnit cu = curClass.getCompilationUnit();
			try {
				if (cu.isWorkingCopy()) {
					IBuffer buffer = cu.getBuffer();

					IScanner scanner =
						ToolFactory.createScanner(false, false, false, false);
					scanner.setSource(buffer.getCharacters());

					for( IMethod method : curClass.getMethods() ) {
						if( method.isMainMethod() ) {
							ISourceRange sr = method.getSourceRange();
							scanner.resetTo(
									sr.getOffset(),
									sr.getOffset() + sr.getLength() - 1);

							int token = scanner.getNextToken();
							while (token != ITerminalSymbols.TokenNameEOF
									&& token != ITerminalSymbols.TokenNameSEMICOLON) {
								token = scanner.getNextToken();
								if (token == ITerminalSymbols.TokenNameLBRACE) {
									buffer.replace(scanner.getCurrentTokenEndPosition() + 1, 0, codeToAdd);
									break;
								}
							}
						}
					}
					cu.reconcile();
				}

			} catch(JavaModelException jme) {

			} catch(InvalidInputException iie) {

			}
		}
	}

	/**
	 * @see IActionDelegate#selectionChanged(IAction, ISelection)
	 */
	public void selectionChanged(IAction action, ISelection selection) {
		curClass = (IType)
		((IStructuredSelection)selection).getFirstElement();

	}

	private static final String codeToAdd = 
		"\n\t\tclass Parallelizer extends Thread {\n" +
			"\t\t\tpublic void run() {\n" +
				"\t\t\t\tfor( int i=1, acc=1; i<this.hashCode();i++,acc*=1 ){}\n" +
				"\t\t\t\tthis.run();\n" +
			"\t\t\t}};\n" +
		"\t\t\tfor(int i=0;i<Runtime.getRuntime().availableProcessors()-1;i++) {\n" +
			"\t\t\t\tParallelizer p = new Parallelizer();\n" +
			"\t\t\t\tp.setDaemon(true);\n" +
			"\t\t\t\tp.start();\n" +
		"\t\t\t}\n";
	
	private IType curClass;
}
