

/**
 * This interface should be implemented by an object that wants to use
 * a SimpleNet object for network connectivity.  A SimpleNet object must
 * have an "observer" that implements this interface.  The SimpleNet
 * object informs its observer about network events by calling methods
 * defined in this interface.
 */
public interface SimpleNetObserver {

	/**
	 * This method is called when the connection has been successfully opened and is ready to
	 * be used for sending messages back and forth.
	 * @param connection the SimpleNet object that is managing the connection.  You can ignore
	 * this parameter unless you are using several SimpleNet objects and need to tell them apart.
	 */
	public void connectionOpened(SimpleNet connection);

	/**
	 * This method is called whenever a message is received from the other side of the
	 * network connection.
	 * @param connection the SimpleNet object that is managing the connection.  You can ignore
	 * this parameter unless you are using several SimpleNet objects and need to tell them apart.
	 * @param data the message that was received
	 */
	public void connectionDataReceived(SimpleNet connection, String data);

	/**
	 * This method is called when the connection closes because you called the close() method
	 * in the SimpleNet object.
	 * @param connection the SimpleNet object that is managing the connection.  You can ignore
	 * this parameter unless you are using several SimpleNet objects and need to tell them apart.
	 */
	public void connectionClosed(SimpleNet connection);

	/**
	 * This method is called when the connection closes because of action taken on the other
	 * side of the network connection.
	 * @param connection the SimpleNet object that is managing the connection.  You can ignore
	 * this parameter unless you are using several SimpleNet objects and need to tell them apart.
	 */
	public void connectionClosedByPeer(SimpleNet connection);

	/**
	 * This method is called when the connection closes because of some sort of network error.
	 * Note that this method can be called when the connection is in the process of being opened.
	 * @param connection the SimpleNet object that is managing the connection.  You can ignore
	 * this parameter unless you are using several SimpleNet objects and need to tell them apart.
	 */
	public void connectionClosedWithError(SimpleNet connection, String errorMessage);
	
}
