
import java.awt.*;
import java.awt.event.*;

import javax.swing.*;

public class ChatPanel extends JPanel implements ActionListener {
	
	JTextField inputBox;   // User types messages here.
	JButton sendButton;    // Message is sent when user clicks this button.
	JTextArea transcript;  // All messages are posted here.
	
	public ChatPanel() {
		
		sendButton = new JButton("Send");

		sendButton.addActionListener(this);  // A button-click will cause the actionPerformed() method to be called.
		
		inputBox = new JTextField(40);       // Create an input box sized to hold 40 characters.
		inputBox.setBackground(Color.WHITE);
		inputBox.addActionListener(this);    // Pressing return in the input box will call actionPerformed().

		transcript = new JTextArea();
		transcript.setLineWrap(true);       // Lines will wrap at the right margin.
		transcript.setWrapStyleWord(true);  // Line wrap will not split words.
		transcript.setEditable(false);      // User can't type in the transcript area.
		transcript.setBackground(Color.WHITE);
		JScrollPane scroller = new JScrollPane(transcript);  // Required for adding a scrollbar to the transcript.
	
		setPreferredSize( new Dimension(650,450));  // This is the size that will be used for the panel.
		setBackground(Color.GRAY);                  // This color will show between components in the panel.
		setLayout(new BorderLayout(5,5));           // Use a border layout with 5-pixel gaps between components.
		
		JPanel bottom = new JPanel();      // Create a panel to hold the input box and send button.
		bottom.setBackground(Color.GRAY);
		bottom.add(inputBox);              // Add the input box to the bottom panel.
		bottom.add(sendButton);            // Add the send button to the bottom panel.
		
		add(bottom, BorderLayout.SOUTH);     // Puts the bottom panel at the bottom (SOUTH) of this panel.
		add(scroller, BorderLayout.CENTER);  // Puts the transcript (in its scroller) in the main area of the panel.
		
	} // end constructor

	
	/**
	 * Adds a string to the transcript area, followed by a carriage return.
	 * @param s the string to be added to the transcript.
	 */
	synchronized private void postMessage(String s) {
		transcript.append(s + "\n");
		   // The following line is a nasty kludge that was the only way I could find to force
		   // the transcript to scroll so that the text that was just added is visible in
		   // the window.  Without this, text can be added below the bottom of the visible area
		   // of the transcript.
		transcript.setCaretPosition(transcript.getDocument().getLength());
	}

	
	/**
	 * This method is called when an action event occurs in a component, assuming that
	 * this ChatPanel has been "registered" as an ActionListener with that component.
	 */
	public void actionPerformed(ActionEvent e) {

		Object source = e.getSource();  // This is the object that generated the event.
		
		if (source == sendButton || source == inputBox) {
			String str = inputBox.getText();
			postMessage("SEND:  " + str);
			inputBox.selectAll();
			inputBox.requestFocus();
		}

	} // end actionPerformed()

	
}

