import java.awt.Color;

public class MyLinkedList<Anything>
{  
    // the Node class is a private inner class used (only) by the LinkedList class
    private class Node
    {
        private Anything data;
        private Node next;
        
        public Node(Anything a, Node n)
        {
            data = a;
            next = n;
        }
    }
    
    private Node first;
    private int length;  // to enable an O(1) size method
    
    
    public MyLinkedList()
    {
        first = null;
        length = 0;  // added after considering the size() method
    }
    
    public boolean isEmpty()
    {
       return (first == null);
    }
    
    public void addFirst(Anything d)
    {
        /* These two lines can be reduced to the single line which follows
         *   Node temp = first;
         *   first = new Node(d,temp);
         */        
        first = new Node(d,first);
        length++;
    }
    
    public int size()
    {   /*  This O(n) loop can be replaced by the O(1) return once we have the length field
        int count = 0;
        for (Node curr = first; curr != null; curr = curr.next)
            count++;
        return count;
        */
        return length;
    }
    
    public void clear()
    {
        first = null;
        length = 0;
    }
    
    public boolean contains(Anything value)
    {
        for (Node curr = first; curr != null; curr = curr.next)
        {
            if (value.equals(curr.data))  // this implies that the data must have an overridden .equals() method!
            {
                return true;
            }
        }
        return false;
    }
    
    public Anything get(int index)
    {
        if (index < 0 || index >= length)
        {
            System.out.println("Index of " + index + " out of range");
            return null;
        }
        
        Node curr = first;
        for (int i = 0; i < index; i++)
            curr = curr.next;
        return curr.data;
    }
    
    public boolean remove(Anything m)
    {
        if (isEmpty())
            return false;
        
        if (m.equals(first.data))
        {
            first = first.next;
            length--;
            return true;
        }
        
        Node curr = first;
        while (curr.next != null)
        {
            if (m.equals(curr.next.data))  // this implies that the data must have an overridden equals() method!
            {
                curr.next = curr.next.next;
                length--;
                return true;
            }
            curr = curr.next;
        }
        return false;
    }
    
    public String toString()
    {
        StringBuilder result = new StringBuilder();  //String result = "";
        for (Node curr = first; curr != null; curr = curr.next)
            result.append(curr.data + "->");  //result = result + curr.data + "->";
        result.append("[null]");
        return result.toString();   //return result + "[null]";
    }
    
    
    public static void main(String[] args)
    {
        //ArrayList<String> a = new ArrayList<String>();
        MyLinkedList<String> l = new MyLinkedList<String>();// note, that all the data will be Strings
        System.out.println(l);
        l.addFirst("Mark");
        System.out.println(l);
        l.addFirst("Fred");
        System.out.println(l);
        l.addFirst("5");
        System.out.println(l);
        System.out.println("size of l = " + l.size());
        System.out.println(l.contains("Fred"));
        System.out.println(l.contains("Alanood"));
        System.out.println(l.get(2));
        System.out.println(l.get(3));
        System.out.println(l.remove("Fred"));
        System.out.println(l);
        l.remove("5");
        System.out.println(l);
        l.remove("something else");
        System.out.println(l);
        l.remove("Mark");
        System.out.println(l);
        
        MyLinkedList<Color> l2 = new MyLinkedList<Color>();// I can have other data, like Color (or Person)
        l2.addFirst(Color.YELLOW);
        System.out.println(l2);
        l2.addFirst(Color.WHITE);
        System.out.println(l2);
        
        MyLinkedList<Person> l3 = new MyLinkedList<Person>();
        l3.addFirst(new Person("Mark","Stehlik","mjs",44548651,"Faculty"));
        System.out.println(l3);
        l3.addFirst(new Person("Fred","Student","fss",44549000,"Student"));
        System.out.println(l3);
        Person p2 = new Person("Mark","Stehlik","mjs",44548651,"Faculty");
        l3.remove(p2);
        System.out.println(l3);
    }
}