import java.util.Scanner;

public class Contacts
{
    private Person[] contacts;  // the array of contacts
    private int numPeople;  // the number actually used
    
    // this constructor takes a filename (a String), opens the file, and
    // assuming it is openable, loads the contacts array with data from the file
    public Contacts(String fileName)
    {
        numPeople = 0;
        contacts = new Person[50];  // 50 is arbitrary
        
        Scanner cooler = getFileScanner(fileName);
        while (cooler.hasNext())
        {
            // create a new Person with data from the file (nationality is "")
            Person p = new Person(cooler.next(),cooler.next(),"",cooler.nextInt());
            contacts[numPeople] = p;
            numPeople++;
        }
        cooler.close();
    }
    
    public String toString()
    {
        String result = "I have " + numPeople + " people in my contacts\n";
        for (int i = 0; i < numPeople; i++)
        {
            result += contacts[i] + "\n";
        }
        return result;
    }
    
    public static Scanner getFileScanner(String filename)
    { 
        Scanner scanner = null; 
        try { scanner = new Scanner(new java.io.File(filename)); } 
        catch (Exception e)  
        { 
            System.out.println("File not found:" + filename); 
            return null; 
        } 
        return scanner;
    }
    
    public static void main(String[] args)
    {
        Contacts myList = new Contacts("names.txt");
        System.out.println(myList);
        // since contacts is private, I can only do this because main is inside the class
        myList.contacts[5].birthday();
        Person p = myList.contacts[8];  // p is an alias for contacts[8]
        System.out.println("****" + p);
        p.birthday();  // changes *both* p and contacts[8] since it is a shared reference
        System.out.println(myList);
    }
}