import java.util.Scanner;

public class Pi
{
    public static void main(String[] args)
    {
        //randomTest();
        //int total = 10000000;
        Scanner fred = new Scanner(System.in);
        System.out.print("Enter total number of pearls: ");
        int total = fred.nextInt();
        System.out.println("After " + total + " trials, Pi = " + calcPi(total));
    }
    
    public static double calcPi(int total)
    {
        int count = 0;
        for (int i = 0; i < total; i++)
        {
            double x = randomDoubleInRange(-1,1);
            double y = randomDoubleInRange(-1,1);
            if (isInCircle(x,y,1))
                count++;
        }
        return 4.0 * count/total;  // multiplying by 4.0 ensures division is real, not int
    }
    
    public static double randomDoubleInRange(int low, int hi)
    {
        int range = hi - low;  // determine the range
        return (Math.random() * range + low);  // translate it appropriately
    }
    
    public static boolean isInCircle(double x, double y, double radius)
    {
        // a point is in the circle if (x^2 + y^2) <= radius^2
        return x*x + y*y <= radius*radius;
    }
    
    // to provide a feel for scaling and translation
    public static void randomTest()
    {
        for (int i = 0; i < 10; i++)
            System.out.println((int)(Math.random() * 10));  // random ints from 0 to 9
        System.out.println();
        for (int i = 0; i < 10; i++)
            System.out.println((int)(Math.random() * 6) + 1);  // random ints from 1 to 6
        System.out.println();
    }
}
    