import java.util.*;
/**
 * Implements a student (name, andrewid)
 */
public class Student implements Comparable<Student>
{
    private String firstName;
    private String lastName;
    private String andrewID;
    
    public Student(String first, String last, String id)
    {
        firstName = first;
        lastName = last;
        andrewID = id;
    }
    
    public String getFirstName()
    {
        return firstName;
    }
    
    public String getLastName()
    {
        return lastName;
    }
    
    public String getID()
    {
        return andrewID;
    }
    
    public String getFullName()
    {
        return firstName + " " + lastName;
    }
    
    public String toString()
    {
        return firstName + " " + lastName + " " + andrewID;
    }
    
    // check last names; if equal check first names; if last and first equal check andrewID
    public int compareTo(Student s)
    {
        if (!lastName.equals(s.lastName))
            return lastName.compareTo(s.lastName);
        else if (!firstName.equals(s.firstName))
            return firstName.compareTo(s.firstName);
        return andrewID.compareTo(s.andrewID);
    }
    
    public boolean equals(Object o)
    {
        if (o == null)
            return false;
        
        // the easiest way to ensure consistency with compareTo!
        return compareTo((Student)o) == 0;
    }
    
    
    public int hashCode()
    {
        //return 9;
        
        /* returning 9 is the world's worst implementation of hashCode,
         * but at least it has the redeeming feature that equal objects
         * will have the same hashCode.
         * Of course, EVERY Student object will have the same hashCode!
         *
         * We need something that returns the same hashCode if first
         * and last names and andrewID are the same (and, hopefully,
         * different ones if they are different), so...
         */
        return (lastName + firstName + andrewID).hashCode();
    }
    
    public static void main(String[] args)
    {
        Student s1 = new Student("Noor","Qaedi","njq");
        Student s2 = new Student("Noor","Qaedi","njq");
        Student s3 = new Student("Fred","Qaedi","fq");
        System.out.println(s1);
        System.out.println(s1.equals(s2));
        System.out.println("Noor".hashCode());
        System.out.println("noor".hashCode());
        System.out.println(s1.hashCode());
        System.out.println(s2.hashCode());
        System.out.println(s3.hashCode());
        Set<Student> s = new HashSet<Student>();
        s.add(s1);
        s.add(s2);
        s.add(s3);
        System.out.println(s);
    }
}
