public class BST<AnyType extends Comparable<AnyType>>
{
    // the TreeNode class is a private inner class used (only) by the BST class
    private class TreeNode
    {
        private AnyType data;
        private TreeNode left, right;
        
        private TreeNode(AnyType data, TreeNode left, TreeNode right)
        {
            this.data = data;
            this.left = left;
            this.right = right;
        }
    }
    
    private TreeNode root;
    
    public BST()
    {
        root = null;
    }
    
    public boolean isEmpty()
    {
        return root == null;
    }
    
    // a better, more elegant, add method
    public void add(AnyType value)
    {
        // important idiom:  x = changed(x);
        root = addHelper(root,value);
    }
    
    private TreeNode addHelper(TreeNode rt, AnyType value)
    {
        if (rt == null)  // the "real" base case
            return new TreeNode(value,null,null);
        
        // and the appropriate general cases
        if (value.compareTo(rt.data) < 0)
            rt.left = addHelper(rt.left,value);
        else if (value.compareTo(rt.data) > 0)
            rt.right = addHelper(rt.right,value);
        else
            System.out.println("ERROR: " + value + " is already in the tree");
        
        return rt;  // have to return the "unchanged" ones!
        // and, indeed, you are (re-)assigning values all the way back up the call stack!
    }
    
    
    public void initial_add(AnyType value)
    {
        if (isEmpty())
            root = new TreeNode(value,null,null);
        else
            initial_addHelper(root,value);
    }
    
    private void initial_addHelper(TreeNode rt, AnyType value)
    {
        if (value.compareTo(rt.data) < 0)
        {
            if (rt.left == null)
            {
                rt.left = new TreeNode(value,null,null);
            }
            else
                initial_addHelper(rt.left,value);
        }
        else if (value.compareTo(rt.data) > 0)
        {
            if (rt.right == null)
            {
                rt.right = new TreeNode(value,null,null);
            }
            else
                initial_addHelper(rt.right,value);
        }
        else
            System.out.println("Value " + value + " already in tree");
    }
    
    public void inOrder()
    {
        inOrder(root);
        System.out.println();
    }
    
    private void inOrder(TreeNode rt)  // overloading the inOrder method!
    {
        if (rt != null)
        {
            inOrder(rt.left);
            System.out.print(rt.data + " ");
            inOrder(rt.right);
        }
        // to reinforce the idea that we're calling through the null pointers
        //System.out.println("X");  // how many X's get printed??
    }
    
    public void preOrder()
    {
        preOrder(root);
        System.out.println();
    }
    
    private void preOrder(TreeNode rt)
    {
        if (rt != null)
        {
            System.out.print(rt.data + " ");
            preOrder(rt.left);
            preOrder(rt.right);
        }
    }
    
    public void postOrder()
    {
        postOrder(root);
        System.out.println();
    }
    
    private void postOrder(TreeNode rt)
    {
        if (rt != null)
        {
            postOrder(rt.left);
            postOrder(rt.right);
            System.out.print(rt.data + " ");
        }
    }
    
    public int size()
    {
        return size(root);
    }
    
    private int size(TreeNode rt)
    {
        if (rt == null)
            return 0;
        return 1 + size(rt.left) + size(rt.right);
    }
    
    public boolean contains(AnyType value)
    {
        TreeNode curr = root;
        while (curr != null)
        {
            if (value.compareTo(curr.data) == 0)
                return true;
            if (value.compareTo(curr.data) < 0)
                curr = curr.left;
            else
                curr = curr.right;
        }
        return false;
    }
    
    // prints tree top to bottom, right to left in a 90-degree rotated level view
    public String toString()
    {
        StringBuilder result = new StringBuilder();
        return toStringHelper(result,root,-1).toString();
    }
    
    private StringBuilder toStringHelper(StringBuilder r,
                                         TreeNode rt, int level)
    {
        if (rt != null)
        {
            level++;
            r = toStringHelper(r,rt.right,level);
            for (int i = 0; i < level; i++)
                r.append("\t");
            r.append(rt.data + "\n");
            r = toStringHelper(r,rt.left,level);
        }
        return r;
    }
    

    // so how do we double the value of an int?
    public static int times2(int i)
    {
        if (i % 2 == 1)
            return i * 2;  // we have to return the doubled value!
        return i;  // and if we don't change the value, we still have to return it!
    }
    
    public static void main(String[] args)
    {
        // code from lecture 21
        int x = 5;
        x = times2(x);  // important idiom:  x = changed(x);
        System.out.println(x);
        
        // code from lecture 20
        BST<Integer> khamsa = new BST<Integer>();
        khamsa.add(7);
        khamsa.add(5);
        khamsa.add(4);
        khamsa.add(10);
        khamsa.add(6);
        khamsa.add(8);
        khamsa.add(6);
        khamsa.inOrder();
        khamsa.preOrder();
        System.out.println(khamsa.size());
        System.out.println(khamsa.contains(6));
        System.out.println(khamsa.contains(112));
        System.out.println(khamsa.contains(7));
        System.out.println(khamsa.contains(10));
        System.out.println(khamsa);
    }
    
}

