import java.util.*;

public class SortDemo
{
    private void swap(int[] a, int i, int j)
    {
        int temp = a[i];
        a[i] = a[j];
        a[j] = temp;
    }
    
    public void selectionsort(int[] a)
    {
        int n = a.length;
        for (int i = 0; i < n-1; i++)
        {
            int indexOfSmallest = i;
            for (int j = i+1; j < n; j++)
                if (a[j] < a[indexOfSmallest])
                    indexOfSmallest = j;
            swap(a, i, indexOfSmallest);
        }
    }
    
    public void insertionsort(int[] a)
    {
        int n = a.length;
        for (int i = 0; i < n; i++)
        {
            int index = i;
            int valueToInsert = a[index];
            while (index > 0 && valueToInsert < a[index-1])
            {
                a[index] = a[index-1];
                index--;
            }
            a[index] = valueToInsert;
        }
    }
    
    public void mergesort(int[] a)
    {
        if (a.length > 1)
        {
            int mid = a.length / 2;  // first index of right half
            int[] left = new int[mid];
            for (int i = 0; i < left.length; i++)  // create left subarry
                left[i] = a[i];
            int[] right = new int[a.length-mid];
            for (int i = 0; i < right.length; i++)  // create right subarray
                right[i] = a[mid+i];
            mergesort(left);  // recursively sort the left half
            mergesort(right); // recursively sort the right half
            merge(left, right, a);  // merge the left and right parts back into a whole
        }   
    }
    
    public void merge(int[] left, int[] right, int[] arr)
    {
        int leftIndex = 0;
        int rightIndex = 0;
        for (int i = 0; i < arr.length; i++)
        {
            if (rightIndex == right.length ||
                (leftIndex < left.length && left[leftIndex] < right[rightIndex]))
            {
                arr[i] = left[leftIndex];
                leftIndex++;
            }
            else
            {
                arr[i] = right[rightIndex];
                rightIndex++;
            }
        }
    }
    
    public void quicksort(int[] a)
    {
        quicksort(a, 0, a.length-1);
    }
    
    public void quicksort(int[] a, int low, int high)
    {
        if (low < high)
        {
            int pivotIndex = partition(a, low, high);  // value at pivotIndex is in correct spot
            quicksort(a, low, pivotIndex-1);  // recursively sort the items to the left (< pivot)
            quicksort(a, pivotIndex+1, high);  // recursively sort the items to the right (> pivot)
        }
    }
    
    public int partition(int[] arr, int low, int high)
    {
        int pivot = arr[low];  // select the first element as the pivot value (there are better ways to do so)
        int boundaryIndex = low + 1;  // the index of first open place (in the right partition) to put a value > pivot
        for (int i = low+1; i <= high; i++)
        {
            if (arr[i] < pivot)
            {
                if (i != boundaryIndex)
                    swap(arr, i, boundaryIndex);
                boundaryIndex++;
            }
        }
        /* 
         * boundaryIndex is the first (left-most) index of values >= pivot,
         * so we'll swap the pivot (at index low) with the value at
         * boundaryIndex-1 (it MUST be < pivot), which means all the elements
         * then to the left of the pivot must be < the pivot value, so pivot is placed
         */
        swap(arr, low, boundaryIndex-1);
        return boundaryIndex-1;
    }
    
    public static void main(String[] args)
    {
        SortDemo demo = new SortDemo();
        MyTimer t = new MyTimer();
        
        // Get n from user
        Scanner scanner = new Scanner(System.in);
        System.out.print("Enter n (try 20 thousand): ");
        int n = scanner.nextInt();
        
        String sortType;
        Random random = new Random();
        do
        {
            // Create unsorted array of size n
            int[] arr = new int[n];
            for (int i = 0; i < n; i++)
                arr[i] = random.nextInt();
            
            // make a copy and sort it
            int[] sortedCopy = new int[arr.length];
            for (int i = 0; i < arr.length; i++)
                sortedCopy[i] = arr[i];
            Arrays.sort(sortedCopy);
            
            // get sorting method (first run on a method is always strangely slow)
            System.out.print("Enter sort [select, insert, merge, quick, built-in, quit]: ");
            sortType = scanner.next();
            while (!(sortType.equals("select") || sortType.equals("insert") || sortType.equals("merge")
                       || sortType.equals("quick") || sortType.equals("built-in") || sortType.equals("quit")))
            {
                System.out.println("**Error** - unknown sort type!: " + sortType);
                System.out.print("Enter one of [select, insert, merge, quick, built-in, quit]: ");
                sortType = scanner.next();
            }
            // Time sorting the array until user quits
            t.startTiming();
            if (sortType.equals("select"))
                demo.selectionsort(arr);
            else if (sortType.equals("insert"))
                demo.insertionsort(arr);
            else if (sortType.equals("merge"))
                demo.mergesort(arr);
            else if (sortType.equals("quick"))
                demo.quicksort(arr);
            else if (sortType.equals("built-in"))
                Arrays.sort(arr);
            else if (sortType.equals("quit"))
                break;
            t.stopTiming();
            
            // make sure the method actually sorted the array :-)
            assert Arrays.equals(sortedCopy,arr) : "Array is not sorted correctly!";
            
            // print timing results (NOTE: first timing of a new sort seems "contaminated"
            System.out.println("Elapsed time: " + t.elapsedTime() + " ms");  
        }
        while (!sortType.equals("quit"));
    }
}