/**
 * Implements a class roster
 */
import java.util.*;

public class Roster implements Iterable<Student>  // allows a for..each loop to be used
{
    private String courseNumber;
    private ArrayList<Student> students;
    
    public Roster(String number)
    {
        courseNumber = number;
        students = new ArrayList<Student>();
    }
    
    public int length()
    {
        return students.size();
    }
    
    public void addStudent(Student newStudent)
    {
        students.add(newStudent);
    }
    
    public String toString()
    {
        StringBuilder result = new StringBuilder("Class roster - " + courseNumber + "\n");
        for (int i = 0; i < students.size(); i++)
            result.append("  " + students.get(i).toString() + "\n");
        return result.toString();
    }
    
    // To implement Iterable<Student>, you have to create and return an
    // Iterator<Student> object.  BUT, since you CANNOT instantiate an
    // object that's an interface (because an interface has NO method
    // implementations!), you have to create and return an object of a
    // (private) class that implements Iterator<Student>!
    public Iterator<Student> iterator()
    {
        //return new Iterator<Student>();  // right idea, but illegal!
        return new Monkey();
    }
    
    // And here's the class (Monkey, a private inner class like Node)
    // that implements Iterator<Student> for the Roster class
    private class Monkey implements Iterator<Student>
    {
        private int whereAmI = 0;  // keeps track of the iterator's position
        
        public boolean hasNext()
        {
            /*
            if (whereAmI == length())
                return false;
            else
                return true;
            */
            
            // the following return is equivalent to the previous code
            return whereAmI != length();
        }
        
        public Student next()
        {
            /*
            Student temp = students.get(whereAmI);
            whereAmI++;
            return temp;
            */
            
            // the following return is equivalent to the previous code
            return students.get(whereAmI++);  // now we're talkin'!
        }

        // This is an OPTIONAL method (check the API), but still must have
        // some implementation (since it is spec'd in the Iterator interface).
        // We could just provide an empty implementation, but that would be
        // false advertising and potentially incorrect.  So the API says that
        // we should acknowledge that we are explicitly not implementing this
        // operation by throwing a new UnsupportedOperationException().
        // This will alert someone who calls it that it's not ready for prime time!
        public void remove()
        {
            //this is hard
            throw new UnsupportedOperationException();
        }
    }
    
    public static void main(String[] args)
    {
        Roster myCourse = new Roster("15-121w");
        myCourse.addStudent(new Student("Salman","Abuhaliqa","sabuhali"));
        myCourse.addStudent(new Student("Ameera","Tag","atag"));

        // this only works inside Roster because students is a private field!
        for (int i = 0; i < myCourse.length(); i++)
            System.out.println(myCourse.students.get(i).getID());
    }
}
