public class RPS
{
    private final int WINS = 3;
    
    public void play(RPSPlayer p1, RPSPlayer p2)
    {
        int wins1 = 0;
        int wins2 = 0;
        while (!(wins1 == WINS || wins2 == WINS))
        {
            String s1 = p1.move();
            String s2 = p2.move();
            System.out.print("player 1 says " + s1 + "; player 2 says " + s2);
            if (winner(s1, s2))
            {
                wins1++;
                System.out.println("; player 1 wins");
            }   
            else if (winner(s2, s1))
            {
                wins2++;
                System.out.println("; player 2 wins");
            }
            else
                System.out.println("; tie, go again!");
        }
        System.out.println("Player " + ((wins1 == WINS)?"1":"2") + " wins!");
    }
    
    private boolean winner(String s1, String s2)
    {
        return (s1.equals("rock") && s2.equals("scissors") ||
                s1.equals("scissors") && s2.equals("paper") ||
                s1.equals("paper") && s2.equals("rock"));
    }
    
    public static void main(String[] args)
    {
        RPS game = new RPS();
        //RockPlayer player1 = new RockPlayer();
        RPSPlayer player1 = new RandomPlayer();//RockPlayer();
        RPSPlayer player2 = new HumanPlayer();
        game.play(player1, player2);
    }
}