import java.awt.Color;

public class MyLinkedList<Anything>
{  
    // the Node class is a private inner class used (only) by the LinkedList class
    private class Node
    {
        private Anything data;
        private Node next;
        
        public Node(Anything a, Node n)
        {
            data = a;
            next = n;
        }
    }
    
    private Node first;
    private int length;  // to enable an O(1) size method
    
    
    public MyLinkedList()
    {
        first = null;
        length = 0;  // added after considering the size() method
    }
    
    public boolean isEmpty()
    {
       return (first == null);
    }
    
    public void addFirst(Anything d)
    {
        /* These two lines can be reduced to the single line which follows
         *   Node temp = first;
         *   first = new Node(d,temp);
         */        
        first = new Node(d,first);
        length++;
    }
    
    public int size()
    {   /*  This O(n) loop can be replaced by the O(1) return once we have the length field
        int count = 0;
        for (Node curr = first; curr != null; curr = curr.next)
            count++;
        return count;
        */
        return length;
    }
    
    public void clear()
    {
        first = null;
        length = 0;
    }
    
    public String toString()
    {
        String result = "";
        for (Node curr = first; curr != null; curr = curr.next)
            result += curr.data + "->";
        return result + "[null]";
    }
    
    
    public static void main(String[] args)
    {
        //ArrayList<String> a = new ArrayList<String>();
        MyLinkedList<String> l = new MyLinkedList<String>();// note, that all the data will be Strings
        System.out.println(l);
        l.addFirst("Mark");
        System.out.println(l);
        l.addFirst("Fred");
        System.out.println(l);
        l.addFirst("5");
        System.out.println(l);
        MyLinkedList<Color> l2 = new MyLinkedList<Color>();// I can have other data, like Color (or Person)
        l2.addFirst(Color.YELLOW);
        System.out.println(l2);
        l2.addFirst(Color.WHITE);
        System.out.println(l2);
        System.out.println("size of l = " + l.size());
    }
}