public class BST<AnyType extends Comparable<AnyType>>
{
    private TreeNode root;
    
    public BST()
    {
        root = null;
    }
    
    public boolean isEmpty()
    {
        return root == null;
    }
    
    public void add(AnyType value)
    {
        if (isEmpty())
            root = new TreeNode(value,null,null);
        else
            addHelper(root,value);
    }
    
    private void addHelper(TreeNode rt, AnyType value)
    {
        if (value.compareTo(rt.data) < 0)
        {
            if (rt.left == null)
            {
                rt.left = new TreeNode(value,null,null);
            }
            else
                addHelper(rt.left,value);
        }
        else if (value.compareTo(rt.data) > 0)
        {
            if (rt.right == null)
            {
                rt.right = new TreeNode(value,null,null);
            }
            else
                addHelper(rt.right,value);
        }
        else
            System.out.println("Value " + value + " already in tree");
    }
    
    public void inOrder()
    {
        inOrder(root);
        System.out.println();
    }
    
    private void inOrder(TreeNode rt)
    {
        if (rt != null)
        {
            inOrder(rt.left);
            System.out.print(rt.data + " ");
            inOrder(rt.right);
        }
        // to reinforce the idea that we're calling through the null pointers
        //System.out.println("X");  // how many X's get printed??
    }
    
    public void preOrder()
    {
        preOrder(root);
        System.out.println();
    }
    
    private void preOrder(TreeNode rt)
    {
        if (rt != null)
        {
            System.out.print(rt.data + " ");
            preOrder(rt.left);
            preOrder(rt.right);
        }
    }
    
    public int size()
    {
        return size(root);
    }
    
    private int size(TreeNode rt)
    {
        if (rt == null)
            return 0;
        return 1 + size(rt.left) + size(rt.right);
    }
    
    public boolean contains(AnyType value)
    {
        TreeNode curr = root;
        while (curr != null)
        {
            if (value.compareTo(curr.data) == 0)
                return true;
            if (value.compareTo(curr.data) < 0)
                curr = curr.left;
            else
                curr = curr.right;
        }
        return false;
    }
    
    // prints tree top to bottom, right to left in a 90-degree rotated level view
    public String toString()
    {
        StringBuilder result = new StringBuilder();
        return toStringHelper(result,root,-1).toString();
    }
    
    private StringBuilder toStringHelper(StringBuilder r,
                                         TreeNode rt, int level)
    {
        if (rt != null)
        {
            level++;
            r = toStringHelper(r,rt.right,level);
            for (int i = 0; i < level; i++)
                r.append("\t");
            r.append(rt.data + "\n");
            r = toStringHelper(r,rt.left,level);
        }
        return r;
    }
    
    
    /**
     * the node class used by the Tree class
     * a private inner class
     */
    private class TreeNode
    {
        private AnyType data;
        private TreeNode left, right;
        
        private TreeNode(AnyType data, TreeNode left, TreeNode right)
        {
            this.data = data;
            this.left = left;
            this.right = right;
        }
    }
    
    
    public static void main(String[] args)
    {
        BST<Integer> hamsa = new BST<Integer>();
        hamsa.add(7);
        hamsa.add(5);
        hamsa.add(4);
        hamsa.add(10);
        hamsa.add(6);
        hamsa.add(8);
        hamsa.add(6);
        hamsa.inOrder();
        hamsa.preOrder();
        System.out.println(hamsa.size());
        System.out.println(hamsa.contains(6));
        System.out.println(hamsa.contains(112));
        System.out.println(hamsa.contains(7));
        System.out.println(hamsa.contains(10));
        System.out.println(hamsa);
    }
    
}

