import java.util.*;

/**
 * A generic linked list class that you will write so that it implements
 * the SimpleList<AnyType> and SimpleQueue<AnyType> interfaces.
 * 
 * NAME: 
 * Hours worked: 
 */
public class MyList<AnyType> implements SimpleList<AnyType>, SimpleQueue<AnyType>
{
    Node first;
    Node last;
    
    /**
     * Determine whether the list is empty.
     * @return true if the list is empty, false otherwise
     */
    public boolean isEmpty()
    {
        return false;
    }
    
    /**
     * Inserts a value at the end of the list.
     * @param value the element to be inserted into the list
     * @return true if the value was added, false otherwise
     */
    public boolean add(AnyType value)
    {
        
        return false;
    }
    
    /**
     * Removes the first element of the list that is equal to value
     * @param value the object to remove
     * @return true if the value was removed, false otherwise
     */
    public boolean remove(AnyType value)
    {
        return false;
    }
    
    /**
     * Inserts a value at the end of the queue
     * @param value the element to be inserted into the queue
     */
    public void enqueue(AnyType value)
    {
        return;
    }
    
    /**
     * Retrieves and removes the first element of the queue
     * @return the object at the front of the queue, or null if the queue is empty
     */
    public AnyType dequeue()
    {
        return null;
    }
    
    /**
     * Retrieves, but does not rempve, the first element of the queue
     * @return the object at the front of the queue, or null if the queue is empty
     */
    public AnyType peek()
    {
        return null;
    }
    
    /**
     * Returns an Iterator object that iterates over the elements in this list
     * in proper sequence.  MUST be implemented since MyList implements both the
     * SimpleList and SimpleQueue interfaces, both of which extend Iterable
     * @return an iterator over the elements in this list
     */
    public Iterator<AnyType> iterator()
    {
        return null;
    }
    
    /**
     * Returns a string representation of this linked list
     * @return a string representation of this list
     */
    public String toString()
    {
        // use StringBuilder for these "result building" strings
        // to avoid creating O(n) Strings in creating the result
        // corresponding String code is commented to the right
        StringBuilder s = new StringBuilder("[");  //String s = "[";
        for(Node curr = first; curr != null; curr = curr.next)
        {
            s.append(curr.data);  //s += curr.data;"
            if (curr.next != null)
                s.append(" --> ");
        }
        s.append("]");  //s += "]";
        return s.toString();  //return s;
    }
    
    // private inner class to implement iterator over the list
    private class MyIterator implements Iterator<AnyType>
    {
        private Node index = null;
        
        // this should run in O(1) time
        public boolean hasNext()
        {
            return false;
        }
        
        // this, also, should run in O(1) time
        public AnyType next()
        {
            return null; 
        }
        
        public void remove()
        {
            // We have to provide an implementation, so we will
            // defer for now and just throw this exception;
            // Probably better to use iterators just to iterate anyway!
            throw new UnsupportedOperationException();
        }
    }
    
    
    /**
     * private inner class to provide the Nodes of the Linked List
     */
    private class Node
    {
        private AnyType data;
        private Node next;
        
        private Node(AnyType data, Node next)
        {
            this.data = data;
            this.next = next;
        }
    }
    
    
    //a main for testing/debugging
    public static void main(String[] args)
    {
        MyList<String> l = new MyList<String>();
        System.out.println(l.isEmpty());
    }
}
