//Full Name: 
//Andrew ID: 
//Approximate Number Of Hours Spent On Assignment: 

public class MyLinkedList<Anything>
{  
    // the Node class is a private inner class used (only) by the LinkedList class
    private class Node
    {
        private Anything data;
        private Node next;
        
        public Node(Anything a, Node n)
        {
            data = a;
            next = n;
        }
    }
    
    private Node first;
    private int length;  // to enable an O(1) size method
    
    
    public MyLinkedList()
    {
        first = null;
        length = 0;  // added after considering the size() method
    }
    
    public boolean isEmpty()
    {
        return (first == null);
    }
    
    public void addFirst(Anything d)
    {
        /* These two lines can be reduced to the single line which follows
         *   Node temp = first;
         *   first = new Node(d,temp);
         */        
        first = new Node(d,first);
        length++;
    }
    
    public int size()
    {   /*  This O(n) loop can be replaced by the O(1) return once we have the length field
     int count = 0;
     for (Node curr = first; curr != null; curr = curr.next)
     count++;
     return count;
     */
        return length;
    }
    
    public void clear()
    {
        first = null;
        length = 0;
    }
    
    public boolean contains(Anything value)
    {
        for (Node curr = first; curr != null; curr = curr.next)
        {
            if (value.equals(curr.data))  // this implies that the data must have an overridden .equals() method!
            {
                return true;
            }
        }
        return false;
    }
    
    public Anything get(int index)
    {
        if (index < 0 || index >= length)
        {
            System.out.println("Index of " + index + " out of range");
            return null;
        }
        
        Node curr = first;
        for (int i = 0; i < index; i++)
            curr = curr.next;
        return curr.data;
    }
    
    public boolean remove(Anything m)
    {
        if (isEmpty())
            return false;
        
        if (m.equals(first.data))
        {
            first = first.next;
            length--;
            return true;
        }
        
        Node curr = first;
        while (curr.next != null)
        {
            if (m.equals(curr.next.data))  // this implies that the data must have an overridden equals() method!
            {
                curr.next = curr.next.next;
                length--;
                return true;
            }
            curr = curr.next;
        }
        return false;
    }
    
    public String toString()
    {
        StringBuilder result = new StringBuilder();  //String result = "";
        for (Node curr = first; curr != null; curr = curr.next)
            result.append(curr.data + "->");  //result = result + curr.data + "->";
        result.append("[null]");
        return result.toString();   //return result + "[null]";
    }
    
    // ------------------------  HW4 methods start here ------------------------
    
    public Anything getFirst()
    {
        return null;
    }
    
    public Anything getLast()
    {
        return null;
    }
    
    public void add(Anything value)
    {
        return;
    }
    
    public void addAfter(int index, Anything value)
    {
        return;
    }
    
    public Anything set(int index, Anything newValue)
    {
        return null;
    }
    
    public int lastIndex(Anything value)
    {
        return 42;
    }
    
    public MyLinkedList<Anything> clone()
    {
        return null;
    }
    
    public void removeAll(Anything value)
    {
        return;
    }
    
    public boolean equals(Object o)
    {
        return false;
    }
    
    public MyLinkedList<Anything> split()
    {
        return null;
    }
    
    
    public static void main(String[] args)
    {
        // here is where you can create some lists (use lists of Strings
        // to test) and thoroughly test each of your new methods
    }
}