% Plot a binomial posterior using a beta prior

% where to put and what to call the figures
basename = 'binomial_posterior_with_prior_figs/binomial_posterior_with_prior';
printflag = 1;

true_theta = 0.4;
ntrials = 10000;
%plot_trials = [0:4,5:5:20,25:25:100, 200:100:1000, 2000:1000:10000];
plot_trials = [0:5, 50, 500, 5000];

% beta prior
beta_a=20; beta_b=20;

% generate trials to do a real example

rand('state',0); % use fixed seed so we can redo the same plots

trial = zeros(1,ntrials);
for n=1:ntrials
    if rand <= true_theta
        trial(n) = 1;
    end
end

opts = struct('color','rgb','FontMode','fixed','FontSize',18, ...
    'width',7, 'height', 4);

theta = 0:0.002:1;
for i=1:length(plot_trials)
    n=plot_trials(i);
    y = sum(trial(1:n));
    x = binopdf(y, n, theta) .* betapdf(theta, beta_a, beta_b);
    plot(theta, x, 'black', 'LineWidth', 2);
    set(gca,'XLim',[0,1], 'YTickLabel', []);
    box off; 
    xlabel('\theta');
    ylabel(sprintf('p(\\theta | y=%d, n=%d)', y, n));

    fname = sprintf('%s_n=%d.eps', basename, n);

    if printflag == 1
        fprintf('Printing to figure to %s\n', fname);
        exportfig(gcf, fname, opts);
        fprintf('Converting to pdf and removing eps file.\n');
        system(sprintf('pstopdf %s', fname));
        system(sprintf('rm %s', fname));
    end
%    pause
end
