% Plot a binomial posterior with no axes

fname = 'binomial_posterior_noaxes.eps';
printflag = 1;

opts = struct('color','rgb','FontMode','fixed','FontSize',18, ...
    'width',7, 'height', 4);

theta = 0:0.002:1;
n=50;
y=17;
x = binopdf(y, n, theta);
plot(theta, x, 'black', 'LineWidth', 2);
set(gca,'XLim',[0,1], 'XTickLabel', [], 'YTickLabel', []);
box off;

if printflag == 1
    fprintf('Printing to figure to %s\n', fname);
    exportfig(gcf, fname, opts);
    fprintf('Converting to pdf and removing eps file.\n');
    system(sprintf('pstopdf %s', fname));
    system(sprintf('rm %s', fname));
end
