% Plot a binomial posterior using a beta prior

fname = 'beta_prior.eps';
printflag = 0;

beta_a=3; beta_b=3;

opts = struct('color','rgb','FontMode','fixed','FontSize',18, ...
    'width',7, 'height', 4);

theta = 0:0.002:1;
x = betapdf(theta, beta_a, beta_b);

plot(theta, x, 'black', 'LineWidth', 2);
set(gca,'XLim',[0,1]);
xlabel('\theta');

% Yan's hack to get a single axis in matlab,
set(gcf,'color','white');
set(gca,'ytick',[],'box','off','ycolor','white','color','white');

if printflag == 1
    fprintf('Printing to figure to %s\n', fname);
    exportfig(gcf, fname, opts);
    fprintf('Converting to pdf and removing eps file.\n');
    system(sprintf('pstopdf %s', fname));
    system(sprintf('rm %s', fname));
end