% Plot Laplace's example

fname = 'Laplace_example.eps';
printflag = 1;

opts = struct('color','rgb','FontMode','fixed','FontSize',18, ...
    'width',7, 'height', 4);

n=241945+251527;
y=241945;

u = (y+1)/(n+2);
l = binopdf(y,n,u);

theta = (u - 0.01*u):0.0001:(u+0.01*u);

x = binopdf(y, n, theta);
plot(theta, x, 'black', 'LineWidth', 2); hold on;

plot([u, u], [0,l], '-', 'LineWidth', 2);
plot(u,l, '*'); hold off;

set(gca,'YTickLabel', []);
box off;
xlabel('\theta');
ylabel(sprintf('p(\\theta | y=%d, n=%d)', y, n));

fprintf('E(theta | y=%d, n=%d) = %g\n', y,n,u);

if printflag == 1
    fprintf('Printing to figure to %s\n', fname);
    exportfig(gcf, fname, opts);
    fprintf('Converting to pdf and removing eps file.\n');
    system(sprintf('pstopdf %s', fname));
    system(sprintf('rm %s', fname));
end
