/*
 * Decompiled with CFR 0.152.
 */
public class Vector2D {
    public double x;
    public double y;

    public Vector2D() {
        this.x = 0.0;
        this.y = 0.0;
    }

    public Vector2D(double d, double d2) {
        this.x = d;
        this.y = d2;
    }

    public void normalize() {
        if (this.x != 0.0 || this.y != 0.0) {
            double d = Math.sqrt(this.x * this.x + this.y * this.y);
            this.x /= d;
            this.y /= d;
        }
    }

    public Vector2D normal() {
        Vector2D vector2D = new Vector2D();
        if (this.x != 0.0 || this.y != 0.0) {
            double d = Math.sqrt(this.x * this.x + this.y * this.y);
            vector2D.x = this.x / d;
            vector2D.y = this.y / d;
        }
        return vector2D;
    }

    public void orthogonalize() {
        double d = this.x;
        this.x = this.y;
        this.y = -d;
    }

    public Vector2D orthogonal() {
        Vector2D vector2D = new Vector2D();
        vector2D.x = this.y;
        vector2D.y = -this.x;
        return vector2D;
    }

    public Vector2D add(Vector2D vector2D, Vector2D vector2D2) {
        Vector2D vector2D3 = new Vector2D();
        vector2D3.x = vector2D.x + vector2D2.x;
        vector2D3.y = vector2D.y + vector2D2.y;
        return vector2D3;
    }

    public Vector2D subtract(Vector2D vector2D, Vector2D vector2D2) {
        Vector2D vector2D3 = new Vector2D();
        vector2D3.x = vector2D.x - vector2D2.x;
        vector2D3.y = vector2D.y - vector2D2.y;
        return vector2D3;
    }

    public double magnitude() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public Vector2D scalarproduct(double d) {
        Vector2D vector2D = new Vector2D();
        vector2D.x = d * this.x;
        vector2D.y = d * this.y;
        return vector2D;
    }

    public void scalar(double d) {
        this.x *= d;
        this.y *= d;
    }

    public double angle() {
        double d = Math.sqrt(this.x * this.x + this.y * this.y);
        Vector2D vector2D = new Vector2D(this.x / d, this.y / d);
        double d2 = Math.acos(vector2D.x);
        if (vector2D.y > 0.0) {
            d2 = -d2;
        }
        return d2 * 57.295779513082;
    }

    public void rotate(double d) {
        double d2 = this.x * Math.cos(d) + this.y * Math.sin(d);
        double d3 = this.y * Math.cos(d) - this.x * Math.sin(d);
        this.x = d2;
        this.y = d3;
    }

    public boolean zero() {
        return this.x == 0.0 && this.y == 0.0;
    }
}

