/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.UIManager;

public class GraphDraw
extends JPanel {
    static int graph_w;
    static int graph_h;
    static int button_w;
    static int button_h;
    static int border_w;
    static int border_h;
    final GraphDisplay graphdisplay = new GraphDisplay();
    private static String[] fontStrings;
    static JFrame mainFrame;
    JTextField t_gridx;
    JTextField t_gridy;
    JTextField t_label;
    JTextField t_fontsize;
    JTextField t_dotsize;
    JComboBox c_fontlist;

    private void updateGridSize() {
        String string = this.t_gridx.getText();
        int n = Integer.parseInt(string);
        string = this.t_gridy.getText();
        int n2 = Integer.parseInt(string);
        if (n > 0) {
            this.graphdisplay.gridX = n;
        }
        if (n2 > 0) {
            this.graphdisplay.gridY = n2;
        }
    }

    private void updateFontSettings() {
        String string = (String)this.c_fontlist.getSelectedItem();
        this.graphdisplay.setFont(string);
        string = this.t_fontsize.getText();
        double d = Double.parseDouble(string);
        this.graphdisplay.setFontSize(d);
    }

    private void updateSizeSettings() {
        this.graphdisplay.setDotSize(Double.parseDouble(this.t_dotsize.getText()));
    }

    public Component createComponents() {
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton("Autogen");
        JButton jButton2 = new JButton("Copy");
        JButton jButton3 = new JButton("Cut");
        JButton jButton4 = new JButton("Flip");
        JButton jButton5 = new JButton("New");
        JButton jButton6 = new JButton("Open List");
        JButton jButton7 = new JButton("Open Matrix");
        JButton jButton8 = new JButton("Open PostScript");
        JButton jButton9 = new JButton("Paste");
        JButton jButton10 = new JButton("Save List");
        JButton jButton11 = new JButton("Save Matrix");
        JButton jButton12 = new JButton("Save PostScript");
        final JRadioButton jRadioButton = new JRadioButton("directed");
        final JRadioButton jRadioButton2 = new JRadioButton("undirected");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton2);
        jRadioButton2.setSelected(true);
        JRadioButton jRadioButton3 = new JRadioButton("off");
        JRadioButton jRadioButton4 = new JRadioButton("on");
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(jRadioButton4);
        buttonGroup2.add(jRadioButton3);
        jRadioButton3.setSelected(true);
        JLabel jLabel = new JLabel("graph:");
        JLabel jLabel2 = new JLabel("grid:");
        JLabel jLabel3 = new JLabel("size");
        JLabel jLabel4 = new JLabel("y");
        JLabel jLabel5 = new JLabel("label");
        JLabel jLabel6 = new JLabel("font:");
        JLabel jLabel7 = new JLabel("scale");
        this.c_fontlist = new JComboBox<String>(fontStrings);
        int n = 0;
        while (n < fontStrings.length) {
            if (fontStrings[n].startsWith("Times-Roman")) break;
            ++n;
        }
        if (n < 0 || n >= fontStrings.length) {
            n = 0;
        }
        this.c_fontlist.setSelectedIndex(n);
        this.t_gridx = new JTextField(5);
        this.t_gridy = new JTextField(5);
        this.t_label = new JTextField(32);
        this.t_fontsize = new JTextField(5);
        this.t_dotsize = new JTextField(5);
        this.t_gridx.setText(Integer.toString(this.graphdisplay.gridX));
        this.t_gridy.setText(Integer.toString(this.graphdisplay.gridY));
        this.t_fontsize.setText("12.0");
        this.t_dotsize.setText("1.0");
        jButton5.setMnemonic(78);
        jButton2.setMnemonic(67);
        jButton3.setMnemonic(88);
        jButton4.setMnemonic(70);
        jButton9.setMnemonic(86);
        jPanel.add(jButton);
        jPanel.add(jButton2);
        jPanel.add(jButton3);
        jPanel.add(jRadioButton);
        jPanel.add(jButton4);
        jPanel.add(jRadioButton3);
        jPanel.add(jRadioButton4);
        jPanel.add(jButton5);
        jPanel.add(jButton6);
        jPanel.add(jButton7);
        jPanel.add(jButton8);
        jPanel.add(jButton9);
        jPanel.add(jButton10);
        jPanel.add(jButton11);
        jPanel.add(jButton12);
        jPanel.add(jRadioButton2);
        jPanel.add(this.graphdisplay);
        jPanel.add(jLabel);
        jPanel.add(jLabel2);
        jPanel.add(jLabel3);
        jPanel.add(jLabel4);
        jPanel.add(jLabel5);
        jPanel.add(jLabel6);
        jPanel.add(jLabel7);
        jPanel.add(this.t_gridx);
        jPanel.add(this.t_gridy);
        jPanel.add(this.t_label);
        jPanel.add(this.t_fontsize);
        jPanel.add(this.t_dotsize);
        jPanel.add(this.c_fontlist);
        jButton.setToolTipText("automatically generate a drawing of the graph");
        jButton4.setToolTipText("reverse direction of selected edges");
        jButton5.setToolTipText("clear the current graph");
        jButton6.setToolTipText("open a graph from an adjacency list");
        jButton7.setToolTipText("open a graph from an adjacency matrix");
        jButton8.setToolTipText("open a graph from a PostScript file");
        jButton10.setToolTipText("save graph to an adjacency list");
        jButton11.setToolTipText("save graph to an adjacency matrix");
        jButton12.setToolTipText("save graph to a PostScript file");
        this.t_label.setToolTipText("set label for the currently selected vertices");
        this.t_dotsize.setToolTipText("set drawing scale of vertices, arrowheads, etc.");
        this.c_fontlist.setToolTipText("set font for labels");
        this.t_fontsize.setToolTipText("set font size for labels");
        jRadioButton4.setToolTipText("turn snap-to-grid on");
        jRadioButton3.setToolTipText("turn snap-to-grid off");
        this.t_gridx.setToolTipText("set grid width");
        this.t_gridy.setToolTipText("set grid height");
        jPanel.setLayout(null);
        graph_w = 400;
        graph_h = 400;
        button_w = 150;
        button_h = 20;
        border_w = 10;
        border_h = 10;
        jButton.setBounds(graph_w * 1 + button_w * 0 + border_w * 1, graph_h * 0 + button_h * 13 + border_h * 14, button_w, button_h);
        jButton2.setBounds(graph_w * 0 + button_w * 0 + border_w * 1, graph_h * 1 + button_h * 1 + border_h * 2, button_w, button_h);
        jButton3.setBounds(graph_w * 0 + button_w * 1 + border_w * 2, graph_h * 1 + button_h * 1 + border_h * 2, button_w, button_h);
        jButton4.setBounds(graph_w * 0 + button_w * 3 + border_w * 4, graph_h * 1 + button_h * 1 + border_h * 2, button_w, button_h);
        jButton5.setBounds(graph_w * 1 + button_w * 0 + border_w * 1, graph_h * 0 + button_h * 0 + border_h * 1, button_w, button_h);
        jButton6.setBounds(graph_w * 1 + button_w * 0 + border_w * 1, graph_h * 0 + button_h * 3 + border_h * 4, button_w, button_h);
        jButton7.setBounds(graph_w * 1 + button_w * 0 + border_w * 1, graph_h * 0 + button_h * 2 + border_h * 3, button_w, button_h);
        jButton8.setBounds(graph_w * 1 + button_w * 0 + border_w * 1, graph_h * 0 + button_h * 1 + border_h * 2, button_w, button_h);
        jButton9.setBounds(graph_w * 0 + button_w * 2 + border_w * 3, graph_h * 1 + button_h * 1 + border_h * 2, button_w, button_h);
        jButton10.setBounds(graph_w * 1 + button_w * 1 + border_w * 2, graph_h * 0 + button_h * 3 + border_h * 4, button_w, button_h);
        jButton11.setBounds(graph_w * 1 + button_w * 1 + border_w * 2, graph_h * 0 + button_h * 2 + border_h * 3, button_w, button_h);
        jButton12.setBounds(graph_w * 1 + button_w * 1 + border_w * 2, graph_h * 0 + button_h * 1 + border_h * 2, button_w, button_h);
        jLabel.setBounds((int)((double)(graph_w * 1) + (double)button_w * 0.0 + (double)(border_w * 1)), graph_h * 0 + button_h * 5 + border_h * 6, button_w / 2, button_h);
        jRadioButton.setBounds((int)((double)(graph_w * 1) + (double)button_w * 0.5 + (double)(border_w * 2)), graph_h * 0 + button_h * 5 + border_h * 6, button_w / 2, button_h);
        jRadioButton2.setBounds((int)((double)(graph_w * 1) + (double)button_w * 1.0 + (double)(border_w * 3)), graph_h * 0 + button_h * 5 + border_h * 6, button_w, button_h);
        jLabel2.setBounds((int)((double)(graph_w * 1) + (double)button_w * 0.0 + (double)(border_w * 1)), graph_h * 0 + button_h * 6 + border_h * 7, button_w / 2, button_h);
        jRadioButton3.setBounds((int)((double)(graph_w * 1) + (double)button_w * 0.5 + (double)(border_w * 2)), graph_h * 0 + button_h * 6 + border_h * 7, button_w / 2, button_h);
        jRadioButton4.setBounds((int)((double)(graph_w * 1) + (double)button_w * 1.0 + (double)(border_w * 3)), graph_h * 0 + button_h * 6 + border_h * 7, button_w, button_h);
        jLabel3.setBounds((int)((double)(graph_w * 1) + (double)button_w * 0.25 + (double)(border_w * 1)), graph_h * 0 + button_h * 7 + border_h * 8, button_w / 4, button_h);
        this.t_gridx.setBounds((int)((double)(graph_w * 1) + (double)button_w * 0.5 + (double)(border_w * 2)), graph_h * 0 + button_h * 7 + border_h * 8, button_w / 4, button_h);
        this.t_gridy.setBounds((int)((double)(graph_w * 1) + (double)button_w * 0.75 + (double)(border_w * 3)), graph_h * 0 + button_h * 7 + border_h * 8, button_w / 4, button_h);
        jLabel5.setBounds(graph_w * 0 + button_w * 0 + border_w * 1, graph_h * 1 + button_h * 2 + border_h * 3, button_w, button_h);
        this.t_label.setBounds((int)((double)(graph_w * 0) + (double)button_w * 0.5 + (double)(border_w * 1)), graph_h * 1 + button_h * 2 + border_h * 3, button_w, button_h);
        jLabel6.setBounds(graph_w * 1 + button_w * 0 + border_w * 1, graph_h * 0 + button_h * 9 + border_h * 10, button_w / 4, button_h);
        this.c_fontlist.setBounds((int)((double)(graph_w * 1) + (double)button_w * 0.25 + (double)(border_w * 1)), graph_h * 0 + button_h * 9 + border_h * 10, button_w, button_h);
        this.t_fontsize.setBounds((int)((double)(graph_w * 1) + (double)button_w * 1.25 + (double)(border_w * 2)), graph_h * 0 + button_h * 9 + border_h * 10, button_w / 4, button_h);
        jLabel7.setBounds(graph_w * 1 + button_w * 0 + border_w * 1, graph_h * 0 + button_h * 11 + border_h * 12, button_w / 4, button_h);
        this.t_dotsize.setBounds((int)((double)(graph_w * 1) + (double)button_w * 0.25 + (double)(border_w * 2)), graph_h * 0 + button_h * 11 + border_h * 12, button_w / 4, button_h);
        this.graphdisplay.setBounds(0, 0, graph_w, graph_h);
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GraphDraw.this.graphdisplay.copy();
            }
        });
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GraphDraw.this.graphdisplay.cut();
            }
        });
        jRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GraphDraw.this.graphdisplay.makeDirected();
            }
        });
        jButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GraphDraw.this.graphdisplay.flip();
            }
        });
        jRadioButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GraphDraw.this.graphdisplay.setGridOff();
            }
        });
        jRadioButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GraphDraw.this.graphdisplay.setGridOn();
                GraphDraw.this.updateGridSize();
            }
        });
        this.t_gridx.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GraphDraw.this.updateGridSize();
            }
        });
        this.t_gridy.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GraphDraw.this.updateGridSize();
            }
        });
        this.t_label.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GraphDraw.this.graphdisplay.setLabel(GraphDraw.this.t_label.getText());
            }
        });
        jButton5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GraphDraw.this.graphdisplay.clear();
                GraphDraw.this.t_dotsize.setText(Double.toString(GraphDraw.this.graphdisplay.getScale()));
                GraphDraw.this.t_fontsize.setText(Double.toString(GraphDraw.this.graphdisplay.getFontSize()));
                GraphDraw.this.c_fontlist.setSelectedIndex(GraphDraw.this.graphdisplay.getFontIndex());
            }
        });
        jButton9.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GraphDraw.this.graphdisplay.paste();
            }
        });
        jButton12.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!GraphDraw.this.graphdisplay.saveps()) {
                    JOptionPane.showMessageDialog(mainFrame, "Error saving file.");
                }
            }
        });
        jButton8.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!GraphDraw.this.graphdisplay.openps("")) {
                    JOptionPane.showMessageDialog(mainFrame, "Error reading input file (possibly a PostScript file not generated by GraphDraw).");
                } else {
                    GraphDraw.this.t_dotsize.setText(Double.toString(GraphDraw.this.graphdisplay.getScale()));
                    GraphDraw.this.t_fontsize.setText(Double.toString(GraphDraw.this.graphdisplay.getFontSize()));
                    GraphDraw.this.c_fontlist.setSelectedIndex(GraphDraw.this.graphdisplay.getFontIndex());
                }
                if (GraphDraw.this.graphdisplay.isDirected()) {
                    jRadioButton.setSelected(true);
                } else {
                    jRadioButton2.setSelected(true);
                }
            }
        });
        jButton7.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!GraphDraw.this.graphdisplay.openmatrix()) {
                    JOptionPane.showMessageDialog(mainFrame, "Error reading input file.");
                } else {
                    GraphDraw.this.t_dotsize.setText(Double.toString(GraphDraw.this.graphdisplay.getScale()));
                    GraphDraw.this.t_fontsize.setText(Double.toString(GraphDraw.this.graphdisplay.getFontSize()));
                    GraphDraw.this.c_fontlist.setSelectedIndex(GraphDraw.this.graphdisplay.getFontIndex());
                }
                if (GraphDraw.this.graphdisplay.isDirected()) {
                    jRadioButton.setSelected(true);
                } else {
                    jRadioButton2.setSelected(true);
                }
            }
        });
        jButton11.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!GraphDraw.this.graphdisplay.savematrix()) {
                    JOptionPane.showMessageDialog(mainFrame, "Error saving file.");
                }
            }
        });
        jButton6.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!GraphDraw.this.graphdisplay.openlist()) {
                    JOptionPane.showMessageDialog(mainFrame, "Error reading input file.");
                } else {
                    GraphDraw.this.t_dotsize.setText(Double.toString(GraphDraw.this.graphdisplay.getScale()));
                    GraphDraw.this.t_fontsize.setText(Double.toString(GraphDraw.this.graphdisplay.getFontSize()));
                    GraphDraw.this.c_fontlist.setSelectedIndex(GraphDraw.this.graphdisplay.getFontIndex());
                }
                if (GraphDraw.this.graphdisplay.isDirected()) {
                    jRadioButton.setSelected(true);
                } else {
                    jRadioButton2.setSelected(true);
                }
            }
        });
        jButton10.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!GraphDraw.this.graphdisplay.savelist()) {
                    JOptionPane.showMessageDialog(mainFrame, "Error saving file.");
                }
            }
        });
        jRadioButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GraphDraw.this.graphdisplay.makeUndirected();
            }
        });
        this.c_fontlist.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GraphDraw.this.updateFontSettings();
            }
        });
        this.t_fontsize.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GraphDraw.this.updateFontSettings();
            }
        });
        this.t_dotsize.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GraphDraw.this.updateSizeSettings();
            }
        });
        return jPanel;
    }

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Font[] fontArray = graphicsEnvironment.getAllFonts();
        fontStrings = new String[fontArray.length];
        int n = 0;
        while (n < fontArray.length) {
            GraphDraw.fontStrings[n] = fontArray[n].getFontName();
            ++n;
        }
        JFrame jFrame = new JFrame("GraphDraw");
        GraphDraw graphDraw = new GraphDraw();
        Component component = graphDraw.createComponents();
        jFrame.getContentPane().add(component, "Center");
        mainFrame = jFrame;
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        jFrame.pack();
        jFrame.setSize(new Dimension(graph_w + button_w * 2 + border_w * 3, graph_h + button_h * 4 + border_h * 5));
        jFrame.setVisible(true);
    }
}

