/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import javax.swing.JFileChooser;
import javax.swing.JPanel;

class GraphDisplay
extends JPanel
implements MouseListener,
MouseMotionListener,
KeyListener {
    private Graph graph;
    private Graph startG;
    private Graph copyG;
    private int i;
    private int Mx;
    private int My;
    private int pick = -1;
    private boolean[] selection;
    private boolean boxPick;
    private boolean drag;
    private boolean gridOn;
    private boolean selfEdge;
    private int startX;
    private int startY;
    private int edgeStep;
    private int edgev1;
    private int edgev2;
    public int gridX;
    public int gridY;
    private double dotSize;
    private double lineWidth;
    private double fontSize;
    private int fontIndex;
    Graphics2D g2;
    String[] fontPSStrings;
    String[] fontStrings;

    public GraphDisplay() {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(this);
        this.graph = new Graph(5);
        this.i = 0;
        while (this.i < 5) {
            int n = 0;
            while (n < this.i) {
                this.graph.setEdge(this.i, n, 1);
                ++n;
            }
            ++this.i;
        }
        this.selection = new boolean[this.graph.V];
        this.boxPick = false;
        this.selfEdge = false;
        this.gridOn = false;
        this.gridX = 10;
        this.gridY = 10;
        this.fontSize = 12.0;
        this.edgeStep = 0;
        this.dotSize = 4.0;
        this.lineWidth = 1.0;
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Font[] fontArray = graphicsEnvironment.getAllFonts();
        this.fontStrings = new String[fontArray.length];
        this.fontPSStrings = new String[fontArray.length];
        this.fontIndex = 0;
        int n = 0;
        while (n < fontArray.length) {
            this.fontStrings[n] = fontArray[n].getFontName();
            this.fontPSStrings[n] = fontArray[n].getPSName();
            if (this.fontStrings[n].startsWith("Times-Roman")) {
                this.fontIndex = n;
            }
            ++n;
        }
    }

    public double getScale() {
        return this.dotSize / 4.0;
    }

    public double getFontSize() {
        return this.fontSize;
    }

    public int getFontIndex() {
        return this.fontIndex;
    }

    public void setGridOn() {
        this.gridOn = true;
    }

    public void setGridOff() {
        this.gridOn = false;
    }

    public void makeDirected() {
        this.graph.makeDirected();
        this.repaint();
    }

    public void makeUndirected() {
        this.graph.makeUndirected();
        this.repaint();
    }

    public boolean isDirected() {
        return this.graph.directed;
    }

    public void setLabel(String string) {
        this.i = 0;
        while (this.i < this.graph.V) {
            if (this.selection[this.i]) {
                this.graph.setLabel(this.i, string);
            }
            ++this.i;
        }
        this.edgeStep = 0;
        this.repaint();
    }

    public void setFont(String string) {
        this.i = 0;
        while (this.i < this.fontStrings.length) {
            if (this.fontStrings[this.i].compareTo(string) == 0) {
                this.fontIndex = this.i;
            }
            ++this.i;
        }
        this.repaint();
    }

    public void setFontSize(double d) {
        this.fontSize = d;
        this.repaint();
    }

    public void setDotSize(double d) {
        this.dotSize = d *= 4.0;
        this.graph.pickCheckRadius = d;
        this.lineWidth = this.dotSize / 4.0;
        this.repaint();
    }

    public void copy() {
        block12: {
            int n = 0;
            this.i = 0;
            while (this.i < this.graph.V) {
                if (this.selection[this.i]) {
                    ++n;
                }
                ++this.i;
            }
            if (n <= 0) break block12;
            this.copyG = new Graph(n);
            if (this.graph.directed) {
                this.copyG.makeDirected();
                int n2 = 0;
                this.i = 0;
                while (this.i < this.graph.V) {
                    if (this.selection[this.i]) {
                        this.copyG.Px[n2] = this.graph.Px[this.i];
                        this.copyG.Py[n2] = this.graph.Py[this.i];
                        this.copyG.label[n2] = this.graph.label[this.i];
                        int n3 = 0;
                        int n4 = 0;
                        while (n4 < this.graph.V) {
                            if (this.selection[n4]) {
                                this.copyG.setEdge(n2, n3, this.graph.nEdges(this.i, n4));
                                ++n3;
                            }
                            ++n4;
                        }
                        ++n2;
                    }
                    ++this.i;
                }
            } else {
                this.copyG.makeUndirected();
                int n5 = 0;
                this.i = 0;
                while (this.i < this.graph.V) {
                    if (this.selection[this.i]) {
                        this.copyG.Px[n5] = this.graph.Px[this.i];
                        this.copyG.Py[n5] = this.graph.Py[this.i];
                        this.copyG.label[n5] = this.graph.label[this.i];
                        int n6 = 0;
                        int n7 = 0;
                        while (n7 <= this.i) {
                            if (this.selection[n7]) {
                                this.copyG.setEdge(n5, n6, this.graph.nEdges(this.i, n7));
                                ++n6;
                            }
                            ++n7;
                        }
                        ++n5;
                    }
                    ++this.i;
                }
            }
        }
    }

    public void cut() {
        this.copy();
        this.i = 0;
        while (this.i < this.graph.V) {
            if (this.selection[this.i]) {
                this.graph.removeVertex(this.i);
                int n = this.i;
                while (n < this.graph.V) {
                    this.selection[n] = this.selection[n + 1];
                    ++n;
                }
                continue;
            }
            ++this.i;
        }
        this.pick = -1;
        this.edgeStep = 0;
        this.repaint();
    }

    public void paste() {
        int n = this.graph.V;
        this.i = 0;
        while (this.i < this.copyG.V) {
            this.graph.addVertex(this.copyG.Px[this.i] + this.dotSize * 6.0, this.copyG.Py[this.i] + this.dotSize * 6.0);
            this.graph.setLabel(n + this.i, this.copyG.label[this.i]);
            ++this.i;
        }
        this.selection = new boolean[this.graph.V];
        this.i = n;
        while (this.i < this.graph.V) {
            this.selection[this.i] = true;
            ++this.i;
        }
        this.i = 0;
        while (this.i < this.copyG.V) {
            int n2 = this.i;
            this.copyG.Px[n2] = this.copyG.Px[n2] + this.dotSize * 6.0;
            int n3 = this.i++;
            this.copyG.Py[n3] = this.copyG.Py[n3] + this.dotSize * 6.0;
        }
        if (this.graph.directed) {
            this.i = 0;
            while (this.i < this.copyG.V) {
                int n4 = 0;
                while (n4 < this.copyG.V) {
                    this.graph.setEdge(this.i + n, n4 + n, this.copyG.nEdges(this.i, n4));
                    ++n4;
                }
                ++this.i;
            }
        } else {
            this.i = 0;
            while (this.i < this.copyG.V) {
                int n5 = 0;
                while (n5 <= this.i) {
                    this.graph.setEdge(this.i + n, n5 + n, this.copyG.nEdges(this.i, n5));
                    ++n5;
                }
                ++this.i;
            }
        }
        this.repaint();
    }

    public void clear() {
        boolean bl = this.graph.directed;
        this.graph = new Graph(0);
        this.graph.directed = bl;
        this.selection = new boolean[0];
        this.boxPick = false;
        this.selfEdge = false;
        this.fontSize = 12.0;
        this.edgeStep = 0;
        this.dotSize = 4.0;
        this.lineWidth = 1.0;
        int n = 0;
        while (n < this.fontStrings.length) {
            if (this.fontStrings[n].startsWith("Times-Roman")) {
                this.fontIndex = n;
            }
            ++n;
        }
        this.repaint();
    }

    public void flip() {
        int n;
        int n2 = 0;
        this.i = 0;
        while (this.i < this.graph.V) {
            n = this.i;
            while (n < this.graph.V) {
                if (this.selection[this.i] && this.selection[n]) {
                    ++n2;
                    this.graph.flipEdges(this.i, n);
                }
                ++n;
            }
            ++this.i;
        }
        if (n2 == 0) {
            this.i = 0;
            while (this.i < this.graph.V) {
                n = this.i;
                while (n < this.graph.V) {
                    this.graph.flipEdges(this.i, n);
                    ++n;
                }
                ++this.i;
            }
        }
        this.repaint();
    }

    public boolean openmatrix() {
        JFileChooser jFileChooser = new JFileChooser();
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            try {
                String string;
                int n2;
                int n3;
                String string2;
                File file = jFileChooser.getSelectedFile();
                BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                String string3 = bufferedReader.readLine();
                int n4 = Integer.parseInt(bufferedReader.readLine());
                this.graph = new Graph(n4);
                if (string3.charAt(0) == 'U') {
                    this.graph.makeUndirected();
                } else {
                    this.graph.makeDirected();
                }
                if (!this.graph.directed) {
                    this.i = 0;
                    while (this.i < n4) {
                        string2 = bufferedReader.readLine();
                        n3 = 0;
                        while (n3 <= this.i) {
                            n2 = string2.indexOf(32);
                            if (n2 != -1) {
                                string = string2.substring(0, n2);
                                string2 = string2.substring(n2 + 1);
                            } else {
                                string = string2;
                            }
                            this.graph.setEdge(this.i, n3, Integer.parseInt(string));
                            ++n3;
                        }
                        ++this.i;
                    }
                } else {
                    this.i = 0;
                    while (this.i < n4) {
                        string2 = bufferedReader.readLine();
                        n3 = 0;
                        while (n3 < n4) {
                            n2 = string2.indexOf(32);
                            if (n2 != -1) {
                                string = string2.substring(0, n2);
                                string2 = string2.substring(n2 + 1);
                            } else {
                                string = string2;
                            }
                            this.graph.setEdge(this.i, n3, Integer.parseInt(string));
                            ++n3;
                        }
                        ++this.i;
                    }
                }
                bufferedReader.close();
                this.selection = new boolean[this.graph.V];
                this.dotSize = 4.0;
                this.lineWidth = 1.0;
                this.fontSize = 12.0;
                int n5 = 0;
                while (n5 < this.fontStrings.length) {
                    if (this.fontStrings[n5].startsWith("Times-Roman")) {
                        this.fontIndex = n5;
                    }
                    ++n5;
                }
                this.repaint();
                return true;
            }
            catch (Exception exception) {
                this.graph = new Graph(0);
                this.selection = new boolean[0];
                this.repaint();
                return false;
            }
        }
        return true;
    }

    public boolean savematrix() {
        JFileChooser jFileChooser = new JFileChooser();
        int n = jFileChooser.showSaveDialog(this);
        if (n == 0) {
            try {
                File file = jFileChooser.getSelectedFile();
                BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
                if (this.graph.directed) {
                    bufferedWriter.write(68);
                } else {
                    bufferedWriter.write(85);
                }
                bufferedWriter.write(10);
                String string = Integer.toString(this.graph.V) + "\n";
                bufferedWriter.write(string, 0, string.length());
                this.i = 0;
                while (this.i < this.graph.V) {
                    int n2 = 0;
                    while (n2 < this.graph.V) {
                        String string2 = n2 == this.graph.V - 1 ? Integer.toString(this.graph.nEdges(this.i, n2)) + "\n" : Integer.toString(this.graph.nEdges(this.i, n2)) + " ";
                        bufferedWriter.write(string2, 0, string2.length());
                        ++n2;
                    }
                    ++this.i;
                }
                bufferedWriter.close();
                this.repaint();
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return true;
    }

    public boolean openlist() {
        JFileChooser jFileChooser = new JFileChooser();
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            try {
                int n2;
                File file = jFileChooser.getSelectedFile();
                BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                String string = bufferedReader.readLine();
                int n3 = Integer.parseInt(bufferedReader.readLine());
                int n4 = Integer.parseInt(bufferedReader.readLine());
                this.graph = new Graph(n3);
                if (string.charAt(0) == 'U') {
                    this.graph.makeUndirected();
                } else {
                    this.graph.makeDirected();
                }
                this.i = 0;
                while (this.i < n4) {
                    string = bufferedReader.readLine();
                    n2 = string.indexOf(32);
                    String string2 = string.substring(0, n2);
                    String string3 = string.substring(n2 + 1);
                    int n5 = Integer.parseInt(string2);
                    int n6 = Integer.parseInt(string3);
                    this.graph.setEdge(n5, n6, 1);
                    ++this.i;
                }
                bufferedReader.close();
                this.selection = new boolean[this.graph.V];
                this.dotSize = 4.0;
                this.lineWidth = 1.0;
                this.fontSize = 12.0;
                n2 = 0;
                while (n2 < this.fontStrings.length) {
                    if (this.fontStrings[n2].startsWith("Times-Roman")) {
                        this.fontIndex = n2;
                    }
                    ++n2;
                }
                this.repaint();
                return true;
            }
            catch (Exception exception) {
                this.graph = new Graph(0);
                this.selection = new boolean[0];
                this.repaint();
                return false;
            }
        }
        return true;
    }

    public boolean savelist() {
        JFileChooser jFileChooser = new JFileChooser();
        int n = jFileChooser.showSaveDialog(this);
        if (n == 0) {
            try {
                int n2;
                File file = jFileChooser.getSelectedFile();
                BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
                if (this.graph.directed) {
                    bufferedWriter.write(68);
                } else {
                    bufferedWriter.write(85);
                }
                bufferedWriter.write(10);
                String string = Integer.toString(this.graph.V) + "\n";
                bufferedWriter.write(string, 0, string.length());
                int n3 = 0;
                if (this.graph.directed) {
                    this.i = 0;
                    while (this.i < this.graph.V) {
                        n2 = 0;
                        while (n2 < this.graph.V) {
                            n3 += this.graph.nEdges(this.i, n2);
                            ++n2;
                        }
                        ++this.i;
                    }
                } else {
                    this.i = 0;
                    while (this.i < this.graph.V) {
                        n2 = this.i;
                        while (n2 < this.graph.V) {
                            n3 += this.graph.nEdges(this.i, n2);
                            ++n2;
                        }
                        ++this.i;
                    }
                }
                String string2 = Integer.toString(n3) + "\n";
                bufferedWriter.write(string2, 0, string2.length());
                if (this.graph.directed) {
                    this.i = 0;
                    while (this.i < this.graph.V) {
                        int n4 = 0;
                        while (n4 < this.graph.V) {
                            int n5 = 0;
                            while (n5 < this.graph.nEdges(this.i, n4)) {
                                String string3 = Integer.toString(this.i) + " " + Integer.toString(n4) + "\n";
                                bufferedWriter.write(string3, 0, string3.length());
                                ++n5;
                            }
                            ++n4;
                        }
                        ++this.i;
                    }
                } else {
                    this.i = 0;
                    while (this.i < this.graph.V) {
                        int n6 = 0;
                        while (n6 <= this.i) {
                            int n7 = 0;
                            while (n7 < this.graph.nEdges(this.i, n6)) {
                                String string4 = Integer.toString(this.i) + " " + Integer.toString(n6) + "\n";
                                bufferedWriter.write(string4, 0, string4.length());
                                ++n7;
                            }
                            ++n6;
                        }
                        ++this.i;
                    }
                }
                bufferedWriter.close();
                this.repaint();
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return true;
    }

    private String psline(double d, double d2, double d3, double d4) {
        String string = Double.toString(d);
        String string2 = Double.toString(d3);
        String string3 = Double.toString(400.0 - d2);
        String string4 = Double.toString(400.0 - d4);
        return "newpath\n" + string + " " + string3 + " moveto\n" + string2 + " " + string4 + " lineto\n" + "closepath\n" + "stroke\n\n";
    }

    private String psarc(double d, double d2, double d3, double d4, double d5) {
        double d6;
        double d7;
        double d8;
        double d9;
        while (d4 < 0.0) {
            d4 += 360.0;
        }
        while (d5 < 0.0) {
            d5 += 360.0;
        }
        if (d5 < d4) {
            double d10 = d4;
            d4 = d5;
            d5 = d10;
        }
        if ((d9 = d5 - d4) < (d8 = 360.0 - d9)) {
            d7 = d4;
            d6 = d9;
        } else {
            d7 = d5;
            d6 = d8;
        }
        String string = Double.toString(d);
        String string2 = Double.toString(400.0 - d2);
        String string3 = Double.toString(d3);
        String string4 = Double.toString(d7);
        String string5 = Double.toString(d7 + d6);
        return "newpath\n" + string + " " + string2 + " " + string3 + " " + string4 + " " + string5 + " arc\n" + "stroke\n\n";
    }

    private String pstriangle(double d, double d2, double d3, double d4, double d5, double d6) {
        String string = Double.toString(d);
        String string2 = Double.toString(d3);
        String string3 = Double.toString(d5);
        String string4 = Double.toString(400.0 - d2);
        String string5 = Double.toString(400.0 - d4);
        String string6 = Double.toString(400.0 - d6);
        return "newpath\n" + string + " " + string4 + " moveto\n" + string2 + " " + string5 + " lineto\n" + string3 + " " + string6 + " lineto\n" + "closepath\n" + "fill\n\n";
    }

    private String psstrokecircle(double d, double d2, double d3) {
        String string = Double.toString(d);
        String string2 = Double.toString(400.0 - d2);
        String string3 = Double.toString(d3);
        return "newpath\n" + string + " " + string2 + " " + string3 + " 0 360 arc\n" + "stroke\n\n";
    }

    private String psfillcircle(double d, double d2, double d3) {
        String string = Double.toString(d);
        String string2 = Double.toString(400.0 - d2);
        String string3 = Double.toString(d3);
        return "newpath\n" + string + " " + string2 + " " + string3 + " 0 360 arc\n" + "fill\n\n";
    }

    private String pstext(double d, double d2, String string) {
        String string2 = Double.toString(d);
        String string3 = Double.toString(400.0 - d2);
        return "newpath\n" + string2 + " " + string3 + " moveto\n" + "(" + string + ")" + " show\n";
    }

    public boolean saveps() {
        JFileChooser jFileChooser = new JFileChooser();
        int n = jFileChooser.showSaveDialog(this);
        if (n == 0) {
            try {
                double d;
                double d2;
                double d3;
                double d4;
                double d5;
                Object object;
                double d6;
                double d7;
                double d8;
                double d9;
                Object object2;
                Vector2D vector2D;
                Object object3;
                Vector2D vector2D2;
                int n2;
                int n3;
                int n4;
                int n5;
                File file = jFileChooser.getSelectedFile();
                FileWriter fileWriter = new FileWriter(file);
                fileWriter.write("%!\n");
                fileWriter.write("%% File generated by GraphDraw\n\n");
                if (this.graph.directed) {
                    fileWriter.write("%%D\n");
                } else {
                    fileWriter.write("%%U\n");
                }
                fileWriter.write("%%" + Integer.toString(this.graph.V) + "\n");
                fileWriter.write("%%" + Double.toString(this.dotSize / 4.0) + "\n");
                fileWriter.write("%%" + this.fontStrings[this.fontIndex] + "\n");
                fileWriter.write("%%" + Double.toString(this.fontSize) + "\n");
                this.i = 0;
                while (this.i < this.graph.V) {
                    fileWriter.write("%%");
                    n5 = 0;
                    while (n5 < this.graph.V) {
                        String string = n5 == this.graph.V - 1 ? Integer.toString(this.graph.nEdges(this.i, n5)) + "\n" : Integer.toString(this.graph.nEdges(this.i, n5)) + " ";
                        fileWriter.write(string, 0, string.length());
                        ++n5;
                    }
                    ++this.i;
                }
                this.i = 0;
                while (this.i < this.graph.V) {
                    fileWriter.write("%%");
                    fileWriter.write(this.graph.label[this.i] + "\n%%");
                    fileWriter.write(Double.toString(this.graph.Px[this.i]) + " ");
                    fileWriter.write(Double.toString(this.graph.Py[this.i]));
                    fileWriter.write("\n");
                    ++this.i;
                }
                fileWriter.write(Double.toString(this.lineWidth) + " setlinewidth\n\n");
                fileWriter.write("/" + this.fontPSStrings[this.fontIndex] + " findfont\n" + this.fontSize + " scalefont\n" + "setfont\n\n");
                if (this.graph.directed) {
                    this.i = 0;
                    while (this.i < this.graph.V) {
                        n5 = 0;
                        while (n5 < this.graph.V) {
                            if (this.graph.nEdges(this.i, n5) > 0) {
                                Object object4;
                                Object object5;
                                int n6 = this.graph.cx(this.i);
                                n4 = this.graph.cx(n5);
                                n3 = this.graph.cy(this.i);
                                n2 = this.graph.cy(n5);
                                if (this.i == n5) {
                                    int n7 = 0;
                                    while (n7 < this.graph.nEdges(this.i, n5)) {
                                        Vector2D vector2D3 = new Vector2D();
                                        vector2D2 = new Vector2D();
                                        object3 = new int[3];
                                        object5 = new int[3];
                                        vector2D = this.outwardVector(this.i);
                                        double d10 = this.dotSize * 6.0 + (double)n7 * this.dotSize * 1.25;
                                        if (vector2D.zero()) {
                                            vector2D.y = 1.0;
                                            vector2D.x = 1.0;
                                            vector2D.normalize();
                                        }
                                        object4 = new Vector2D(n6, n3);
                                        object2 = new Vector2D((double)n6 + vector2D.x * d10, (double)n3 + vector2D.y * d10);
                                        fileWriter.write(this.psstrokecircle(((Vector2D)object2).x, ((Vector2D)object2).y, d10));
                                        vector2D3 = vector2D3.subtract((Vector2D)object4, (Vector2D)object2);
                                        vector2D3.rotate(this.dotSize / d10);
                                        vector2D3 = vector2D3.add(vector2D3, (Vector2D)object2);
                                        object3[0] = (int)vector2D3.x;
                                        object5[0] = (int)vector2D3.y;
                                        vector2D3 = vector2D3.subtract((Vector2D)object4, (Vector2D)object2);
                                        vector2D3.rotate((this.dotSize * 2.5 + this.dotSize) / d10);
                                        vector2D3 = vector2D3.add(vector2D3, (Vector2D)object2);
                                        vector2D2 = vector2D2.subtract((Vector2D)object4, vector2D3);
                                        vector2D2.orthogonalize();
                                        vector2D2.normalize();
                                        vector2D2.scalar(this.dotSize * 1.125);
                                        object3[1] = (int)(vector2D3.x - vector2D2.x);
                                        object5[1] = (int)(vector2D3.y - vector2D2.y);
                                        object3[2] = (int)(vector2D3.x + vector2D2.x);
                                        object5[2] = (int)(vector2D3.y + vector2D2.y);
                                        fileWriter.write(this.pstriangle((double)object3[0], object5[0], (double)object3[1], object5[1], (double)object3[2], object5[2]));
                                        ++n7;
                                    }
                                } else {
                                    Vector2D vector2D4 = new Vector2D(n4 - n6, n2 - n3);
                                    vector2D = new Vector2D(n4 - n6, n2 - n3);
                                    vector2D4.orthogonalize();
                                    vector2D4.normalize();
                                    vector2D4.scalar(this.dotSize * 1.125);
                                    vector2D.normalize();
                                    vector2D.scalar(this.dotSize * 2.5 + this.dotSize);
                                    object4 = new int[3];
                                    object2 = new int[3];
                                    object4[0] = (int)((double)n4 - vector2D.x - vector2D4.x);
                                    object2[0] = (int)((double)n2 - vector2D.y - vector2D4.y);
                                    object4[1] = (int)((double)n4 - vector2D.x + vector2D4.x);
                                    object2[1] = (int)((double)n2 - vector2D.y + vector2D4.y);
                                    vector2D.normalize();
                                    vector2D.scalar(this.dotSize);
                                    object4[2] = (int)((double)n4 - vector2D.x);
                                    object2[2] = (int)((double)n2 - vector2D.y);
                                    fileWriter.write(this.pstriangle(object4[0], (double)object2[0], object4[1], (double)object2[1], object4[2], (double)object2[2]));
                                    if (this.graph.nEdges(n5, this.i) == 0) {
                                        fileWriter.write(this.psline(n6, n3, n4, n2));
                                    } else if (this.i < n5) {
                                        fileWriter.write(this.psline(n6, n3, n4, n2));
                                    }
                                    int n8 = 1;
                                    while (n8 < this.graph.nEdges(this.i, n5)) {
                                        Vector2D vector2D5;
                                        vector2D2 = new Vector2D(n6, n3);
                                        Vector2D vector2D6 = new Vector2D(n4, n2);
                                        vector2D4 = new Vector2D();
                                        vector2D4 = vector2D4.subtract(vector2D6, vector2D2);
                                        vector2D4.scalar(0.5);
                                        d9 = vector2D4.magnitude();
                                        d8 = d9 * (double)n8 / (double)this.graph.nEdges(this.i, n5);
                                        d7 = (d9 * d9 + d8 * d8) / (2.0 * d8);
                                        d6 = d7 - d8;
                                        vector2D = vector2D4.orthogonal();
                                        vector2D.normalize();
                                        vector2D.scalar(d6);
                                        object = new Vector2D(vector2D2.x + vector2D4.x + vector2D.x, vector2D2.y + vector2D4.y + vector2D.y);
                                        object3 = new Vector2D(vector2D2.x + vector2D4.x - vector2D.x, vector2D2.y + vector2D4.y - vector2D.y);
                                        d5 = this.vertexSum((Vector2D)object);
                                        double d11 = this.vertexSum((Vector2D)object3);
                                        if (this.i > n5 ^ d5 < d11) {
                                            object = object3;
                                        }
                                        object5 = new Vector2D();
                                        Vector2D vector2D7 = new Vector2D();
                                        object5 = ((Vector2D)object5).subtract(vector2D2, (Vector2D)object);
                                        vector2D7 = vector2D7.subtract(vector2D6, (Vector2D)object);
                                        d4 = ((Vector2D)object5).angle();
                                        d3 = vector2D7.angle();
                                        d2 = this.minAngle(d4, d3);
                                        d = ((Vector2D)object5).magnitude();
                                        if (this.i > n5 ^ d5 < d11) {
                                            fileWriter.write(this.psarc(((Vector2D)object).x, ((Vector2D)object).y, d, d4, d3));
                                        } else {
                                            fileWriter.write(this.psarc(((Vector2D)object).x, ((Vector2D)object).y, d, d4, d3));
                                        }
                                        float f = d5 < d11 ? 1.0f : -1.0f;
                                        if (this.i > n5) {
                                            vector2D5 = vector2D6;
                                            f = -f;
                                        } else {
                                            vector2D5 = vector2D6;
                                        }
                                        Object object6 = object;
                                        Vector2D vector2D8 = new Vector2D();
                                        Vector2D vector2D9 = new Vector2D();
                                        vector2D8 = vector2D8.subtract(vector2D5, (Vector2D)object6);
                                        vector2D8.rotate((double)f * this.dotSize / d);
                                        vector2D8 = vector2D8.add(vector2D8, (Vector2D)object6);
                                        object4[0] = (int)vector2D8.x;
                                        object2[0] = (int)vector2D8.y;
                                        vector2D8 = vector2D8.subtract(vector2D5, (Vector2D)object6);
                                        vector2D8.rotate((double)f * (this.dotSize * 2.5 + this.dotSize) / d);
                                        vector2D8 = vector2D8.add(vector2D8, (Vector2D)object6);
                                        vector2D9 = vector2D9.subtract(vector2D5, vector2D8);
                                        vector2D9.orthogonalize();
                                        vector2D9.normalize();
                                        vector2D9.scalar(this.dotSize * 1.125);
                                        object4[1] = (int)(vector2D8.x - vector2D9.x);
                                        object2[1] = (int)(vector2D8.y - vector2D9.y);
                                        object4[2] = (int)(vector2D8.x + vector2D9.x);
                                        object2[2] = (int)(vector2D8.y + vector2D9.y);
                                        fileWriter.write(this.pstriangle(object4[0], (double)object2[0], object4[1], (double)object2[1], object4[2], (double)object2[2]));
                                        ++n8;
                                    }
                                }
                            }
                            ++n5;
                        }
                        ++this.i;
                    }
                } else {
                    this.i = 0;
                    while (this.i < this.graph.V) {
                        n5 = this.i;
                        while (n5 < this.graph.V) {
                            if (this.graph.nEdges(this.i, n5) > 0) {
                                int n9;
                                int n10 = this.graph.cx(this.i);
                                n4 = this.graph.cx(n5);
                                n3 = this.graph.cy(this.i);
                                n2 = this.graph.cy(n5);
                                if (this.i == n5) {
                                    n9 = 0;
                                    while (n9 < this.graph.nEdges(this.i, n5)) {
                                        vector2D = this.outwardVector(this.i);
                                        double d12 = this.dotSize * 6.0 + (double)n9 * this.dotSize * 1.25;
                                        if (vector2D.zero()) {
                                            vector2D.y = 1.0;
                                            vector2D.x = 1.0;
                                            vector2D.normalize();
                                        }
                                        fileWriter.write(this.psstrokecircle((double)n10 - d12 * vector2D.x, (double)n3 - d12 * vector2D.y, d12));
                                        ++n9;
                                    }
                                } else {
                                    fileWriter.write(this.psline(n10, n3, n4, n2));
                                    if (this.graph.nEdges(this.i, n5) > 1) {
                                        n9 = 1;
                                        while (n9 < this.graph.nEdges(this.i, n5)) {
                                            object2 = new Vector2D(n10, n3);
                                            Vector2D vector2D10 = new Vector2D(n4, n2);
                                            vector2D = new Vector2D();
                                            vector2D = vector2D.subtract(vector2D10, (Vector2D)object2);
                                            vector2D.scalar(0.5);
                                            d7 = vector2D.magnitude();
                                            d6 = d7 * (double)n9 / (double)this.graph.nEdges(this.i, n5);
                                            d2 = (d7 * d7 + d6 * d6) / (2.0 * d6);
                                            d9 = d2 - d6;
                                            Vector2D vector2D11 = vector2D.orthogonal();
                                            vector2D11.normalize();
                                            vector2D11.scalar(d9);
                                            vector2D2 = new Vector2D(((Vector2D)object2).x + vector2D.x + vector2D11.x, ((Vector2D)object2).y + vector2D.y + vector2D11.y);
                                            Vector2D vector2D12 = new Vector2D(((Vector2D)object2).x + vector2D.x - vector2D11.x, ((Vector2D)object2).y + vector2D.y - vector2D11.y);
                                            d8 = this.vertexSum(vector2D2);
                                            d5 = this.vertexSum(vector2D12);
                                            if (d8 >= d5) {
                                                vector2D2 = vector2D12;
                                            }
                                            object = new Vector2D();
                                            object3 = new Vector2D();
                                            object = ((Vector2D)object).subtract((Vector2D)object2, vector2D2);
                                            object3 = ((Vector2D)object3).subtract(vector2D10, vector2D2);
                                            d = ((Vector2D)object).angle();
                                            d4 = ((Vector2D)object3).angle();
                                            d3 = this.minAngle(d, d4);
                                            double d13 = ((Vector2D)object).magnitude();
                                            if (d8 >= d5) {
                                                fileWriter.write(this.psarc(vector2D2.x, vector2D2.y, d13, d, d4));
                                            } else {
                                                fileWriter.write(this.psarc(vector2D2.x, vector2D2.y, d13, d, d4));
                                            }
                                            ++n9;
                                        }
                                    }
                                }
                            }
                            ++n5;
                        }
                        ++this.i;
                    }
                }
                Font font = new Font(this.fontStrings[this.fontIndex], 0, (int)this.fontSize);
                this.g2.setFont(font);
                FontMetrics fontMetrics = this.g2.getFontMetrics();
                this.i = 0;
                while (this.i < this.graph.V) {
                    n2 = this.graph.cx(this.i);
                    int n11 = this.graph.cy(this.i);
                    fileWriter.write(this.psfillcircle(n2, n11, this.dotSize));
                    vector2D = new Vector2D();
                    vector2D = this.outwardVector(this.i);
                    if (vector2D.zero()) {
                        vector2D.y = 1.0;
                    }
                    vector2D.scalar(this.fontSize);
                    Vector2D vector2D13 = vector2D.normal();
                    n3 = fontMetrics.stringWidth(this.graph.label[this.i]);
                    n4 = fontMetrics.getAscent();
                    fileWriter.write(this.pstext((double)n2 + vector2D.x + (vector2D13.x - 1.0) * ((double)n3 / 2.0), (double)n11 + vector2D.y + (vector2D13.y + 1.0) * ((double)n4 / 2.0), this.graph.label[this.i]));
                    ++this.i;
                }
                fileWriter.close();
                return true;
            }
            catch (IOException iOException) {
                return false;
            }
        }
        return true;
    }

    public boolean openps(String string) {
        JFileChooser jFileChooser = new JFileChooser();
        int n = string == "" ? jFileChooser.showOpenDialog(this) : 0;
        if (n == 0) {
            try {
                String string2;
                int n2;
                int n3;
                String string3;
                BufferedReader bufferedReader;
                if (string != "") {
                    if (string.compareTo("graphdraw_cowboy.ps") == 0) {
                        this.getClass().getClassLoader();
                        bufferedReader = new BufferedReader(new InputStreamReader(ClassLoader.getSystemResourceAsStream(string)));
                    } else {
                        bufferedReader = new BufferedReader(new FileReader(string));
                    }
                } else {
                    File file = jFileChooser.getSelectedFile();
                    bufferedReader = new BufferedReader(new FileReader(file));
                }
                bufferedReader.readLine();
                bufferedReader.readLine();
                bufferedReader.readLine();
                String string4 = bufferedReader.readLine().substring(2);
                boolean bl = string4.charAt(0) == 'D';
                string4 = bufferedReader.readLine().substring(2);
                this.graph = new Graph(Integer.parseInt(string4));
                if (bl) {
                    this.graph.makeDirected();
                } else {
                    this.graph.makeUndirected();
                }
                string4 = bufferedReader.readLine().substring(2);
                this.dotSize = Double.parseDouble(string4) * 4.0;
                string4 = bufferedReader.readLine().substring(2);
                this.fontIndex = -1;
                this.i = 0;
                while (this.i < this.fontStrings.length) {
                    if (this.fontStrings[this.i].compareTo(string4) == 0) {
                        this.fontIndex = this.i;
                    }
                    ++this.i;
                }
                if (this.fontIndex == -1) {
                    int n4 = 0;
                    while (n4 < this.fontStrings.length) {
                        if (this.fontStrings[n4].startsWith("Times-Roman")) {
                            this.fontIndex = n4;
                        }
                        ++n4;
                    }
                }
                string4 = bufferedReader.readLine().substring(2);
                this.fontSize = Double.parseDouble(string4);
                if (!this.graph.directed) {
                    this.i = 0;
                    while (this.i < this.graph.V) {
                        string3 = bufferedReader.readLine().substring(2);
                        n3 = 0;
                        while (n3 <= this.i) {
                            n2 = string3.indexOf(32);
                            if (n2 != -1) {
                                string2 = string3.substring(0, n2);
                                string3 = string3.substring(n2 + 1);
                            } else {
                                string2 = string3;
                            }
                            this.graph.setEdge(this.i, n3, Integer.parseInt(string2));
                            ++n3;
                        }
                        ++this.i;
                    }
                } else {
                    this.i = 0;
                    while (this.i < this.graph.V) {
                        string3 = bufferedReader.readLine().substring(2);
                        n3 = 0;
                        while (n3 < this.graph.V) {
                            n2 = string3.indexOf(32);
                            if (n2 != -1) {
                                string2 = string3.substring(0, n2);
                                string3 = string3.substring(n2 + 1);
                            } else {
                                string2 = string3;
                            }
                            this.graph.setEdge(this.i, n3, Integer.parseInt(string2));
                            ++n3;
                        }
                        ++this.i;
                    }
                }
                this.i = 0;
                while (this.i < this.graph.V) {
                    this.graph.label[this.i] = string4 = bufferedReader.readLine().substring(2);
                    string4 = bufferedReader.readLine().substring(2);
                    int n5 = string4.indexOf(32);
                    String string5 = string4.substring(0, n5);
                    String string6 = string4.substring(n5 + 1);
                    this.graph.Px[this.i] = Double.parseDouble(string5);
                    this.graph.Py[this.i] = Double.parseDouble(string6);
                    ++this.i;
                }
                bufferedReader.close();
                this.selection = new boolean[this.graph.V];
                this.repaint();
                return true;
            }
            catch (Exception exception) {
                this.graph = new Graph(0);
                this.selection = new boolean[0];
                this.repaint();
                return false;
            }
        }
        return true;
    }

    private double vertexSum(Vector2D vector2D) {
        Vector2D vector2D2 = new Vector2D();
        int n = 0;
        while (n < this.graph.V) {
            Vector2D vector2D3 = new Vector2D(vector2D.x - this.graph.Px[n], vector2D.y - this.graph.Py[n]);
            vector2D2 = vector2D2.add(vector2D2, vector2D3);
            ++n;
        }
        return vector2D2.magnitude();
    }

    private Vector2D outwardVector(int n) {
        Vector2D vector2D = new Vector2D();
        int n2 = 0;
        while (n2 < this.graph.V) {
            if (this.graph.G[n * this.graph.V + n2] > 0 || this.graph.G[n2 * this.graph.V + n] > 0) {
                Vector2D vector2D2 = new Vector2D(this.graph.Px[n] - this.graph.Px[n2], this.graph.Py[n] - this.graph.Py[n2]);
                vector2D2.normalize();
                vector2D = vector2D.add(vector2D, vector2D2);
            }
            ++n2;
        }
        vector2D.normalize();
        return vector2D;
    }

    private double minAngle(double d, double d2) {
        double d3;
        double d4;
        while (d < 0.0) {
            d += 360.0;
        }
        while (d2 < 0.0) {
            d2 += 360.0;
        }
        if (d2 < d) {
            double d5 = d;
            d = d2;
            d2 = d5;
        }
        if ((d4 = d2 - d) < (d3 = 360.0 - d4)) {
            return d4;
        }
        return d3;
    }

    public void paintComponent(Graphics graphics) {
        Vector2D vector2D;
        Object object;
        Vector2D vector2D2;
        Object object2;
        Object object3;
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        super.paintComponent(graphics);
        this.g2 = (Graphics2D)graphics;
        this.g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.lineWidth < 1.0) {
            this.g2.setStroke(new BasicStroke(1.0f));
        } else {
            this.g2.setStroke(new BasicStroke((float)this.lineWidth));
        }
        this.g2.setPaint(Color.white);
        this.g2.fill(new Rectangle2D.Double(0.0, 0.0, 400.0, 400.0));
        this.g2.setPaint(Color.black);
        if (this.graph.directed) {
            this.i = 0;
            while (this.i < this.graph.V) {
                n5 = 0;
                while (n5 < this.graph.V) {
                    if (this.graph.nEdges(this.i, n5) > 0) {
                        Object object4;
                        Object object5;
                        Object object6;
                        n4 = this.graph.cx(this.i);
                        n3 = this.graph.cx(n5);
                        n2 = this.graph.cy(this.i);
                        n = this.graph.cy(n5);
                        if (this.i == n5) {
                            int n6 = 0;
                            while (n6 < this.graph.nEdges(this.i, n5)) {
                                object3 = new Vector2D();
                                Vector2D vector2D3 = new Vector2D();
                                object2 = new int[3];
                                object6 = new int[3];
                                vector2D2 = this.outwardVector(this.i);
                                double d = this.dotSize * 6.0 + (double)n6 * this.dotSize * 1.25;
                                if (vector2D2.zero()) {
                                    vector2D2.y = 1.0;
                                    vector2D2.x = 1.0;
                                    vector2D2.normalize();
                                }
                                object5 = new Vector2D(n4, n2);
                                object = new Vector2D((double)n4 + vector2D2.x * d, (double)n2 + vector2D2.y * d);
                                this.g2.draw(new Ellipse2D.Double(((Vector2D)object).x - d, ((Vector2D)object).y - d, d * 2.0, d * 2.0));
                                object3 = ((Vector2D)object3).subtract((Vector2D)object5, (Vector2D)object);
                                ((Vector2D)object3).rotate(this.dotSize / d);
                                object3 = ((Vector2D)object3).add((Vector2D)object3, (Vector2D)object);
                                object2[0] = (int)((Vector2D)object3).x;
                                object6[0] = (int)((Vector2D)object3).y;
                                object3 = ((Vector2D)object3).subtract((Vector2D)object5, (Vector2D)object);
                                ((Vector2D)object3).rotate((this.dotSize * 2.5 + this.dotSize) / d);
                                object3 = ((Vector2D)object3).add((Vector2D)object3, (Vector2D)object);
                                vector2D3 = vector2D3.subtract((Vector2D)object5, (Vector2D)object3);
                                vector2D3.orthogonalize();
                                vector2D3.normalize();
                                vector2D3.scalar(this.dotSize * 1.125);
                                object2[1] = (int)(((Vector2D)object3).x - vector2D3.x);
                                object6[1] = (int)(((Vector2D)object3).y - vector2D3.y);
                                object2[2] = (int)(((Vector2D)object3).x + vector2D3.x);
                                object6[2] = (int)(((Vector2D)object3).y + vector2D3.y);
                                object4 = new GeneralPath(0, 3);
                                ((Path2D.Float)object4).moveTo((float)object2[0], object6[0]);
                                ((Path2D.Float)object4).lineTo((float)object2[1], object6[1]);
                                ((Path2D.Float)object4).lineTo((float)object2[2], object6[2]);
                                ((Path2D)object4).closePath();
                                this.g2.fill((Shape)object4);
                                ++n6;
                            }
                        } else {
                            Vector2D vector2D4 = new Vector2D(n3 - n4, n - n2);
                            vector2D2 = new Vector2D(n3 - n4, n - n2);
                            vector2D4.orthogonalize();
                            vector2D4.normalize();
                            vector2D4.scalar(this.dotSize * 1.125);
                            vector2D2.normalize();
                            vector2D2.scalar(this.dotSize * 2.5 + this.dotSize);
                            object5 = new int[3];
                            object = new int[3];
                            object5[0] = (int)((double)n3 - vector2D2.x - vector2D4.x);
                            object[0] = (int)((double)n - vector2D2.y - vector2D4.y);
                            object5[1] = (int)((double)n3 - vector2D2.x + vector2D4.x);
                            object[1] = (int)((double)n - vector2D2.y + vector2D4.y);
                            vector2D2.normalize();
                            vector2D2.scalar(this.dotSize);
                            object5[2] = (int)((double)n3 - vector2D2.x);
                            object[2] = (int)((double)n - vector2D2.y);
                            object3 = new GeneralPath(0, 3);
                            ((Path2D.Float)object3).moveTo(object5[0], (float)object[0]);
                            ((Path2D.Float)object3).lineTo(object5[1], (float)object[1]);
                            ((Path2D.Float)object3).lineTo(object5[2], (float)object[2]);
                            ((Path2D)object3).closePath();
                            this.g2.fill((Shape)object3);
                            if (this.graph.nEdges(n5, this.i) == 0) {
                                this.g2.draw(new Line2D.Double(n4, n2, n3, n));
                            } else if (this.i < n5) {
                                this.g2.draw(new Line2D.Double(n4, n2, n3, n));
                            }
                            int n7 = 1;
                            while (n7 < this.graph.nEdges(this.i, n5)) {
                                Vector2D vector2D5;
                                Vector2D vector2D6 = new Vector2D(n4, n2);
                                vector2D = new Vector2D(n3, n);
                                vector2D4 = new Vector2D();
                                vector2D4 = vector2D4.subtract(vector2D, vector2D6);
                                vector2D4.scalar(0.5);
                                double d = vector2D4.magnitude();
                                double d2 = d * (double)n7 / (double)this.graph.nEdges(this.i, n5);
                                double d3 = (d * d + d2 * d2) / (2.0 * d2);
                                double d4 = d3 - d2;
                                vector2D2 = vector2D4.orthogonal();
                                vector2D2.normalize();
                                vector2D2.scalar(d4);
                                object2 = new Vector2D(vector2D6.x + vector2D4.x + vector2D2.x, vector2D6.y + vector2D4.y + vector2D2.y);
                                object6 = new Vector2D(vector2D6.x + vector2D4.x - vector2D2.x, vector2D6.y + vector2D4.y - vector2D2.y);
                                double d5 = this.vertexSum((Vector2D)object2);
                                double d6 = this.vertexSum((Vector2D)object6);
                                if (this.i > n5 ^ d5 < d6) {
                                    object2 = object6;
                                }
                                object4 = new Vector2D();
                                Vector2D vector2D7 = new Vector2D();
                                object4 = ((Vector2D)object4).subtract(vector2D6, (Vector2D)object2);
                                vector2D7 = vector2D7.subtract(vector2D, (Vector2D)object2);
                                double d7 = ((Vector2D)object4).angle();
                                double d8 = vector2D7.angle();
                                double d9 = this.minAngle(d7, d8);
                                double d10 = ((Vector2D)object4).magnitude();
                                this.g2.setPaint(Color.black);
                                if (this.i > n5 ^ d5 < d6) {
                                    this.g2.draw(new Arc2D.Double(object2.x - d10, object2.y - d10, d10 * 2.0, d10 * 2.0, d8, d9, 0));
                                } else {
                                    this.g2.draw(new Arc2D.Double(object2.x - d10, object2.y - d10, d10 * 2.0, d10 * 2.0, d7, d9, 0));
                                }
                                float f = d5 < d6 ? 1.0f : -1.0f;
                                if (this.i > n5) {
                                    vector2D5 = vector2D;
                                    f = -f;
                                } else {
                                    vector2D5 = vector2D;
                                }
                                Object object7 = object2;
                                Vector2D vector2D8 = new Vector2D();
                                Vector2D vector2D9 = new Vector2D();
                                vector2D8 = vector2D8.subtract(vector2D5, (Vector2D)object7);
                                vector2D8.rotate((double)f * this.dotSize / d10);
                                vector2D8 = vector2D8.add(vector2D8, (Vector2D)object7);
                                object5[0] = (int)vector2D8.x;
                                object[0] = (int)vector2D8.y;
                                vector2D8 = vector2D8.subtract(vector2D5, (Vector2D)object7);
                                vector2D8.rotate((double)f * (this.dotSize * 2.5 + this.dotSize) / d10);
                                vector2D8 = vector2D8.add(vector2D8, (Vector2D)object7);
                                vector2D9 = vector2D9.subtract(vector2D5, vector2D8);
                                vector2D9.orthogonalize();
                                vector2D9.normalize();
                                vector2D9.scalar(this.dotSize * 1.125);
                                object5[1] = (int)(vector2D8.x - vector2D9.x);
                                object[1] = (int)(vector2D8.y - vector2D9.y);
                                object5[2] = (int)(vector2D8.x + vector2D9.x);
                                object[2] = (int)(vector2D8.y + vector2D9.y);
                                object3 = new GeneralPath(0, 3);
                                ((Path2D.Float)object3).moveTo(object5[0], (float)object[0]);
                                ((Path2D.Float)object3).lineTo(object5[1], (float)object[1]);
                                ((Path2D.Float)object3).lineTo(object5[2], (float)object[2]);
                                ((Path2D)object3).closePath();
                                this.g2.fill((Shape)object3);
                                ++n7;
                            }
                        }
                    }
                    ++n5;
                }
                ++this.i;
            }
        } else {
            this.i = 0;
            while (this.i < this.graph.V) {
                n5 = this.i;
                while (n5 < this.graph.V) {
                    if (this.graph.nEdges(this.i, n5) > 0) {
                        int n8;
                        n4 = this.graph.cx(this.i);
                        n3 = this.graph.cx(n5);
                        n2 = this.graph.cy(this.i);
                        n = this.graph.cy(n5);
                        if (this.i == n5) {
                            n8 = 0;
                            while (n8 < this.graph.nEdges(this.i, n5)) {
                                vector2D2 = this.outwardVector(this.i);
                                double d = this.dotSize * 6.0 + (double)n8 * this.dotSize * 1.25;
                                if (vector2D2.zero()) {
                                    vector2D2.y = 1.0;
                                    vector2D2.x = 1.0;
                                    vector2D2.normalize();
                                }
                                this.g2.draw(new Ellipse2D.Double((double)n4 - d * (1.0 - vector2D2.x), (double)n2 - d * (1.0 - vector2D2.y), d * 2.0, d * 2.0));
                                ++n8;
                            }
                        } else {
                            this.g2.draw(new Line2D.Double(n4, n2, n3, n));
                            if (this.graph.nEdges(this.i, n5) > 1) {
                                n8 = 1;
                                while (n8 < this.graph.nEdges(this.i, n5)) {
                                    object = new Vector2D(n4, n2);
                                    object3 = new Vector2D(n3, n);
                                    vector2D2 = new Vector2D();
                                    vector2D2 = vector2D2.subtract((Vector2D)object3, (Vector2D)object);
                                    vector2D2.scalar(0.5);
                                    double d = vector2D2.magnitude();
                                    double d11 = d * (double)n8 / (double)this.graph.nEdges(this.i, n5);
                                    double d12 = (d * d + d11 * d11) / (2.0 * d11);
                                    double d13 = d12 - d11;
                                    Vector2D vector2D10 = vector2D2.orthogonal();
                                    vector2D10.normalize();
                                    vector2D10.scalar(d13);
                                    Vector2D vector2D11 = new Vector2D(((Vector2D)object).x + vector2D2.x + vector2D10.x, ((Vector2D)object).y + vector2D2.y + vector2D10.y);
                                    Vector2D vector2D12 = new Vector2D(((Vector2D)object).x + vector2D2.x - vector2D10.x, ((Vector2D)object).y + vector2D2.y - vector2D10.y);
                                    double d14 = this.vertexSum(vector2D11);
                                    double d15 = this.vertexSum(vector2D12);
                                    if (d14 >= d15) {
                                        vector2D11 = vector2D12;
                                    }
                                    vector2D = new Vector2D();
                                    object2 = new Vector2D();
                                    vector2D = vector2D.subtract((Vector2D)object, vector2D11);
                                    object2 = object2.subtract((Vector2D)object3, vector2D11);
                                    double d16 = vector2D.angle();
                                    double d17 = object2.angle();
                                    double d18 = this.minAngle(d16, d17);
                                    double d19 = vector2D.magnitude();
                                    this.g2.setPaint(Color.black);
                                    if (d14 >= d15) {
                                        this.g2.draw(new Arc2D.Double(vector2D11.x - d19, vector2D11.y - d19, d19 * 2.0, d19 * 2.0, d17, d18, 0));
                                    } else {
                                        this.g2.draw(new Arc2D.Double(vector2D11.x - d19, vector2D11.y - d19, d19 * 2.0, d19 * 2.0, d16, d18, 0));
                                    }
                                    ++n8;
                                }
                            }
                        }
                    }
                    ++n5;
                }
                ++this.i;
            }
        }
        Font font = new Font(this.fontStrings[this.fontIndex], 0, (int)this.fontSize);
        this.g2.setFont(font);
        FontMetrics fontMetrics = this.g2.getFontMetrics();
        this.i = 0;
        while (this.i < this.graph.V) {
            n = this.graph.cx(this.i);
            int n9 = this.graph.cy(this.i);
            if (this.selection[this.i]) {
                this.g2.setPaint(Color.blue);
            } else {
                this.g2.setPaint(Color.black);
            }
            this.g2.fill(new Ellipse2D.Double((double)n - this.dotSize, (double)n9 - this.dotSize, this.dotSize * 2.0, this.dotSize * 2.0));
            vector2D2 = new Vector2D();
            vector2D2 = this.outwardVector(this.i);
            if (vector2D2.zero()) {
                vector2D2.y = 1.0;
            }
            vector2D2.scalar(this.fontSize);
            Vector2D vector2D13 = vector2D2.normal();
            n2 = fontMetrics.stringWidth(this.graph.label[this.i]);
            n3 = fontMetrics.getAscent();
            this.g2.drawString(this.graph.label[this.i], (int)((double)n + vector2D2.x + (vector2D13.x - 1.0) * ((double)n2 / 2.0)), (int)((double)n9 + vector2D2.y + (vector2D13.y + 1.0) * ((double)n3 / 2.0)));
            ++this.i;
        }
        if (this.boxPick) {
            int n10;
            int n11;
            int n12;
            this.g2.setPaint(Color.green);
            if (this.startX < this.Mx) {
                n = this.startX;
                n12 = this.Mx;
            } else {
                n = this.Mx;
                n12 = this.startX;
            }
            if (this.startY < this.My) {
                n11 = this.startY;
                n10 = this.My;
            } else {
                n11 = this.My;
                n10 = this.startY;
            }
            this.g2.draw(new Rectangle2D.Double(n, n11, (double)n12 - (double)n, (double)n10 - (double)n11));
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.Mx = this.startX = mouseEvent.getX();
        this.My = this.startY = mouseEvent.getY();
        this.startG = new Graph(this.graph.V);
        this.i = 0;
        while (this.i < this.graph.V) {
            this.startG.Px[this.i] = this.graph.Px[this.i];
            this.startG.Py[this.i] = this.graph.Py[this.i];
            ++this.i;
        }
        this.pick = this.graph.pick(this.Mx, this.My);
        if (mouseEvent.isShiftDown()) {
            if (this.pick == -1) {
                this.boxPick = true;
            } else {
                this.selection[this.pick] = !this.selection[this.pick];
            }
            this.edgeStep = 0;
        } else if (mouseEvent.getModifiers() == 4 || mouseEvent.getModifiers() == 8 || mouseEvent.isMetaDown()) {
            if (this.pick == -1) {
                this.selection = new boolean[this.graph.V + 1];
                if (this.gridOn) {
                    this.pick = this.graph.pick((int)(Math.rint((double)this.Mx / (double)this.gridX) * (double)this.gridX), (int)(Math.rint((double)this.My / (double)this.gridY) * (double)this.gridY));
                    if (this.pick == -1) {
                        this.selection[this.graph.addVertex((double)(Math.rint((double)((double)this.Mx / (double)this.gridX)) * (double)this.gridX), (double)(Math.rint((double)((double)this.My / (double)this.gridY)) * (double)this.gridY))] = true;
                    }
                } else {
                    this.selection[this.graph.addVertex((double)((double)this.Mx), (double)((double)this.My))] = true;
                }
            } else if (this.graph.V > 0) {
                this.graph.removeVertex(this.pick);
                this.i = this.pick;
                while (this.i < this.graph.V) {
                    this.selection[this.i] = this.selection[this.i + 1];
                    ++this.i;
                }
                this.edgeStep = 0;
                this.pick = -1;
                this.boxPick = false;
            }
        } else if (this.pick == -1) {
            this.boxPick = true;
            this.edgeStep = 0;
        } else {
            this.drag = true;
            if (!this.selection[this.pick]) {
                this.i = 0;
                while (this.i < this.graph.V) {
                    this.selection[this.i] = false;
                    ++this.i;
                }
                this.selection[this.pick] = true;
            }
            if (this.edgeStep == 0) {
                this.edgev1 = this.pick;
                this.edgeStep = 1;
            } else {
                this.edgev2 = this.pick;
                if (this.edgev1 != this.edgev2) {
                    if (mouseEvent.isControlDown()) {
                        this.graph.setEdge(this.edgev1, this.edgev2, 1);
                    } else if (this.graph.nEdges(this.edgev1, this.edgev2) > 0) {
                        this.graph.setEdge(this.edgev1, this.edgev2, -1);
                    } else {
                        this.graph.setEdge(this.edgev1, this.edgev2, 1);
                    }
                    this.edgeStep = 0;
                    this.selection[this.pick] = false;
                } else {
                    this.selfEdge = true;
                }
            }
        }
        this.repaint();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        int n = 0;
        this.Mx = mouseEvent.getX();
        this.My = mouseEvent.getY();
        this.i = 0;
        while (this.i < this.graph.V) {
            if (this.selection[this.i]) {
                ++n;
            }
            ++this.i;
        }
        if (this.drag) {
            this.i = 0;
            while (this.i < this.graph.V) {
                if (this.selection[this.i]) {
                    if (this.gridOn) {
                        if (n > 1) {
                            int n2 = (int)(Math.rint((double)this.Mx / (double)this.gridX) * (double)this.gridX);
                            int n3 = (int)(Math.rint((double)this.My / (double)this.gridY) * (double)this.gridY);
                            this.graph.setCoord(this.i, (int)((double)(n2 - this.startX) + this.startG.Px[this.i]), (int)((double)(n3 - this.startY) + this.startG.Py[this.i]));
                        } else {
                            this.graph.setCoord(this.i, (int)((double)(this.Mx - this.startX) + this.startG.Px[this.i]) / this.gridX * this.gridX, (int)((double)(this.My - this.startY) + this.startG.Py[this.i]) / this.gridY * this.gridY);
                        }
                    } else {
                        this.graph.setCoord(this.i, (int)((double)(this.Mx - this.startX) + this.startG.Px[this.i]), (int)((double)(this.My - this.startY) + this.startG.Py[this.i]));
                    }
                }
                ++this.i;
            }
        }
        this.repaint();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.boxPick) {
            if (mouseEvent.isShiftDown()) {
                boolean[] blArray = new boolean[this.graph.V];
                boolean[] blArray2 = this.selection;
                blArray = this.graph.boxPick(this.startX, this.startY, this.Mx, this.My);
                this.i = 0;
                while (this.i < this.graph.V) {
                    this.selection[this.i] = blArray2[this.i] && !blArray[this.i] || blArray[this.i] && !blArray2[this.i];
                    ++this.i;
                }
            } else {
                this.selection = this.graph.boxPick(this.startX, this.startY, this.Mx, this.My);
            }
            this.boxPick = false;
        } else if (this.Mx == this.startX && this.My == this.startY) {
            if (this.selfEdge && this.edgeStep == 1) {
                if (mouseEvent.isControlDown()) {
                    this.graph.setEdge(this.edgev1, this.edgev2, 1);
                } else if (this.graph.nEdges(this.edgev1, this.edgev2) > 0) {
                    this.graph.setEdge(this.edgev1, this.edgev2, -1);
                } else {
                    this.graph.setEdge(this.edgev1, this.edgev2, 1);
                }
                this.edgeStep = 0;
                this.selfEdge = false;
                this.selection[this.pick] = false;
            } else if (!mouseEvent.isShiftDown() && this.edgeStep == 1 && this.pick != -1) {
                this.i = 0;
                while (this.i < this.graph.V) {
                    this.selection[this.i] = false;
                    ++this.i;
                }
                this.selection[this.pick] = true;
            }
        } else {
            this.edgeStep = 0;
            this.selfEdge = false;
        }
        this.drag = false;
        this.repaint();
    }

    public void keyTyped(KeyEvent keyEvent) {
        this.repaint();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }
}

