/*
 * Decompiled with CFR 0.152.
 */
public class Graph {
    public int V;
    public int E;
    public int[] G;
    public double[] Px;
    public double[] Py;
    public double pickCheckRadius;
    public boolean directed;
    public String[] label;

    public Graph(int n) {
        this.V = n;
        this.G = new int[this.V * this.V];
        this.Px = new double[this.V];
        this.Py = new double[this.V];
        this.label = new String[this.V];
        int n2 = 0;
        while (n2 < this.V * this.V) {
            this.G[n2] = 0;
            ++n2;
        }
        n2 = 0;
        while (n2 < this.V) {
            this.Px[n2] = 150.0 * Math.cos((double)n2 * 2.0 * Math.PI / (double)this.V) + 200.0;
            this.Py[n2] = 150.0 * Math.sin((double)n2 * 2.0 * Math.PI / (double)this.V) + 200.0;
            this.label[n2] = " ";
            ++n2;
        }
        this.pickCheckRadius = 4.0;
    }

    public boolean setCoord(int n, double d, double d2) {
        if (n < 0 || n > this.V - 1) {
            return false;
        }
        this.Px[n] = d;
        this.Py[n] = d2;
        return true;
    }

    public boolean setLabel(int n, String string) {
        if (n < 0 || n > this.V - 1) {
            return false;
        }
        this.label[n] = string;
        return true;
    }

    public void makeDirected() {
        this.directed = true;
    }

    public void makeUndirected() {
        this.directed = false;
        int n = 0;
        while (n < this.V) {
            int n2 = n;
            while (n2 < this.V) {
                int n3 = this.G[n * this.V + n2] + this.G[n2 * this.V + n];
                this.G[n2 * this.V + n] = n3;
                this.G[n * this.V + n2] = n3;
                ++n2;
            }
            ++n;
        }
        int n4 = 0;
        while (n4 < this.V) {
            int n5 = n4 * this.V + n4;
            this.G[n5] = this.G[n5] / 2;
            ++n4;
        }
    }

    public boolean setEdge(int n, int n2, int n3) {
        if (n < 0 || n > this.V - 1 || n2 < 0 || n2 > this.V - 1) {
            return false;
        }
        int n4 = n * this.V + n2;
        this.G[n4] = this.G[n4] + n3;
        if (!this.directed && n != n2) {
            int n5 = n2 * this.V + n;
            this.G[n5] = this.G[n5] + n3;
        }
        return true;
    }

    public void flipEdges(int n, int n2) {
        int n3 = this.G[n * this.V + n2];
        this.G[n * this.V + n2] = this.G[n2 * this.V + n];
        this.G[n2 * this.V + n] = n3;
    }

    public int nEdges(int n, int n2) {
        if (n < 0 || n > this.V - 1 || n2 < 0 || n2 > this.V - 1) {
            return -1;
        }
        return this.G[n * this.V + n2];
    }

    public int cx(int n) {
        if (n < 0 || n > this.V - 1) {
            return -1;
        }
        return (int)this.Px[n];
    }

    public int cy(int n) {
        if (n < 0 || n > this.V - 1) {
            return -1;
        }
        return (int)this.Py[n];
    }

    public int pick(int n, int n2) {
        if (this.V == 0) {
            return -1;
        }
        double d = n;
        double d2 = n2;
        int n3 = 0;
        double d3 = Math.sqrt((d - this.Px[0]) * (d - this.Px[0]) + (d2 - this.Py[0]) * (d2 - this.Py[0]));
        int n4 = 0;
        while (n4 < this.V) {
            double d4 = Math.sqrt((d - this.Px[n4]) * (d - this.Px[n4]) + (d2 - this.Py[n4]) * (d2 - this.Py[n4]));
            if (d4 < d3) {
                d3 = d4;
                n3 = n4;
            }
            ++n4;
        }
        if (d3 < this.pickCheckRadius + 6.0) {
            return n3;
        }
        return -1;
    }

    public boolean[] boxPick(int n, int n2, int n3, int n4) {
        int n5;
        boolean[] blArray = new boolean[this.V];
        if (n3 < n) {
            n5 = n;
            n = n3;
            n3 = n5;
        }
        if (n4 < n2) {
            n5 = n2;
            n2 = n4;
            n4 = n5;
        }
        int n6 = 0;
        while (n6 < this.V) {
            if (this.Px[n6] > (double)n && this.Px[n6] < (double)n3 && this.Py[n6] > (double)n2 && this.Py[n6] < (double)n4) {
                blArray[n6] = true;
            }
            ++n6;
        }
        return blArray;
    }

    public int addVertex(double d, double d2) {
        int[] nArray = new int[this.V * this.V];
        double[] dArray = new double[this.V];
        double[] dArray2 = new double[this.V];
        String[] stringArray = new String[this.V];
        int n = 0;
        while (n < this.V * this.V) {
            nArray[n] = this.G[n];
            ++n;
        }
        n = 0;
        while (n < this.V) {
            dArray[n] = this.Px[n];
            dArray2[n] = this.Py[n];
            stringArray[n] = this.label[n];
            ++n;
        }
        ++this.V;
        this.G = new int[this.V * this.V];
        this.Px = new double[this.V];
        this.Py = new double[this.V];
        this.label = new String[this.V];
        n = 0;
        while (n < this.V * this.V) {
            this.G[n] = 0;
            ++n;
        }
        n = 0;
        while (n < this.V - 1) {
            int n2 = 0;
            while (n2 < this.V - 1) {
                this.G[n + n2 * this.V] = nArray[n + n2 * (this.V - 1)];
                this.G[n2 + n * this.V] = nArray[n2 + n * (this.V - 1)];
                ++n2;
            }
            ++n;
        }
        n = 0;
        while (n < this.V - 1) {
            this.Px[n] = dArray[n];
            this.Py[n] = dArray2[n];
            this.label[n] = stringArray[n];
            ++n;
        }
        this.Px[this.V - 1] = d;
        this.Py[this.V - 1] = d2;
        this.label[this.V - 1] = " ";
        return this.V - 1;
    }

    public void removeVertex(int n) {
        int[] nArray = new int[this.V * this.V];
        double[] dArray = new double[this.V];
        double[] dArray2 = new double[this.V];
        String[] stringArray = new String[this.V];
        int n2 = 0;
        while (n2 < this.V * this.V) {
            nArray[n2] = this.G[n2];
            ++n2;
        }
        n2 = 0;
        while (n2 < this.V) {
            dArray[n2] = this.Px[n2];
            dArray2[n2] = this.Py[n2];
            stringArray[n2] = this.label[n2];
            ++n2;
        }
        --this.V;
        this.G = new int[this.V * this.V];
        this.Px = new double[this.V];
        this.Py = new double[this.V];
        this.label = new String[this.V];
        n2 = 0;
        while (n2 < this.V * this.V) {
            this.G[n2] = 0;
            ++n2;
        }
        int n3 = 0;
        n2 = 0;
        while (n2 < this.V) {
            if (n3 == n) {
                ++n3;
            }
            int n4 = 0;
            int n5 = 0;
            while (n5 < this.V) {
                if (n4 == n) {
                    ++n4;
                }
                this.G[n2 + n5 * this.V] = nArray[n3 + n4 * (this.V + 1)];
                this.G[n5 + n2 * this.V] = nArray[n4 + n3 * (this.V + 1)];
                ++n4;
                ++n5;
            }
            ++n3;
            ++n2;
        }
        n3 = 0;
        n2 = 0;
        while (n2 < this.V) {
            if (n3 == n) {
                ++n3;
            }
            this.Px[n2] = dArray[n3];
            this.Py[n2] = dArray2[n3];
            this.label[n2] = stringArray[n3];
            ++n3;
            ++n2;
        }
    }
}

