/*
 * @(#)Iterable.java	1.5 06/04/07
 *
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 * SUN PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package java.lang;

import java.util.Iterator;

import edu.cmu.cs.plural.annot.Cases;
import edu.cmu.cs.plural.annot.Capture;
import edu.cmu.cs.plural.annot.Perm;
import edu.cmu.cs.plural.annot.States;

/** Implementing this interface allows an object to be the target of
 *  the "foreach" statement.
 * @since 1.5
 */
@States(dim = "structure", value = {"empty", "nonEmpty"})
public interface Iterable<T> {

    /**
     * Returns an iterator over a set of elements of type T.
     * 
     * @return an Iterator.
     */
	@Cases({
//		@Perm(requires = "full(this) in nonEmpty", ensures = "unique(result) in available, modifying"),
//		@Perm(requires = "full(this) in empty", ensures = "unique(result) in end, modifying"),
		@Perm(requires = "full(this)", ensures = "unique(result) in modifying"),
//		@Perm(requires = "immutable(this) in nonEmpty", ensures = "unique(result) in available, readonly"),
//		@Perm(requires = "immutable(this) in empty", ensures = "unique(result) in end, readonly"),
		@Perm(requires = "immutable(this)", ensures = "unique(result) in readonly")
	})
	@Capture(param = "coll")
    Iterator<T> iterator();
}
