function MMG_demo
%
%***************************************************************************
%                              MMG_demo
%   This source code is (c) Copyright 2004 by Jia-Yu (Tim) Pan 
%   (Computer Science Department, Carnegie Mellon University).
%   It may not be redistributed without the express consent of the
%   author.
%
%   Descriptions on the method MMG can be found in the following
%   papers:
%
%   Jia-Yu Pan, Hyung-Jeong Yang, Christos Faloutsos, and Pinar Duygulu.
%   Automatic Multimedia Cross-modal Correlation Discovery. 
%   In Proceedings of the 10th ACM SIGKDD Conference, 2004.
%   Seattle, WA, August 22-25, 2004
%
%   Jia-Yu Pan, Hyung-Jeong Yang, Christos Faloutsos, and Pinar Duygulu. 
%   GCap: Graph-based Automatic Image Captioning. 
%   In Proceedings of the 4th International Workshop on Multimedia
%   Data and Document Engineering (MDDE 04), in conjunction with
%   Computer Vision Pattern Recognition Conference (CVPR 04), 2004.
%   Washington DC, July 2nd 2004
%
%***************************************************************************


%

%%% Parameters setting
setID = '001';
K = 3;
c = 0.65;

testK = K; % testing-NN
maxIter = 80;
tolerance = 10^(-9);

%%% Directory setting
out_dir = 'result/';

%-----------------------------------------------------------------------------
% Read graph

graph_MAT_file = 'demo_data/graph/001_trnK3_graph.mat';

load(graph_MAT_file);
% this gives 'A' and 'dims=[nRB, nIs, nW]'
disp('Done bringing graph.');

% self-check
[rA, cA] = size(A);
if(rA ~= cA), disp('Non-square A'), return, end
if(rA ~= sum(dims)), disp('Inconsistent dimension'), return, end


%---------------- Read test data 
test_data_dir = 'demo_data/test_data/';

test_docWord_file = [test_data_dir, 'test_1_document_words'];
%%% Correct answer

test_docRawBlob_file = [test_data_dir, 'test_1_document_blobs'];
topNN_testBlob_file = 'demo_data/NN/001_NNmax20_labels.txt';
wordString_file = [test_data_dir, 'words'];



Trb = importdata(test_docRawBlob_file); % Trb: Test raw blob
[nTest, rb_perT] = size(Trb); % nTest: number of test images

TNN = importdata(topNN_testBlob_file);
[nTrb, rbNN_perTrb] = size(TNN);  % rbNN_perTrb: raw blob's nearest neighbors

Tw = importdata(test_docWord_file); % Tw: Test words (the correct answer)
nTest1 = size(Tw,1);

if(nTest1 ~= nTest), disp('Inconsistent test samples.'), return, end
% self-check

wStrs = importdata(wordString_file); 
% the caption terms "tiger", "lion", etc.

%------------------------------------------------------------------------
% Prepare output file

prediction_MAT_file = ...
    sprintf('%s%s_c%.2f_trnK%d_tstK%d_maxIter%d.mat', ...
	    out_dir, setID, c, K, testK, maxIter);

%prediction_MAT_file

%------------------------------------------------------------------------------
allIteration=[];

allAccuracy=[]; % pinar's measurement: 
		% same #prediictions as the correct answer

nPredicts = [4, 5, 6, 8, 10, 20];
allPrecision=[];
allRecall=[];

allCaption=[];

%nTest=10; % rewrite the number of test images

fprintf('Number of test images: %d\n', nTest);
for i=1:nTest
  blobs_in_image = Trb(i, :);
  % the test regions
  
  blobs_in_image = blobs_in_image(blobs_in_image > 0);
  % remove -99
  
  prefer_NN_trn_blobs = TNN(blobs_in_image, 1:testK); 
  
  [rr, cc] = size(prefer_NN_trn_blobs);
  % get the (train-blob) NNs of test blobs
  
  % Note: 
  % (1) If test blobs have the same train-blob NNs, those NNs are
  % count multiple times.
  % 
  
  nNodes = sum(dims);
  
  % Note: 
  % The nodeIDs of the blobs, start from 1, i.e., blobID==nodeID.
  % 

  %
  % Augment a test image to the graph
  %
  B=[];
  B=A; % B is the augmented graph (sparse, adjacent matrix)
  
  % expand the size of the graph for augmentation
  nTestRegions = rr;
  nNodes=rA+nTestRegions+1;
  
  % self-check: we assume test regions are different.
  if(nTestRegions ~= length(unique(blobs_in_image)))
    disp('There are duplicate test region IDs.'); return;
  end

  B(nNodes,1)=0;
  B(1,nNodes)=0;
  
  for j1=1:rr    % rr==nTestRegions
    for j2=1:cc  % cc == testK
      B(rA+j1, prefer_NN_trn_blobs(j1,j2)) = ...
	  B(rA+j1, prefer_NN_trn_blobs(j1,j2))+1;

      B(prefer_NN_trn_blobs(j1,j2), rA+j1) = ...
	  B(prefer_NN_trn_blobs(j1,j2), rA+j1)+1;
    end
    
    B(rA+j1, nNodes) = B(rA+j1, nNodes) + 1;
    B(nNodes, rA+j1) = B(nNodes, rA+j1) + 1;
    
  end

  % Normalization => column sum to 1
  for j=1:nNodes
    B(:,j) = B(:,j) ./ sum(B(:,j));
    %sum(B(:,j))
    %pause
  end
  
  restart_vector = sparse(nNodes, 1, 1, ...
			  nNodes, 1);

  
  %nonzeros(restart_vector), pause
  
  disp(['Doing RWR: (test image: ', int2str(i), ')']);
  [r, realIter] = ppr_i1(B, c, restart_vector, maxIter, tolerance);
  disp('Done RWR.');
  
  % check result
  %
  wPart = r((dims(1)+dims(2)+1):(dims(1)+dims(2)+dims(3)), 1);
  
  [V, I] = sort(wPart); % ascending order
  V = flipud(V); % descending order
  I = flipud(I); % descending order


  % get correct answer
  answer = Tw(i,:);
  answer = answer(answer>0); % remove -99
  %answer
  
  nAnnotation = length(answer);

  allCaption(i).data = I(1:nAnnotation)';
  
  
  fprintf('Annotate words: ');
  fprintf('%d ', I(1:nAnnotation));
  wStrs(I(1:nAnnotation))'
  fprintf('\n');

  fprintf('Relative score: ');
  fprintf('%g ', full(V(1:nAnnotation)));
  fprintf('\n');

  fprintf('Correct answer: ');
  fprintf('%d ', answer);
  wStrs(answer)'
  fprintf('\n');
  
  correct_prediction = intersect(answer, I(1:nAnnotation));
  accuracy = length(correct_prediction)/nAnnotation;
  fprintf('This prediction accuracy: %f\n', accuracy);
  
  allAccuracy(i) = accuracy;
  allIteration(i) = realIter;
  
  fprintf('Summary (so far):\n');
  fprintf('avg now: %f\n', mean(allAccuracy));
  
  %%% Precision/Recall
  for j=1:length(nPredicts)
    correct_prediction = intersect(answer, I(1:nPredicts(j)));
    allPrecision(i,j) = length(correct_prediction)/nPredicts(j);
    allRecall(i,j) = length(correct_prediction)/length(answer);
  end
  
  fprintf('avg Precis: '); fprintf('%f ', mean(allPrecision,1)); fprintf('\n');
  fprintf('avg Recall: '); fprintf('%f ', mean(allRecall,1)); fprintf('\n');

  fprintf('=========================================\n');
end

avgAccuracy = mean(allAccuracy);
stdAccuracy = std(allAccuracy);

fprintf('Accuracy [avg, std]=[%f,%f]\n', avgAccuracy, stdAccuracy);

save(prediction_MAT_file, 'c', 'K', 'maxIter', 'tolerance', ...
     'allIteration', 'allAccuracy', 'allPrecision', 'allRecall', ...
     'allCaption');

return;


