/* file "ssapre/suif_pass.h" */

/*
    Copyright (c) 2001 The President and Fellows of Harvard College

    All rights reserved.

    This software is provided under the terms described in
    the "machine/copyright.h" include file.
*/

#ifndef SSAPRE_SUIF_PASS_H
#define SSAPRE_SUIF_PASS_H

#include <machine/copyright.h>

#pragma interface "ssapre/suif_pass.h"

#include <machine/pass.h>
#include <machine/machine.h>

#include "ssapre/ssapre.h"

class SSApreSuifPass : public PipelinablePass {
  protected:
    SSApre ssapre;

    // command-line arguments
    int debug_arg;		// debugging message verbosity
    OptionString *file_names;	// names of input and/or output files
    IdString o_fname;		// optional output file name

  public:
    SSApreSuifPass(SuifEnv*, const IdString &name = "ssapre");

    // We only need a single copy of this pass, since we should never
    // need more than one DCE pass in any compiler.
    Module* clone() const { return (Module*)this; }

    void initialize();
    bool parse_command_line(TokenStream *command_line_stream);
    void execute();

    void do_file_set_block(FileSetBlock*);
    void do_file_block(FileBlock*);
    void do_procedure_definition(ProcDef*);

    void finalize()
	{ ssapre.finalize(); }
};

extern "C" void init_ssapre(SuifEnv*);


#endif /* SSAPRE_SUIF_PASS_H */
