#include "ssapre.h"
#include <pair.h>
//#pragma implementation "pre/ssapre.h"
#define DEBUG_PRINT_SSAPRE

int int_compare( const void *x, const void *y ) {
  int a = *((int *)x);
  int b = *((int *)y);
  if( a == b ) return 0;
  return a < b ? -1 : 1;
}

void SSApre::initialize() {
  debug(1, "Debug level is %d", debuglvl );
}

void SSApre::do_opt_unit(OptUnit *unit) {

  CfgNodeHandle graph_iter;
  CfgNode *block;
  InstrHandle block_iter;
  Instr *instr;
  int pos, expr_ct, i;

  map<ExprKey,int> expr_hash;      // Map from sorted list representing
                                   // the expression into index
  Vector<Vector<Occ *> *> occurence_list; // 1st index is expr, 2nd is Occ
  Vector<Vector <int> *> arg_ids_list;     // 1st index is expr, 2nd is arg

  RealOcc *real_occ;


  // Convert unit into conditioned Cfg*
  claim(is_kind_of<Cfg>(get_body(unit)), "Body not in CFG form" );
  Cfg *the_unit_cfg = static_cast<Cfg*>(get_body(unit));
  remove_unreachable_nodes(the_unit_cfg);

  // Build the SSA form.  We use the_unit_cfg b/c build overwrites unit_cfg.
  build( the_unit_cfg, BUILD_USE_DEF_CHAINS | BUILD_DEF_USE_CHAINS |
	 SEMI_PRUNED | PRINT_WARNINGS);
 
  expr_ct = 0;
  // Traverse the CFG, build up lists of occurences of expressions.
  for(graph_iter=start(unit_cfg); graph_iter != end(unit_cfg); graph_iter++) {
    block = *graph_iter;

    pos = 0;
    cerr << "Block is: "; fprint( stderr, block ); cerr << endl;
    for( block_iter = start(block); block_iter != end(block); block_iter++ ) {
      instr = *block_iter;

      cerr << "Instr is: "; fprint(stderr,instr); cerr << endl;
      if( is_interesting_expr( instr ) ) {
	cerr << "Instruction is interesting!" << endl;

	// Generate the real occurence object for it
	real_occ = new RealOcc(instr, pos, this);

	cerr << "Made new Realocc" << endl;

	// Generate an entry in the hash for it
	ExprKey hash_key( old_opnd_catalog, get_opcode(instr), real_occ );

	cerr << "Generated hash_key" << endl;

	// See if it exists, if it doesn't add new list members
	if( expr_hash.find( hash_key ) == expr_hash.end() ) {

	  cerr << "Didn't find hash_key" << endl;

	  expr_hash[hash_key] = expr_ct;

	  // Make a new occurence list for it
	  occurence_list.push_back( new Vector<Occ *> );

	  // Add the args to the args id list
	  arg_ids_list.push_back( hash_key.makeVec() );

	  expr_ct++;
	}

	cerr << "Adding new occurence to occurence_list" << endl;
	// Add the occurence to the appropriate list
	occurence_list[ expr_hash[hash_key] ]->push_back( real_occ );
      }
    }
    pos++;
  }  // Done traversing graph

  debug("Done Traversing Graph.\n");

  // Now that we have lists of interesting expressions, do PRE for
  // each one.
  for( i = 0; i < expr_ct; i++ ) {
    ExprPRE *pre = new ExprPRE( *(arg_ids_list[i]), *(occurence_list[i]), this );
    pre->doPRE();
    delete pre;
  }

  // Done with transformations, delete the lists
  for( i = 0; i < expr_ct; i++ ) {
    delete arg_ids_list[i];
    delete occurence_list[i];
  }
  
}

void SSApre::finalize() {
}

class HasImmOpnd : public OpndFilter {
public:
  bool has_immediate;
  HasImmOpnd() { has_immediate = false; }
  virtual Opnd operator()(Opnd op, InOrOut) {
    has_immediate = has_immediate || is_immed(op);
    return op;
  }
};

bool SSApre::is_interesting_expr( Instr *mi ) {
  if( !reads_memory(mi) &&
      !writes_memory(mi) &&
      !is_builtin(mi) &&
      !is_two_opnd(mi) &&
      is_binary_exp(mi)
      ) {
    HasImmOpnd hio;
    map_src_opnds(mi, hio);
    return !hio.has_immediate;
  }
  return false;
}


ExprPRE::ExprPRE(Vector<int> &ai, Vector<Occ *> &occ, SSApre *ssa) 
  : all(occ), arg_ids(ai), OccStack()
{
  this->ssa = ssa;
  arg_ct = arg_ids.size();
  debug("Instantiated an ExprPRE\n");
  t = opnd_reg(get_type(((RealOcc *)all[0])->old_dst_name()));
  NextVersion = Occ::BOTTOM + 1;
}

void ExprPRE::doPRE() {
  debug("Calling PHI insertion\n");
  do_PHI_insertion();
  debug("Calling Rename_1\n");
  do_Rename_1();
  debug("Calling Rename_2\n");
  do_Rename_2();
  debug("Populating uses table");
  for(int i = 0; i < PHI.size(); i++) {
    PHINode *F = PHI[i];
    for(int j = 0; j < F->num_opnds(); j++) {
      PhiOp *op = (PhiOp *) F->get_opnd(j);
      Occ *def = def_point[op->version];
      uses.insert(pair<Occ *, PhiOp *>(def,op));
    }
  }
  debug("Calling Dead Store Elimination\n");
  do_DeadStoreElim();
  debug("Doing Down Safety\n");
  do_DownSafety();
  debug("Doing Will Be Avail\n");
  do_WillBeAvail();
#ifdef DEBUG_PRINT_SSAPRE
  debug("SSAPRE graph for current expression:\n");
  for(int i = 0; i < all.size(); i++) {
    all[i]->print(stdout);
  }
#endif
  debug("Doing Finalize\n");
  do_Finalize();
  debug("Doing Code Motion\n");
  do_CodeMotion();
  debug("Done with ExprPRE::doPRE()");
}

void RealOcc::print(FILE *f) {
  fprintf(f, "Real occurrence (version %d) in block %d, line %d. Old arg names:", 
	  version, block, pos);
  for(int i = 0; i < nargs; i++) { fprint(f, old_args[i]); fprintf(f, " "); }
  fprintf(f, "\n");
  fprint(f, mi);
}

RealOcc::RealOcc(Instr *mi, int pos, SSApre *ssa) {
  this->mi = mi;
  this->pos = pos;
  nargs = srcs_size(mi);
  old_args = new Opnd[nargs];
  new_args = new Opnd[nargs];
  if(get_parent_node(mi) != NULL) {
    block = get_number(get_parent_node(mi));
  }
  if( is_commutative(mi) ) {
    // Sort arguments into order by old id
    map<int,int> old_id_to_pos;
    int *old_ids = new int[nargs];
    for( int i = 0; i < nargs; i++ ) {
      // This is a very clumsy way to get the old id, is there a better way?
      old_ids[i] = ssa->lookup_old_opnd( ssa->name_map[ ssa->lookup_new_opnd( get_src(mi,i))]);
      old_id_to_pos[old_ids[i]] = i;
    }

    qsort( old_ids, nargs, sizeof(int), int_compare );

    for( int i = 0; i < nargs; i++ ) {
      int index = old_id_to_pos[ old_ids[i] ];
      new_args[i] = get_src(mi,index);
      int id = ssa->lookup_new_opnd(new_args[i]);
      old_args[i] = ssa->name_map[id];
    }

    delete old_ids;

  } else {
    // Take them in the order given
      for(int i = 0; i < nargs; i++) {
      new_args[i] = get_src(mi, i);
      int id = ssa->lookup_new_opnd(new_args[i]);
      old_args[i] = ssa->name_map[id]; 
    }
  }
    
  new_dst = get_dst(mi, 0);
  int id = ssa->lookup_new_opnd(new_dst);
  old_dst = ssa->name_map[id];
  
  version = -2;  // An illegal value

}

RealOcc::~RealOcc() {
  delete old_args;
  delete new_args;
}

Opnd RealOcc::old_arg_name(int pos) {
  return old_args[pos];
}

Opnd RealOcc::new_arg_name(int pos) {
  return new_args[pos];
}

int RealOcc::num_args() {
  return nargs;
}

Opnd RealOcc::new_dst_name() { return new_dst; }

Opnd RealOcc::old_dst_name() { return old_dst; }

PHINode::PHINode(SSApre *ssa, int block) {
  live = false;
  can_be_avail = true;
  later = true;
  down_safe = true;
  this->block = block;
  pos = TOP;

  CfgNode *n = get_node(ssa->unit_cfg, block);

  nopnds = preds_size(n);
  opnds = new Occ*[nopnds];
  for(int i = 0; i < nopnds; i++) {
    opnds[i] = new PhiOp(ssa, this);
    opnds[i]->block = get_number(get_pred(n,i));
  }
}

Occ::Occ() {
  reload = false;
  save = false;
  live = true;
}

PHINode::~PHINode() {
  delete opnds;
}

int PHINode::num_opnds() { return nopnds; }

Occ *PHINode::get_opnd(int i) {
  return opnds[i];
}


PhiOp::PhiOp(SSApre *ssa, PHINode *phi) {
  version = BOTTOM;
  this->phi = phi;
  pos = END;
  has_real_use = false;
}

void PhiOp::print(FILE *f) { 
  return;
}

bool PhiOp::insert(Vector<Occ *> &def_point) {
  debug("called PhiOp::insert(); def_point[%d] = %d\n", version, def_point[version]);
  bool result = (version==BOTTOM) &&
    (phi->will_be_avail() || 
     (!has_real_use && def_point[version]->is_a() == Occ::PHI &&
      !((PHINode*)def_point[version])->will_be_avail()));
  debug("PhiOp::insert() = %d\n", result);
  return result;
}

PHINode *PhiOp::get_phi() {
  return phi;
}

void PHINode::print(FILE *f) {
  fprintf(f, "block %d: %d <- PHI(", block, version);
  for(int i = 0; i < nopnds-1; i++) fprintf(f,"%d(%d), ", opnds[i]->version, opnds[i]->block);
  fprintf(f,"%d(%d)):\n", opnds[nopnds-1]->version, opnds[nopnds-1]->block);
  fprintf(f,"ds=%d\ncba=%d\nlater=%d\nwba=%d\n", down_safe, can_be_avail, later, will_be_avail());
}
