#include "ssapre.h"

bool ExprPRE::real_dom_phi(RealOcc *X, PHINode *PHI) {
  for(int i = 0; i < X->num_args(); i++) {
    Opnd var = X->new_arg_name(i);
    Operation o = ssa->unique_def(var);
    CfgNode *b = NULL;
    if(o.is_instr_handle()) {
      InstrHandle ih = o.get_instr_handle();
      Instr *mi = *ih;
      b = get_parent_node(mi);
    } else {
      PhiNode *phi = o.get_phi_node();
      b = ssa->phi_node_block(phi);
    }
    unsigned n = get_number(b);
    if((n == X->block && o.is_instr_handle()) ||  
       !ssa->dominator_analysis->dominates(n, X->block)) return false;
  }
  return true;
}

void ExprPRE::do_Rename_1() {
  NextVersion = Occ::BOTTOM + 1;
  DominanceChild dc(get_number(get_entry_node(ssa->unit_cfg)));
  def_point.push_back(NULL);

  // Do a preorder traversal of the dominator tree
  preorder_rename( &dc );

}

void ExprPRE::preorder_rename( DominanceChild *block) {
  deque<Occ *> *list;
  Occ *q, *top;
  debug("Called preorder_rename on block %d\n", block->block_number);

  // If we're at the exit, see if we should reset the down_safe flag
  if( block->block_number == get_number(get_exit_node(ssa->unit_cfg))) {
    debug("For some reason. we think we're at the exit\n");
    if(!OccStack.empty()) {
      top = OccStack.top();
      debug("We've got a pointer to the top of the OccStack:%d\n", top);
      // If we can cast to a PHINode, set to false.
      if (top != NULL) {
	debug("top wasn't null so we're going to try casting it to a PHINode.\n");
	PHINode *p;
	if( (p = dynamic_cast<PHINode *>(top)) != NULL ) {
	  debug("the dynamic cast worked.\n");
	  p->down_safe = false;
	}
      }
    }
  }

  debug("Got past this funny business about down_safe\n");

  // Get the list of occurences for this block
  list = occ_for_block[block->block_number];
  if( list != NULL ) {
    debug("There are occurences in this block!\n");
    // Process all the occurences in the block
    for( deque<Occ*>::iterator i = list->begin(); i != list->end(); i++ ) {
      q = *i;
      if(OccStack.empty()) {
	top = NULL;
      } else {
	top = OccStack.top();
      }

      switch( q->is_a() ) {

      case Occ::PHIOP:
	debug("Encountered a PhiOp.\n");
	if( OccStack.empty() ) {
	  // Stack is empty, so the phi operand is bottom
	  q->version = Occ::BOTTOM;
	} else {
	  // Optimistically assume that it's at the top of the stack
	  q->version = top->version;

	  // It only has a real use if the top of the stack is a real
	  // occurrence
	  if( top->is_a() == Occ::REAL ) {
	    PhiOp *p = dynamic_cast<PhiOp *>(q);
	    p->has_real_use = true;
	  } 
	}
	break;

      case Occ::PHI:
	debug("Encountered a PHI node, gave it version %d.\n", NextVersion);
	// It must be a new version
	q->version = NextVersion;
	def_point.push_back(q);
	NextVersion++;
	break;

      case Occ::REAL: { // Enclose in a block b/c I define new vars
	debug("Encountered a RealOcc.\n");
	bool same_opnds;
	RealOcc *ro = dynamic_cast<RealOcc *>(q);  // This must succeed
	

	// Go through the possible cases.
	if( OccStack.size() == 0 ) {
	  same_opnds = false; 
	} else if( top->is_a() == Occ::PHI ) {
	  debug("RealOcc is defined by PHI(%d)\n", top->block);
	  if (real_dom_phi(ro,(PHINode *)top)) {
	    same_opnds = true;
	    rename_worklist.push_back(q);
	  } else {
	    same_opnds = false;
	    ((PHINode *)top)->down_safe = false;
	  }

	} else if( top->is_a() == Occ::REAL ){
	  RealOcc *top_ro = dynamic_cast<RealOcc *>(top); // Also must succeed
	  same_opnds = true;
	  for( int i = 0; i < arg_ct; i++ ) {
	    if( ro->new_arg_name(i) != top_ro->new_arg_name(i) ) {
	      same_opnds = false;
	      break;
	    }
	  }
	} else {
	  fprintf( stderr, "Bad top for Occ.REAL\n" );
	  exit(1);
	}
	
	if( same_opnds ) {
	  q->version = top->version;
	} else {
	  // Must be new
	  q->version = NextVersion;
	  def_point.push_back(q);
	  NextVersion++;
	}
      }
	break;
	
      default:
	fprintf( stderr, "Unrecognized is_a type.\n" );
	exit(1);
      }
      OccStack.push(q);
    }
  }

  debug("Saw all occurrences for this block.  Visiting its children.\n");
  // Visit all the other children
  block = ssa->dominator_children[block->block_number];
  while( block != NULL ) {
    preorder_rename(block);
    block = block->next;
  }

  // Pop this block's occurences off the stack
  for( unsigned i = 0; list != NULL && i < list->size(); i++ ) {
    OccStack.pop();
  }

}

void ExprPRE::do_Rename_2() {
  Occ *q;
  PHINode *defphi;
  PhiOp *phiop;
  List <PhiNode*> varphi_list;
  CfgNode *block;
  int varphi_id;
    
  while( !rename_worklist.empty() ) {
    q = rename_worklist.front();
    defphi = dynamic_cast<PHINode *>(def_point[q->version]);
    if( defphi == NULL ) { fprintf(stderr, "defphi cast failed."); exit(1); }
    debug("Doing rename_2 on PHI in block(%d)\n", defphi->block);
    if( defphi->live == false ) {
      defphi->live = true;
      // Get the list of all phi nodes in the same block as defphi
      block = get_node( ssa->unit_cfg, defphi->block );
      varphi_list = ssa->phi_nodes( block );

      // Not the most efficient, but oh well.
      // Find if there is a phi in this block for any of the vars in the expr
      for( int i = 0; i < arg_ct; i++ ) {
	for( unsigned j = 0; j < varphi_list.size(); j++ ) {
	  ssa->old_opnd_catalog->lookup(varphi_list[j]->get_old_name(), &varphi_id);
	  if( arg_ids[i] == varphi_id ) {
	    // Do for each predecessor of the block
	    for( int k = 0; k < preds_size(block); k++ ) {
	      phiop = (PhiOp *)defphi->get_opnd(k);

	      if( phiop->version != Occ::BOTTOM ) {
		Opnd varphiop = varphi_list[j]->get_src(k);

		// This might add new things to the worklist...
		if( phiop_is_bottom(phiop, varphiop) ) {
		  phiop->version = Occ::BOTTOM;
		  //		  phiop->has_real_use = false;
		}
	      }
	    }
	  }
	}
   
      }
      // If any PHI operand is defined by a PHI, add it to the worklist
      
      for(int i = 0; i < defphi->num_opnds(); i++) {
	PhiOp *op = (PhiOp *)defphi->get_opnd(i);
	if(op->version != Occ::BOTTOM && def_point[op->version]->is_a() == Occ::PHI) rename_worklist.push_back(op);
      }
      
    
    }
    rename_worklist.pop_front();
  }

  // All live PHIs are now marked.
}

bool ExprPRE::phiop_is_bottom( PhiOp *phiop, Opnd varphiop ) {
  Occ *def_phiop = def_point[phiop->version];
  int var_id = 0;
  if(!ssa->new_opnd_catalog->lookup( varphiop, &var_id )) 
    debug("failed lookup on varphiop in phiop_is_bottom\n");

  if( def_phiop->is_a() == Occ::REAL ) {
    bool bottom = true;
    RealOcc *ro = dynamic_cast<RealOcc *>(def_phiop);

    for(int i = 0; i < ro->num_args(); i++ ) {
      int tmp_id;
      ssa->new_opnd_catalog->lookup(ro->new_arg_name(i), &tmp_id);
      if( tmp_id == var_id ) {
	bottom = false;
	break;
      }
    }
    return bottom;

  } else {     // def_phiop is a PHINode
    PHINode *def_phi = dynamic_cast<PHINode *>(def_phiop);
    int db = def_phi->block;
    int vb = get_number(ssa->block_map[var_id]); // Defining block for varphiop

    //    if( vb == db ) { // Both definitions are in the same block
    //  return ssa->unique_def(varphiop).is_phi_node() ? true : false;
    // } else {
    //      return ssa->dominator_analysis->dominates(vb,db) ? true : false;
    //}
    
    // I think that was backwards, it should be:
    if (vb == db) {
      return ssa->unique_def(varphiop).is_instr_handle();
    } else {
      return !ssa->dominator_analysis->dominates(vb,db);
    }

  }
}
